/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthBkptMgr;
import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.djapi.wrappers.ThreadSafeBootstrap;
import com.adobe.authoring.debug.djapi.wrappers.ThreadSafeSession;
import com.adobe.authoring.debug.djapi.wrappers.ThreadSafeSessionManager;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthThread;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.Messages;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Player;
import flash.tools.debugger.Session;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import java.text.MessageFormat;
import java.util.LinkedList;

public class AuthDebugTarget
extends AuthDebugElement {
    private FdbThread fFdbThread;
    private Thread fThread;
    private LinkedList fFdbCommands = new LinkedList();
    private String fUrl;
    private volatile int fState = 0;
    private AuthThread fAuthThread;
    private Player fPlayer;
    private volatile boolean fIsSuspended = false;

    public AuthDebugTarget(String url, Session session) throws AuthDebugException {
        super(null);
        this.fUrl = url;
        ThreadSafeSessionManager manager = ThreadSafeBootstrap.sessionManager();
        this.fPlayer = manager.playerForUri(url);
        this.fAuthThread = new AuthThread(this);
        this.fState = 1;
        this.fFdbThread = new FdbThread(session);
        this.fThread = new Thread((Runnable)this.fFdbThread, "FdbThread");
        this.fThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCommand(ICommand cmd) {
        LinkedList linkedList = this.fFdbCommands;
        synchronized (linkedList) {
            this.fFdbCommands.addLast(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICommand nextCommand() {
        LinkedList linkedList = this.fFdbCommands;
        synchronized (linkedList) {
            ICommand retval = null;
            if (this.fFdbCommands.size() > 0) {
                retval = (ICommand)this.fFdbCommands.removeFirst();
            }
            return retval;
        }
    }

    public AuthThread getMainThread() {
        return this.fAuthThread;
    }

    public String getName() {
        return this.fUrl;
    }

    public boolean canTerminate() {
        return !this.isDisconnected() && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Session session = this.getSession();
                if (session.isConnected()) {
                    session.terminate();
                }
                this.fFdbThread.setTerminated();
            }
            catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
                // empty catch block
            }
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fIsSuspended;
    }

    public void resume() {
        this.queueCommand(this.fFdbThread.new FdbThread.ResumeCommand());
    }

    public void suspend() {
        this.queueCommand(this.fFdbThread.new FdbThread.SuspendCommand());
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() {
        this.queueCommand(this.fFdbThread.new FdbThread.DisconnectCommand());
    }

    public boolean isDisconnected() {
        boolean connected = this.fFdbThread != null && this.fState != 3;
        return !connected;
    }

    public void stepInto() {
        this.queueCommand(this.fFdbThread.new FdbThread.StepIntoCommand());
    }

    public void stepOver() {
        this.queueCommand(this.fFdbThread.new FdbThread.StepOverCommand());
    }

    public void stepReturn() {
        this.queueCommand(this.fFdbThread.new FdbThread.StepReturnCommand());
    }

    public int waitFor() throws InterruptedException {
        this.fThread.join();
        return 0;
    }

    public int getStateCount() {
        return this.fStateCount;
    }

    public void stateChanged() {
        ++this.fStateCount;
    }

    public Session getSession() throws DebugElementNoLongerExistsException {
        Session session = this.fFdbThread.getSession();
        if (session == null) {
            throw new DebugElementNoLongerExistsException(3);
        }
        return session;
    }

    public Object getLock() {
        return this.fFdbThread.getLock();
    }

    public FaultEvent getCurrentFault() {
        return this.fFdbThread.getCurrentFault();
    }

    public void shutdown() {
        if (this.canTerminate()) {
            this.terminate();
        } else if (this.canDisconnect()) {
            this.disconnect();
        }
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            AuthDebugMgr.log(e);
        }
    }

    public Player getPlayer() {
        return this.fPlayer;
    }

    public AuthDebugTarget getDebugTarget() {
        return this;
    }

    private class FdbThread
    implements Runnable {
        private volatile Session fSession;
        private boolean fStepResume;
        private int fSleepLength = 25;
        private Object fSyncObj;
        private boolean fFiredCreationEvent = false;
        private volatile FaultEvent fCurrentFault;
        private int fSuspendReason = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resume() throws NotSuspendedException, NoResponseException, NotConnectedException {
            Object object = this.fSyncObj;
            synchronized (object) {
                if (this.fStepResume) {
                    this.fSession.stepContinue();
                } else {
                    this.fSession.resume();
                }
                this.setNotSuspended();
            }
        }

        private void setNotSuspended() {
            AuthDebugTarget.this.fIsSuspended = false;
            ++AuthDebugTarget.this.fStateCount;
            this.fCurrentFault = null;
        }

        public FdbThread(Session session) {
            this.fSession = session;
            this.fSyncObj = session instanceof ThreadSafeSession ? ThreadSafeSession.getSyncObject(session) : new Object();
        }

        private void processCommands() throws NotSuspendedException, NotConnectedException, NoResponseException {
            ICommand cmd;
            while ((cmd = AuthDebugTarget.this.nextCommand()) != null) {
                cmd.run();
            }
        }

        private void handleTraceEvent(TraceEvent e) {
            AuthDebugMgr.getAuthMgr().notifyTraceEvent(e);
        }

        private void handleSwfLoadedEvent(SwfLoadedEvent e) {
            AuthDebugMgr.getAuthMgr().notifySwfLoaded(e);
        }

        private void handleSwfUnloadedEvent(SwfUnloadedEvent e) {
            AuthDebugMgr.getAuthMgr().notifySwfUnloaded(e);
        }

        public void handleBreakEvent(BreakEvent e) {
        }

        private void processEvents() throws NotConnectedException {
            boolean requestResume = false;
            boolean requestHalt = false;
            while (this.haveConnection() && this.fSession.getEventCount() > 0) {
                DebugEvent e = this.fSession.nextEvent();
                if (e instanceof TraceEvent) {
                    this.handleTraceEvent((TraceEvent)e);
                    continue;
                }
                if (e instanceof SwfLoadedEvent) {
                    this.handleSwfLoadedEvent((SwfLoadedEvent)e);
                    continue;
                }
                if (e instanceof SwfUnloadedEvent) {
                    this.handleSwfUnloadedEvent((SwfUnloadedEvent)e);
                    continue;
                }
                if (e instanceof BreakEvent) {
                    this.handleBreakEvent((BreakEvent)e);
                    continue;
                }
                if (e instanceof FaultEvent) {
                    if (this.handleFaultEvent((FaultEvent)e)) {
                        requestResume = true;
                        continue;
                    }
                    requestHalt = true;
                    continue;
                }
                AuthDebugMgr.log(MessageFormat.format(Messages.getString("AuthDebugTarget.0"), e, e.information));
            }
            if (requestResume && !requestHalt && this.fSession.isSuspended()) {
                try {
                    this.resume();
                }
                catch (NotSuspendedException e) {
                    AuthDebugMgr.log(e);
                }
                catch (NoResponseException e) {
                    AuthDebugMgr.log(e);
                }
            }
            if (!this.haveConnection() || this.fSession.isSuspended()) {
                AuthDebugTarget.this.fAuthThread.setStepping(false);
            }
        }

        private boolean handleFaultEvent(FaultEvent e) {
            boolean requestResume = false;
            boolean stop = true;
            boolean print = true;
            if (stop) {
                this.fCurrentFault = e;
            } else {
                requestResume = true;
            }
            if (print) {
                AuthDebugMgr.getAuthMgr().notifyFaultEvent(e);
            }
            return requestResume;
        }

        private void installDeferredBreakpoints() {
            AuthBkptMgr bkptMgr = AuthDebugMgr.getAuthMgr().getBkptMgr();
            bkptMgr.loadBkptsFromXMLString();
        }

        private void advanceStateMachine() throws NotConnectedException {
            if (this.fSession == null) {
                this.setTerminated();
                return;
            }
            switch (AuthDebugTarget.this.fState) {
                case 1: {
                    if (!this.fSession.isSuspended()) break;
                    AuthDebugTarget.this.fState = 2;
                    break;
                }
                case 2: {
                    boolean becameSuspended;
                    boolean isSuspended = this.fSession.isSuspended();
                    boolean bl = becameSuspended = !AuthDebugTarget.this.fIsSuspended && isSuspended;
                    if (!becameSuspended) break;
                    this.fSuspendReason = this.fSession.suspendReason();
                    if (this.fSuspendReason == 7) {
                        boolean isPaused;
                        if (!this.fFiredCreationEvent) {
                            this.fFiredCreationEvent = true;
                        }
                        if (isPaused = AuthDebugMgr.getAuthMgr().checkPaused()) break;
                        this.installDeferredBreakpoints();
                        try {
                            this.resume();
                        }
                        catch (NotSuspendedException e) {
                            AuthDebugMgr.log(e);
                        }
                        catch (NoResponseException e) {
                            AuthDebugMgr.log(e);
                        }
                        break;
                    }
                    AuthDebugTarget.this.fIsSuspended = true;
                    switch (this.fSuspendReason) {
                        case 1: {
                            AuthDebugMgr.getAuthMgr().handleHalt(AuthDebugTarget.this.fAuthThread);
                            break;
                        }
                        case 5: {
                            AuthDebugMgr.getAuthMgr().handleHalt(AuthDebugTarget.this.fAuthThread);
                            break;
                        }
                        case 3: {
                            AuthDebugMgr.getAuthMgr().handleHalt(AuthDebugTarget.this.fAuthThread);
                            break;
                        }
                    }
                    AuthDebugTarget.this.stateChanged();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runInner() {
            try {
                Object object = this.fSyncObj;
                synchronized (object) {
                    try {
                        this.processCommands();
                    }
                    catch (NotSuspendedException e) {
                        AuthDebugMgr.log(e);
                    }
                    catch (NoResponseException e) {
                        AuthDebugMgr.log(e);
                    }
                    this.processEvents();
                    this.advanceStateMachine();
                }
                try {
                    Thread.sleep(this.fSleepLength);
                }
                catch (InterruptedException ignore) {}
            }
            catch (NotConnectedException e) {
                this.setTerminated();
            }
        }

        public void handleException(Throwable exception) {
            AuthDebugMgr.log(exception);
        }

        private void eventLoop() {
            do {
                try {
                    this.runInner();
                }
                catch (Exception e) {
                    AuthDebugMgr.getAuthMgr().err("", 6);
                }
            } while (this.haveConnection() && AuthDebugTarget.this.fState != 3);
        }

        public boolean haveConnection() {
            boolean have = false;
            if (this.fSession != null && this.fSession.isConnected()) {
                have = true;
            }
            return have;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.eventLoop();
            Object object = this.fSyncObj;
            synchronized (object) {
                this.setTerminated();
                if (this.haveConnection()) {
                    this.fSession.unbind();
                }
                this.fSession = null;
            }
            AuthDebugMgr.getAuthMgr().notify("", 9);
        }

        public Session getSession() {
            return this.fSession;
        }

        public void setTerminated() {
            if (AuthDebugTarget.this.fState != 3) {
                AuthDebugTarget.this.fState = 3;
                AuthDebugTarget.this.fIsSuspended = false;
                this.fCurrentFault = null;
                AuthDebugTarget.this.stateChanged();
            }
        }

        public Object getLock() {
            return this.fSyncObj;
        }

        public FaultEvent getCurrentFault() {
            return this.fCurrentFault;
        }

        public class DisconnectCommand
        implements ICommand {
            public void run() {
                if (FdbThread.this.fSession.isConnected()) {
                    FdbThread.this.fSession.unbind();
                }
                FdbThread.this.setTerminated();
            }
        }

        public class StepReturnCommand
        implements ICommand {
            public void run() throws NoResponseException, NotConnectedException {
                AuthDebugTarget.this.fAuthThread.setStepping(true);
                try {
                    FdbThread.this.fSession.stepOut();
                }
                catch (NotSuspendedException e) {
                    AuthDebugTarget.this.fAuthThread.setStepping(false);
                    return;
                }
                FdbThread.this.setNotSuspended();
            }
        }

        public class StepOverCommand
        implements ICommand {
            public void run() throws NoResponseException, NotConnectedException {
                AuthDebugTarget.this.fAuthThread.setStepping(true);
                try {
                    FdbThread.this.fSession.stepOver();
                }
                catch (NotSuspendedException e) {
                    AuthDebugTarget.this.fAuthThread.setStepping(false);
                    return;
                }
                FdbThread.this.setNotSuspended();
            }
        }

        public class StepIntoCommand
        implements ICommand {
            public void run() throws NoResponseException, NotConnectedException {
                AuthDebugTarget.this.fAuthThread.setStepping(true);
                try {
                    FdbThread.this.fSession.stepInto();
                }
                catch (NotSuspendedException e) {
                    AuthDebugTarget.this.fAuthThread.setStepping(false);
                    return;
                }
                FdbThread.this.setNotSuspended();
            }
        }

        public class ResumeCommand
        implements ICommand {
            public void run() throws NotSuspendedException, NoResponseException, NotConnectedException {
                try {
                    FdbThread.this.resume();
                }
                catch (NotSuspendedException e) {
                    return;
                }
            }
        }

        public class SuspendCommand
        implements ICommand {
            public void run() throws NotConnectedException, NoResponseException {
                try {
                    FdbThread.this.fSession.suspend();
                }
                catch (SuspendedException suspendedException) {
                    // empty catch block
                }
            }
        }
    }

    private static interface State {
        public static final int BEFORE_LAUNCH = 0;
        public static final int WAITING_FOR_INITIAL_SUSPEND = 1;
        public static final int ALIVE = 2;
        public static final int TERMINATED = 3;
    }

    public static interface ICommand {
        public void run() throws NotSuspendedException, NotConnectedException, NoResponseException;
    }
}

