/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug;

import com.adobe.authoring.debug.AuthContextMgr;
import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthMemberVariable;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.AuthStackVariable;
import com.adobe.authoring.debug.model.AuthThread;
import com.adobe.authoring.debug.model.AuthValue;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthValue;
import com.adobe.authoring.debug.model.IAuthVariable;

public class AuthXMLWriter {
    public static final String m_trueStr = "1";
    public static final String m_falseStr = "0";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void dumpPanelControlStates(StringBuffer sb, AuthThread thread) {
        sb.append("<sts>");
        sb.append("<st rs=\"");
        String enabled = thread.canResume() ? m_trueStr : m_falseStr;
        sb.append(enabled);
        sb.append("\" sp=\"");
        enabled = thread.canSuspend() ? m_trueStr : m_falseStr;
        sb.append(enabled);
        sb.append("\" tm=\"");
        enabled = thread.canTerminate() ? m_trueStr : m_falseStr;
        sb.append(enabled);
        sb.append("\" si=\"");
        enabled = thread.canStepInto() ? m_trueStr : m_falseStr;
        sb.append(enabled);
        sb.append("\" sv=\"");
        enabled = thread.canStepOver() ? m_trueStr : m_falseStr;
        sb.append(enabled);
        sb.append("\" so=\"");
        enabled = thread.canStepReturn() ? m_trueStr : m_falseStr;
        sb.append(enabled);
        sb.append("\" />");
        sb.append("</sts>");
    }

    public AuthStackFrame dumpCallStack(StringBuffer sb, AuthStackFrame[] stack) {
        AuthStackFrame topFrame = null;
        if (stack == null || stack.length == 0) {
            sb.append(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("noStackAvailable"));
        } else {
            sb.append("<bt>");
            for (int i = 0; i < stack.length; ++i) {
                sb.append("<fm l=\"");
                AuthStackFrame frame = stack[i];
                if (i == 0) {
                    topFrame = frame;
                }
                int line = frame.getLineNumber();
                String name = frame.getName();
                String fullPath = frame.getFullPath();
                boolean isASFile = fullPath != null && fullPath.endsWith(".as");
                String isASFileStr = isASFile ? m_trueStr : m_falseStr;
                sb.append(name);
                sb.append("\" f=\"");
                sb.append(isASFileStr);
                if (isASFile) {
                    sb.append("\" p=\"");
                    sb.append(fullPath);
                } else if (fullPath != null) {
                    String[] keys = fullPath.split("::");
                    if (keys.length == 2) {
                        String handlerKey = keys[0];
                        String moduleKey = keys[1];
                        sb.append("\" h=\"");
                        sb.append(handlerKey);
                        sb.append("\" m=\"");
                        sb.append(moduleKey);
                    } else {
                        sb.append("\" p=\"");
                        sb.append(fullPath);
                    }
                }
                sb.append("\" n=\"");
                sb.append(line);
                sb.append("\"");
                sb.append(" />");
            }
            sb.append("</bt>");
        }
        return topFrame;
    }

    public String dumpStackFrameVars(AuthStackFrame stackFrame) {
        StringBuffer sb = new StringBuffer();
        if (stackFrame != null) {
            IAuthVariable[] varList = stackFrame.getVariables();
            if (varList == null || varList.length == 0) {
                sb.append(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("noVariablesAvailable"));
            } else {
                sb.append("<vars>");
                this.dumpStackVariableArray(sb, varList);
                sb.append("</vars>");
            }
        }
        return sb.toString();
    }

    public String dumpRequestedTopLevelMembers(AuthStackFrame stackFrame, int varID) {
        IAuthVariable[] members;
        StringBuffer sb = new StringBuffer();
        sb.append("<vars>");
        IAuthVariable[] varList = stackFrame.getVariables();
        AuthValue val = this.getContextMgr().lookupStackVariableValue(varList, varID);
        if (val != null && (members = val.getVariables()).length > 0) {
            this.dumpMemberVariableArray(sb, members);
        }
        sb.append("</vars>");
        return sb.toString();
    }

    public void dumpStackVariableArray(StringBuffer sb, IAuthVariable[] varList) {
        for (int j = 0; j < varList.length; ++j) {
            AuthStackVariable var = (AuthStackVariable)varList[j];
            this.dumpVariable(sb, var);
        }
    }

    public String dumpRequestedMembers(AuthStackFrame stackFrame, int[] idArray) {
        IAuthVariable[] members;
        StringBuffer sb = new StringBuffer();
        sb.append("<vars>");
        AuthValue val = this.getContextMgr().lookupRequestedVariableValue(stackFrame, idArray, true);
        if (val != null && (members = val.getVariables()).length > 0) {
            this.dumpMemberVariableArray(sb, members);
        }
        sb.append("</vars>");
        return sb.toString();
    }

    public String dumpRequestedExpandedMembers(AuthStackFrame stackFrame, int[] indexArray, int[] idArray) {
        StringBuffer sb = new StringBuffer();
        sb.append("<exps>");
        for (int i = 0; i < indexArray.length; ++i) {
            IAuthVariable[] members;
            sb.append("<exp i=\"");
            sb.append(indexArray[i]);
            sb.append("\">");
            IAuthVariable[] varList = stackFrame.getVariables();
            AuthValue val = this.getContextMgr().lookupStackVariableValue(varList, idArray[i]);
            if (val != null && (members = val.getVariables()).length > 0) {
                this.dumpMemberVariableArray(sb, members);
            }
            sb.append("</exp>");
        }
        sb.append("</exps>");
        return sb.toString();
    }

    public void dumpMemberVariableArray(StringBuffer sb, IAuthVariable[] varList) {
        for (int j = 0; j < varList.length; ++j) {
            AuthMemberVariable var = (AuthMemberVariable)varList[j];
            this.dumpVariable(sb, var);
        }
    }

    public void dumpVariable(StringBuffer sb, AuthVariable var) {
        boolean varPassesFlagCheck = true;
        if (!this.getAuthMgr().showConstants() && var.isConst()) {
            varPassesFlagCheck = false;
        }
        if (varPassesFlagCheck && !this.getAuthMgr().showStatics() && var.isStatic() && !var.isConst()) {
            varPassesFlagCheck = false;
        }
        if (varPassesFlagCheck && !this.getAuthMgr().showInaccessibleMembers() && !this.isAccessible(var)) {
            varPassesFlagCheck = false;
        }
        boolean isReadOnly = var.supportsValueModification();
        if (varPassesFlagCheck) {
            try {
                String name = var.getName();
                AuthValue val = (AuthValue)var.getValue();
                String value = val.getDisplayValue(false, this.getAuthMgr().showQualifiedMembers(), this.getAuthMgr().showHexDisplay(), false);
                int varType = val.getFlashVariableType();
                if (varType == 2 || varType == 4 || val.isXml()) {
                    value = AuthXMLWriter.xmlEscape(value);
                }
                String editable = isReadOnly ? m_trueStr : m_falseStr;
                IAuthVariable[] members = val.getVariables();
                int count = members.length;
                sb.append("<var l=\"");
                sb.append(name);
                sb.append("\" t=\"");
                sb.append(varType);
                sb.append("\" v=\"");
                sb.append(value);
                sb.append("\" e=\"");
                sb.append(editable);
                if (count > 0) {
                    int id = val.getUnderlyingID();
                    sb.append("\" i=\"");
                    sb.append(id);
                    sb.append("\" c=\"");
                    sb.append(count);
                }
                sb.append("\"");
                sb.append(" />");
            }
            catch (DebugElementNoLongerExistsException e) {
                // empty catch block
            }
        }
    }

    boolean isAccessible(IAuthVariable element) {
        block16: {
            try {
                IAuthVariable parentVariable;
                IAuthValue parentValue;
                AuthMemberVariable variable;
                AuthDebugElement parentDebugElement;
                if (!(element instanceof AuthMemberVariable) || !((parentDebugElement = (variable = (AuthMemberVariable)element).getParent()) instanceof IAuthVariable) || !((parentValue = (parentVariable = (IAuthVariable)((Object)parentDebugElement)).getValue()) instanceof AuthValue)) break block16;
                int scope = variable.getScope();
                switch (scope) {
                    case 0: {
                        break;
                    }
                    case 0x2000000: {
                        break;
                    }
                    case 0x800000: 
                    case 0x1000000: {
                        AuthVariable[] scopeChain;
                        AuthStackFrame frame = AuthStackFrame.forObject(element);
                        if (frame != null && (scopeChain = frame.getScopeChain()) != null && scopeChain.length > 0) {
                            boolean found = false;
                            String declaringClassOfProtectedVar = variable.getNamespace().replace(':', '.');
                            for (int i = 0; !found && i < scopeChain.length; ++i) {
                                AuthValue authValue;
                                AuthValue.ScopeChainEntryType scopeChainEntryType;
                                IAuthValue scopeChainValue = scopeChain[i].getValue();
                                if (!(scopeChainValue instanceof AuthValue) || (scopeChainEntryType = (authValue = (AuthValue)scopeChainValue).getScopeChainEntryType()) != AuthValue.ScopeChainEntryType.STATICS_OF_CLASS) continue;
                                String classOnScopechain = authValue.getReferenceTypeName().replaceFirst("\\$$", "");
                                if (classOnScopechain.equals(declaringClassOfProtectedVar)) {
                                    found = true;
                                }
                                if (scope == 0x800000) break;
                            }
                            if (!found) {
                                return false;
                            }
                        }
                        break;
                    }
                    case 0x1800000: {
                        AuthVariable[] scopeChain;
                        AuthStackFrame frame = AuthStackFrame.forObject(element);
                        if (frame != null && (scopeChain = frame.getScopeChain()) != null && scopeChain.length > 0) {
                            boolean found = false;
                            String parentPackage = this.getPackage(parentValue);
                            for (int i = 0; !found && i < scopeChain.length; ++i) {
                                String currentPackage;
                                AuthValue authValue;
                                AuthValue.ScopeChainEntryType scopeChainEntryType;
                                IAuthValue scopeChainValue = scopeChain[i].getValue();
                                if (!(scopeChainValue instanceof AuthValue) || (scopeChainEntryType = (authValue = (AuthValue)scopeChainValue).getScopeChainEntryType()) != AuthValue.ScopeChainEntryType.MEMBERS_OF_OBJECT || !(currentPackage = this.getPackage(authValue)).equals(parentPackage)) continue;
                                found = true;
                            }
                            if (!found) {
                                return false;
                            }
                        }
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
                // empty catch block
            }
        }
        return true;
    }

    private String getPackage(IAuthValue value) {
        try {
            String type = value.getReferenceTypeName();
            int firstSlash = type.indexOf(47);
            int lastDot = type.lastIndexOf(46);
            if (lastDot > firstSlash) {
                return type.substring(firstSlash + 1, lastDot);
            }
        }
        catch (AuthDebugException authDebugException) {
            // empty catch block
        }
        return "";
    }

    private static String myReplaceAll(String str, String oldText, String newText) {
        int index;
        int start = 0;
        while (-1 != (index = str.indexOf(oldText, start))) {
            str = str.substring(0, index) + newText + str.substring(index + oldText.length());
            start = index + newText.length();
        }
        return str;
    }

    public static String xmlEscape(String str) {
        str = AuthXMLWriter.myReplaceAll(str, "&", "&amp;");
        str = AuthXMLWriter.myReplaceAll(str, "\"", "&quot;");
        str = AuthXMLWriter.myReplaceAll(str, "<", "&lt;");
        str = AuthXMLWriter.myReplaceAll(str, ">", "&gt;");
        str = AuthXMLWriter.myReplaceAll(str, "\n", "&#xa;");
        str = AuthXMLWriter.myReplaceAll(str, "\r", "&#xd;");
        str = AuthXMLWriter.myReplaceAll(str, "\t", "&#x9;");
        return str;
    }

    private AuthDebugMgr getAuthMgr() {
        return AuthDebugMgr.getAuthMgr();
    }

    private AuthContextMgr getContextMgr() {
        return AuthDebugMgr.getContextMgr();
    }

    static {
        $assertionsDisabled = !AuthXMLWriter.class.desiredAssertionStatus();
    }
}

