/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug;

import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.expression.AuthStackContext;
import com.adobe.authoring.debug.expression.AuthVariableContext;
import com.adobe.authoring.debug.expression.IllegalContext;
import com.adobe.authoring.debug.model.AuthMemberVariable;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.AuthStackVariable;
import com.adobe.authoring.debug.model.AuthValue;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthVariable;
import flash.tools.debugger.expression.Context;

public class AuthContextMgr {
    public static Context createNewContext(Object o) {
        AuthContextMgr c = AuthDebugMgr.getContextMgr();
        return c.createContext(o);
    }

    public Context createContext(Object o) {
        if (o instanceof AuthStackFrame) {
            return new AuthStackContext((AuthStackFrame)o);
        }
        if (o instanceof AuthVariable) {
            return new AuthVariableContext((AuthVariable)o);
        }
        return new IllegalContext(o);
    }

    public AuthVariable lookupRequestedVariable(AuthStackFrame stackFrame, int[] idArray, boolean getOperation) {
        int topLevelCheck = 0;
        if (getOperation) {
            topLevelCheck = 1;
        }
        if (idArray.length == topLevelCheck) {
            IAuthVariable[] varList = stackFrame.getVariables();
            return this.lookupStackVariable(varList, idArray[0]);
        }
        int varLevel = 0;
        IAuthVariable[] varList = stackFrame.getVariables();
        AuthVariable var = this.lookupStackVariable(varList, idArray[varLevel]);
        ++varLevel;
        while (varLevel < idArray.length) {
            if (var == null) continue;
            IAuthVariable[] members = var.getNestedMembers();
            var = this.lookupMemberVariable(members, idArray[varLevel]);
            ++varLevel;
        }
        return var;
    }

    public AuthValue lookupRequestedVariableValue(AuthStackFrame stackFrame, int[] idArray, boolean getOperation) {
        int topLevelCheck = 0;
        if (getOperation) {
            topLevelCheck = 1;
        }
        if (idArray.length == topLevelCheck) {
            IAuthVariable[] varList = stackFrame.getVariables();
            return this.lookupStackVariableValue(varList, idArray[0]);
        }
        int varLevel = 0;
        IAuthVariable[] varList = stackFrame.getVariables();
        AuthValue val = this.lookupStackVariableValue(varList, idArray[varLevel]);
        ++varLevel;
        while (varLevel < idArray.length) {
            if (val == null) continue;
            IAuthVariable[] members = val.getVariables();
            val = this.lookupMemberVariableValue(members, idArray[varLevel]);
            ++varLevel;
        }
        return val;
    }

    public AuthVariable lookupStackVariable(IAuthVariable[] varList, int varID) {
        if (varList != null || varList.length != 0) {
            for (int j = 0; j < varList.length; ++j) {
                AuthStackVariable var = (AuthStackVariable)varList[j];
                try {
                    AuthValue val = (AuthValue)var.getValue();
                    if (val.getUnderlyingID() == varID) {
                        return var;
                    }
                    continue;
                }
                catch (DebugElementNoLongerExistsException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public AuthVariable lookupMemberVariable(IAuthVariable[] varList, int varID) {
        if (varList != null || varList.length != 0) {
            for (int j = 0; j < varList.length; ++j) {
                AuthMemberVariable var = (AuthMemberVariable)varList[j];
                try {
                    AuthValue val = (AuthValue)var.getValue();
                    if (val.getUnderlyingID() == varID) {
                        return var;
                    }
                    continue;
                }
                catch (DebugElementNoLongerExistsException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public AuthValue lookupStackVariableValue(IAuthVariable[] varList, int varID) {
        AuthVariable var = this.lookupStackVariable(varList, varID);
        if (var != null) {
            try {
                return (AuthValue)var.getValue();
            }
            catch (DebugElementNoLongerExistsException e) {
                // empty catch block
            }
        }
        return null;
    }

    public AuthValue lookupMemberVariableValue(IAuthVariable[] varList, int varID) {
        AuthVariable var = this.lookupMemberVariable(varList, varID);
        if (var != null) {
            try {
                return (AuthValue)var.getValue();
            }
            catch (DebugElementNoLongerExistsException e) {
                // empty catch block
            }
        }
        return null;
    }

    public AuthVariable lookupVariableByName(String name, IAuthVariable[] variables) {
        if (variables == null) {
            return null;
        }
        for (int i = 0; i < variables.length; ++i) {
            AuthVariable authVariable = (AuthVariable)variables[i];
            if (!name.equals(authVariable.getName())) continue;
            return authVariable;
        }
        return null;
    }
}

