
var APIFactory = new APIFactory_Sim();
var VDiskAPI = APIFactory.getVDiskAPI();
var AccountAPI = APIFactory.getAccountAPI();
var FacilityAPI = APIFactory.getFacilityAPI();

var chooseVDiskPath = "";
var chooseType = "1";

$(document).ready(function(){
	$("#prestep").hide();
	$("#size-text").keydown(function(event) {
		if(13 == event.which) {
			$("#next").click();
		}
	});
	var driveInfojson=JSON.parse(VDiskAPI.getLocalDriveInfo());
	var selectoption=document.createElement("option");
	selectoption.value='';
	selectoption.innerText='--请选择--';

	document.getElementById("localDisk").appendChild(selectoption);
	for(var i=0;i<driveInfojson.length;i++){
      if(driveInfojson[i].freeSpaceGB!=0){
		var selectoption=document.createElement("option");
		selectoption.value=driveInfojson[i].drive;
		selectoption.innerText=driveInfojson[i].drive+"  剩余空间:"+driveInfojson[i].freeSpaceGB+"GB  "+driveInfojson[i].fsType;

		document.getElementById("localDisk").appendChild(selectoption);

	  }
    }
    
  $("#folder").click(function(){choosebindpath(1)});
  $("#disk").click(function(){choosebindpath(2)});
  
  choosebindpath(1);

});


function choosebindpath(value) {
	try{
		if ('1'== chooseType && '2' == value) {		// 由选项1变成2时重新初始化size值
			selectDiskList();
		}
		var folder= document.getElementById("divfolder");

		var disk1 = document.getElementById("divdiskspace");
		var disk2 = document.getElementById("divdiskpath");

		if ('1' == value) {
			document.getElementById('folder').checked = true;
			folder.style.display = 'block';  //此元素将显示为块级元素，此元素前后会带有换行符
			disk1.style.display = 'none';  //此元素不会被显示。
			disk2.style.display = 'none';
		}
		else if ('2' == value) {
			document.getElementById('disk').checked = true;
			folder.style.display = 'none';
			disk1.style.display = 'block';
			disk2.style.display = 'block';
		}
		chooseType = value;
	}catch(e){

	}

};

function verifyVDiskSize(size, driveInfo)
{
	var fsType;
		var freeSpaceGB;
		fsType=driveInfo.fsType;
		freeSpaceGB=driveInfo.freeSpaceGB;

		if (size==0){
			if(fsType=='NTFS'){
				uiShowBlockMsg("请输入1-" + freeSpaceGB + "的整数",undefined , 1500);
			}else{
				uiShowBlockMsg("请输入1-4的整数",undefined , 1500);
			}
			return false;
		}

		if(fsType=='NTFS'){
			if(size > freeSpaceGB){
				uiShowBlockMsg("所选磁盘剩余空间不足"+ size + "G",undefined, 1500);
				return false;
			}
		}else{
			if(fsType=='FAT32'&& size >4){
				//最大为4
				uiShowBlockMsg("您所选的磁盘是FAT32格式，不支持创建4G以上的虚拟磁盘",undefined, 1500);
				return false;
			}
		}
	return true;
}

function selectDiskList(path){
	try {
		if(path!=null){
			//$('#choosediskpath').val(path);
			chooseVDiskPath = path;
		}
		//$("#folderPathInput").val("");
	}
	catch (e) {}
}

document.getElementById('showfoldersettingdlg').onclick=function(){
	var chosenPath = '';
	try{
		chosenPath = VDiskAPI.selectSyncFolder();

		if (''!= chosenPath && undefined!= chosenPath) {
			if(/^[a-z,A-Z].*:\\$/.test(chosenPath)) {
				chosenPath += "cloud189";
			}
			$("#folderPathInput").val(chosenPath);
			//document.getElementById('choosefolderpath').value = chosenPath;
			chooseType = '1';
		}
	}catch(e){
	}
};



document.getElementById('next').onclick = function() {
	try {
		//var getjson=JSON.parse(FacilityAPI.getViewParam());
		//用户名
		var account = AccountAPI.getLoggedInAccount();
		var path;
		var size;

		var type = chooseType;
		if ('1'== type) {
			path = $("#folderPathInput").val(); //document.getElementById('choosefolderpath').value;
			//绑定用户信息
			AccountAPI.bindSyncSetting(account, path, '', 0);
			//小图标的接口

			FacilityAPI.manageView(1);

		}else {
			path = chooseVDiskPath; //document.getElementById('choosediskpath').value;
			size = $("#sizeInput").val(); //document.getElementById('choosedisksize').value;
			if(path==null||''==path){
				uiShowBlockMsg('请选择虚拟硬盘安装路径！', undefined, 1500);
				//showMessage("tips", "请选择虚拟硬盘安装路径！");
				return false;

			}
			if(size==null||''==size){
				uiShowBlockMsg('请填写虚拟硬盘占用空间！', undefined, 1500);
				// showMessage("tips", "请填写虚拟硬盘占用空间！");
				return false;

			}
			size = parseInt(size);
			var fsType;
			var freeSpaceGB;
			var driveInfojson=JSON.parse(VDiskAPI.getLocalDriveInfo());
			var found = false;
			for(var i=0;i<driveInfojson.length;i++){
				path2=driveInfojson[i].drive;
				if(path==path2){
					found = true;
					if(!verifyVDiskSize(size, driveInfojson[i])) {
						return false;
					}
					fsType=driveInfojson[i].fsType;
				}
			}
			if(!found) {
				uiShowBlockMsg('请选择创建虚拟加密磁盘的位置！', undefined, 1500);
				return false;
			}
			var  json={
				'account':'',
				'path':'',
				'size':'',
				'fsType':''
			}
			json.account = account;
			json.path=path;
			json.size=size;
			json.fsType = fsType;
			var josnString=JSON.stringify(json);
			var errorcode=FacilityAPI.redirectToView('wizard/create_vdisk.html',-1,-1,-1,-1,josnString);
			if(errorcode!=0){
				var description=getDescription(errorcode);
			}

		}
	}
	catch (e) {
		alert('error:' + e);
	}
}

document.getElementById('prestep').onclick = function() {
	try{
		//页面跳转
		var errorcode= FacilityAPI.redirectToView('wizard/login.html',-1,-1,-1,-1,'');
		if(errorcode!=0){
			var description=getDescription(errorcode);
			uiShowBlockMsg(description);
			return false;
		}

	}catch(e){
	}

}
