/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;

public class BugzillaProductPage
extends WizardPage {
    private static final String NEW_BUGZILLA_TASK_ERROR_TITLE = "New Bugzilla Task Error";
    private static final String DESCRIPTION = "Pick a product to open the new bug editor.\nPress the Update button if the product is not in the list.";
    private static final String LABEL_UPDATE = "Update Products from Repository";
    private List<String> products = null;
    private FilteredTree productList;
    private final TaskRepository repository;
    protected IPreferenceStore prefs = BugzillaUiPlugin.getDefault().getPreferenceStore();

    public BugzillaProductPage(TaskRepository repository) {
        super("Page1");
        this.setTitle("New Bugzilla Report");
        this.setDescription(DESCRIPTION);
        this.repository = repository;
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.bugzilla.ui", (String)"icons/wizban/bug-wizard.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.productList = new FilteredTree(composite, 2052, new PatternFilter());
        this.productList.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(-1, 200).create());
        final TreeViewer productViewer = this.productList.getViewer();
        productViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        productViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Collection) {
                    return ((Collection)parentElement).toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        productViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (BugzillaProductPage.this.getWizard().canFinish() && BugzillaProductPage.this.getWizard().performFinish()) {
                    ((WizardDialog)BugzillaProductPage.this.getContainer()).close();
                }
            }
        });
        this.initProducts();
        productViewer.setInput(this.products);
        productViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Status status = new Status(0, "org.eclipse.mylyn.bugzilla.ui", 0, "", null);
                if (productViewer.getSelection().isEmpty()) {
                    status = new Status(4, "org.eclipse.mylyn.bugzilla.ui", 0, "You must select a product", null);
                }
                BugzillaProductPage.this.applyToStatusLine((IStatus)status);
                BugzillaProductPage.this.isPageComplete();
                BugzillaProductPage.this.getWizard().getContainer().updateButtons();
            }
        });
        final String[] selectedProducts = this.getSelectedProducts();
        if (selectedProducts.length > 0) {
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (BugzillaProductPage.this.getControl() != null && BugzillaProductPage.this.getControl().isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    productViewer.setSelection((ISelection)new StructuredSelection((Object[])selectedProducts), true);
                    productViewer.getControl().setFocus();
                    return Status.OK_STATUS;
                }
            }.schedule(300L);
        } else {
            this.productList.setFocus();
        }
        Button updateButton = new Button(composite, 16392);
        updateButton.setText(LABEL_UPDATE);
        updateButton.setLayoutData((Object)new GridData());
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(BugzillaProductPage.this.repository.getConnectorKind());
                    BugzillaProductPage.this.getContainer().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Updating repository report options...", -1);
                            try {
                                connector.updateRepositoryConfiguration(BugzillaProductPage.this.repository, monitor);
                            }
                            catch (CoreException e) {
                                if (e.getStatus().getException() instanceof GeneralSecurityException) {
                                    StatusHandler.fail((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ui", "Bugzilla could not log you in to get the information you requested since login name or password is incorrect.\nPlease ensure your task repository is properly configured.", (Throwable)e));
                                } else if (e.getStatus().getException() instanceof IOException) {
                                    StatusHandler.fail((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ui", "Connection Error, please ensure your task repository is properly configured.", (Throwable)e));
                                } else {
                                    StatusHandler.fail((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ui", "Error updating repository attributes for " + BugzillaProductPage.this.repository.getRepositoryUrl(), (Throwable)e));
                                }
                                return;
                            }
                            RepositoryConfiguration repositoryConfiguration = null;
                            try {
                                repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)BugzillaProductPage.this.repository, (boolean)false, (IProgressMonitor)monitor);
                            }
                            catch (CoreException coreException) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Bugzilla Search Page", (String)"Unable to get configuration. Ensure proper repository configuration in Task Repositories");
                                    }
                                });
                            }
                            BugzillaProductPage.this.products = new ArrayList();
                            if (repositoryConfiguration != null) {
                                for (String product : repositoryConfiguration.getProducts()) {
                                    BugzillaProductPage.this.products.add(product);
                                }
                            }
                        }
                    });
                    productViewer.setInput((Object)BugzillaProductPage.this.products);
                }
                catch (InvocationTargetException ex) {
                    MessageDialog.openError(null, (String)"Error updating product list", (String)("Error reported:\n" + ex.getCause().getMessage()));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.setControl((Control)composite);
        this.isPageComplete();
        this.getWizard().getContainer().updateButtons();
    }

    private void initProducts() {
        try {
            this.products = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)this.repository, (boolean)false, (IProgressMonitor)new NullProgressMonitor()).getProducts();
        }
        catch (CoreException coreException) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)BugzillaProductPage.NEW_BUGZILLA_TASK_ERROR_TITLE, (String)"Unable to get products. Ensure proper repository configuration in task Repositories.");
                }
            });
        }
    }

    private String[] getSelectedProducts() {
        IStructuredSelection selection = this.getSelection();
        if (selection == null) {
            return new String[0];
        }
        ArrayList<String> products = new ArrayList<String>();
        Object element = selection.getFirstElement();
        if (element instanceof ITask) {
            ITask bugzillaTask = (ITask)element;
            if (bugzillaTask.getAttribute(BugzillaAttribute.PRODUCT.getKey()) != null) {
                products.add(bugzillaTask.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
            }
        } else {
            ITask bugzillaTask;
            IAdaptable adaptable;
            ITask task;
            IRepositoryQuery query = null;
            if (element instanceof IRepositoryQuery) {
                query = (IRepositoryQuery)element;
            }
            if (query != null) {
                String[] options;
                String queryUrl = query.getUrl();
                queryUrl = queryUrl.substring(queryUrl.indexOf("?") + 1);
                String[] stringArray = options = queryUrl.split("&");
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    String key = option.substring(0, option.indexOf("="));
                    if ("product".equals(key)) {
                        try {
                            products.add(URLDecoder.decode(option.substring(option.indexOf("=") + 1), this.repository.getCharacterEncoding()));
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    ++n2;
                }
            } else if (element instanceof IAdaptable && (task = (ITask)(adaptable = (IAdaptable)element).getAdapter(ITask.class)) != null && (bugzillaTask = (ITask)element).getAttribute(BugzillaAttribute.PRODUCT.getKey()) != null) {
                products.add(bugzillaTask.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
            }
        }
        return products.toArray(new String[products.size()]);
    }

    private IStructuredSelection getSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(null);
                this.setMessage(message, 3);
            }
        }
    }

    public String getSelectedProduct() {
        return (String)((IStructuredSelection)this.productList.getViewer().getSelection()).getFirstElement();
    }

    public boolean isPageComplete() {
        return !this.productList.getViewer().getSelection().isEmpty();
    }
}

