/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.FilteredElementTreeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.EditVariableEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.JavadocLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewVariableEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public final class BuildPathDialogAccess {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private BuildPathDialogAccess() {
    }

    public static IClasspathEntry configureSourceAttachment(Shell shell, IClasspathEntry initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        SourceAttachmentDialog dialog = new SourceAttachmentDialog(shell, initialEntry);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static URL[] configureJavadocLocation(Shell shell, String libraryName, URL initialURL) {
        if (libraryName == null) {
            throw new IllegalArgumentException();
        }
        JavadocLocationDialog dialog = new JavadocLocationDialog(shell, libraryName, initialURL);
        if (dialog.open() == 0) {
            return new URL[]{dialog.getResult()};
        }
        return null;
    }

    public static IClasspathEntry configureJavadocLocation(Shell shell, IClasspathEntry initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        URL location = JavaUI.getLibraryJavadocLocation(initialEntry);
        JavadocLocationDialog dialog = new JavadocLocationDialog(shell, BasicElementLabels.getPathLabel(initialEntry.getPath(), false), location);
        if (dialog.open() == 0) {
            CPListElement element = CPListElement.createFromExisting(initialEntry, null);
            URL res = dialog.getResult();
            element.setAttribute("javadoc_location", res != null ? res.toExternalForm() : null);
            return element.getClasspathEntry();
        }
        return null;
    }

    public static IPath configureVariableEntry(Shell shell, IPath initialEntryPath, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        EditVariableEntryDialog dialog = new EditVariableEntryDialog(shell, initialEntryPath, existingPaths);
        if (dialog.open() == 0) {
            return dialog.getPath();
        }
        return null;
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        NewVariableEntryDialog dialog = new NewVariableEntryDialog(shell);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static IClasspathEntry configureContainerEntry(Shell shell, IClasspathEntry initialEntry, IJavaProject project, IClasspathEntry[] currentClasspath) {
        IClasspathEntry[] created;
        if (initialEntry == null || currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        ClasspathContainerWizard wizard = new ClasspathContainerWizard(initialEntry, project, currentClasspath);
        if (ClasspathContainerWizard.openWizard(shell, wizard) == 0 && (created = wizard.getNewEntries()) != null && created.length == 1) {
            return created[0];
        }
        return null;
    }

    public static IClasspathEntry[] chooseContainerEntries(Shell shell, IJavaProject project, IClasspathEntry[] currentClasspath) {
        if (currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        ClasspathContainerWizard wizard = new ClasspathContainerWizard(null, project, currentClasspath);
        if (ClasspathContainerWizard.openWizard(shell, wizard) == 0) {
            return wizard.getNewEntries();
        }
        return null;
    }

    public static IPath configureJAREntry(Shell shell, IPath initialEntry, IPath[] usedEntries) {
        if (initialEntry == null || usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource;
            IPath curr = usedEntries[i];
            if (!curr.equals((Object)initialEntry) && (resource = root.findMember(usedEntries[i])) instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource existing = root.findMember(initialEntry);
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator(validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_edit_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_edit_description);
        dialog.setInitialFilter("*.jar,*.zip");
        dialog.setInput(root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection(existing);
        if (dialog.open() == 0) {
            IResource element = (IResource)dialog.getFirstResult();
            return element.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseJAREntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_new_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_JARArchiveDialog_new_description);
        dialog.setInitialFilter("*.jar,*.zip");
        dialog.setInput(root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static IPath configureExternalJAREntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtJARArchiveDialog_edit_title);
        dialog.setFilterExtensions(ArchiveFileFilter.JAR_ZIP_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        JavaPlugin.getDefault().getDialogSettings().put("org.eclipse.jdt.ui.lastextjar", dialog.getFilterPath());
        return Path.fromOSString((String)res).makeAbsolute();
    }

    public static IPath[] chooseExternalJAREntries(Shell shell) {
        String lastUsedPath = JavaPlugin.getDefault().getDialogSettings().get("org.eclipse.jdt.ui.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtJARArchiveDialog_new_title);
        dialog.setFilterExtensions(ArchiveFileFilter.ALL_ARCHIVES_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        int i = 0;
        while (i < nChosen) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
            ++i;
        }
        JavaPlugin.getDefault().getDialogSettings().put("org.eclipse.jdt.ui.lastextjar", dialog.getFilterPath());
        return elems;
    }

    public static IPath[] chooseExternalClassFolderEntries(Shell shell) {
        String lastUsedPath = JavaPlugin.getDefault().getDialogSettings().get("org.eclipse.jdt.ui.lastextjarfolder");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(shell, 2);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtClassFolderDialog_new_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_ExtClassFolderDialog_new_description);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        File file = new File(res);
        if (file.isDirectory()) {
            return new IPath[]{new Path(file.getAbsolutePath())};
        }
        return null;
    }

    public static IPath configureExternalClassFolderEntries(Shell shell, IPath initialEntry) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 4);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtClassFolderDialog_edit_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_ExtClassFolderDialog_edit_description);
        dialog.setFilterPath(initialEntry.toString());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        File file = new File(res);
        if (file.isDirectory()) {
            return new Path(file.getAbsolutePath());
        }
        return null;
    }

    public static IPath[] chooseClassFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_description;
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingSourceFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingSourceFolderDialog_new_description;
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        ArrayList<IResource> usedContainers = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IContainer) {
                usedContainers.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        Object[] used = usedContainers.toArray();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setExisting(used);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setHelpAvailable(false);
        dialog.addFilter(new TypedViewerFilter(acceptedClasses, used));
        dialog.setInput(root);
        dialog.setInitialFocus(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }
}

