/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.FindBreakContinueTargetOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindExceptionOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindImplementOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindMethodExitOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindOccurrencesInFileAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;

public class OccurrencesSearchGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindOccurrencesInFileAction fOccurrencesInFileAction;
    private FindExceptionOccurrencesAction fExceptionOccurrencesAction;
    private FindImplementOccurrencesAction fFindImplementorOccurrencesAction;
    private FindBreakContinueTargetOccurrencesAction fBreakContinueTargetOccurrencesAction;
    private FindMethodExitOccurrencesAction fMethodExitOccurrencesAction;
    static /* synthetic */ Class class$0;

    public OccurrencesSearchGroup(IWorkbenchSite site) {
        this(site, null);
    }

    public OccurrencesSearchGroup(IWorkbenchSite site, ISelectionProvider specialSelectionProvider) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(site);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(site);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(site);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
        this.fBreakContinueTargetOccurrencesAction = new FindBreakContinueTargetOccurrencesAction(site);
        this.fBreakContinueTargetOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.return.continue.targets");
        this.fMethodExitOccurrencesAction = new FindMethodExitOccurrencesAction(site);
        this.fMethodExitOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.method.exits");
        ISelectionProvider provider = specialSelectionProvider == null ? this.fSite.getSelectionProvider() : specialSelectionProvider;
        ISelection selection = provider.getSelection();
        this.registerAction(this.fOccurrencesInFileAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fExceptionOccurrencesAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindImplementorOccurrencesAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fBreakContinueTargetOccurrencesAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fMethodExitOccurrencesAction, provider, selection, specialSelectionProvider);
    }

    public OccurrencesSearchGroup(JavaEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(this.fEditor);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fEditor.setAction("SearchOccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(this.fEditor);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
        this.fEditor.setAction("SearchExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(this.fEditor);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
        this.fEditor.setAction("SearchImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
        this.fBreakContinueTargetOccurrencesAction = new FindBreakContinueTargetOccurrencesAction(this.fEditor);
        this.fBreakContinueTargetOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.return.continue.targets");
        this.fEditor.setAction("BreakContinueTargetOccurrences", (IAction)this.fBreakContinueTargetOccurrencesAction);
        this.fMethodExitOccurrencesAction = new FindMethodExitOccurrencesAction(this.fEditor);
        this.fMethodExitOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.method.exits");
        this.fEditor.setAction("ExitOccurrencesAction", (IAction)this.fMethodExitOccurrencesAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, ISelectionProvider specialSelectionProvider) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
        if (specialSelectionProvider != null) {
            action.setSpecialSelectionProvider(specialSelectionProvider);
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        String menuText = SearchMessages.group_occurrences;
        String shortcut = this.getShortcutString();
        if (shortcut != null) {
            menuText = String.valueOf(menuText) + '\t' + shortcut;
        }
        MenuManager javaSearchMM = new MenuManager(menuText, "group.search");
        javaSearchMM.add((IAction)new Action(){});
        javaSearchMM.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mm) {
                mm.removeAll();
                OccurrencesSearchGroup.this.updateActionsInJavaEditor();
                this.addAction(OccurrencesSearchGroup.this.fOccurrencesInFileAction, mm);
                this.addAction(OccurrencesSearchGroup.this.fFindImplementorOccurrencesAction, mm);
                this.addAction(OccurrencesSearchGroup.this.fExceptionOccurrencesAction, mm);
                this.addAction(OccurrencesSearchGroup.this.fMethodExitOccurrencesAction, mm);
                this.addAction(OccurrencesSearchGroup.this.fBreakContinueTargetOccurrencesAction, mm);
                if (mm.isEmpty()) {
                    mm.add((IAction)new Action(this, SearchMessages.group_occurrences_quickMenu_noEntriesAvailable){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean isEnabled() {
                            return false;
                        }
                    });
                }
            }

            private void addAction(Action action, IMenuManager mm) {
                if (action.isEnabled()) {
                    mm.add((IAction)action);
                }
            }
        });
        manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
    }

    private void updateActionsInJavaEditor() {
        if (this.fEditor == null) {
            return;
        }
        ITypeRoot element = SelectionConverter.getInput(this.fEditor);
        if (element == null) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        JavaTextSelection javaSelection = new JavaTextSelection(element, document, textSelection.getOffset(), textSelection.getLength());
        this.fExceptionOccurrencesAction.update((ISelection)javaSelection);
        this.fOccurrencesInFileAction.update((ISelection)javaSelection);
        this.fFindImplementorOccurrencesAction.update((ISelection)javaSelection);
        this.fBreakContinueTargetOccurrencesAction.update((ISelection)javaSelection);
        this.fMethodExitOccurrencesAction.update((ISelection)javaSelection);
    }

    private String getShortcutString() {
        IBindingService bindingService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return bindingService.getBestActiveBindingFormattedFor("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file.quickMenu");
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindImplementorOccurrencesAction, provider);
            this.disposeAction(this.fExceptionOccurrencesAction, provider);
            this.disposeAction(this.fOccurrencesInFileAction, provider);
            this.disposeAction(this.fMethodExitOccurrencesAction, provider);
            this.disposeAction(this.fBreakContinueTargetOccurrencesAction, provider);
        }
        super.dispose();
        this.fFindImplementorOccurrencesAction = null;
        this.fExceptionOccurrencesAction = null;
        this.fOccurrencesInFileAction = null;
        this.fMethodExitOccurrencesAction = null;
        this.fBreakContinueTargetOccurrencesAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.BreakContinueTargetOccurrences", (IAction)this.fBreakContinueTargetOccurrencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.MethodExitOccurrences", (IAction)this.fMethodExitOccurrencesAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

