/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class ConfigureWorkingSetAssignementAction
extends SelectionDispatchAction {
    private static final String[] VALID_WORKING_SET_IDS = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
    private WorkingSetModel fWorkingSetModel;
    private final IWorkbenchSite fSite;

    public ConfigureWorkingSetAssignementAction(IWorkbenchSite site) {
        super(site);
        this.fSite = site;
        this.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSets_actionLabel);
        this.setEnabled(false);
    }

    public void setWorkingSetModel(WorkingSetModel workingSetModel) {
        this.fWorkingSetModel = workingSetModel;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        List list = selection.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof IResource || object instanceof IJavaElement) continue;
            return false;
        }
        return true;
    }

    private IAdaptable[] getSelectedElements(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        List list = selection.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof IResource) && !(object instanceof IJavaElement)) continue;
            result.add(object);
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    public void run(IStructuredSelection selection) {
        IAdaptable[] elements = this.getSelectedElements(selection);
        GrayedCheckedModel model = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(elements, this.getAllWorkingSets());
        WorkingSetModelAwareSelectionDialog dialog = new WorkingSetModelAwareSelectionDialog(this.fSite.getShell(), model, elements);
        if (elements.length == 1) {
            IAdaptable element = elements[0];
            String elementName = element instanceof IResource ? BasicElementLabels.getResourceName((IResource)element) : JavaElementLabels.getElementLabel((IJavaElement)element, JavaElementLabels.ALL_DEFAULT);
            dialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_specific, elementName));
        } else {
            dialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_multi, new Integer(elements.length)));
        }
        if (dialog.open() == 0) {
            this.updateWorkingSets(dialog.getSelection(), dialog.getGrayed(), elements);
            this.selectAndReveal(elements);
        }
    }

    private static GrayedCheckedModel createGrayedCheckedModel(IAdaptable[] elements, IWorkingSet[] workingSets) {
        GrayedCheckedModelElement[] result = new GrayedCheckedModelElement[workingSets.length];
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            int checkCount = 0;
            int j = 0;
            while (j < elements.length) {
                IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(set, elements[j]);
                if (adapted != null && ConfigureWorkingSetAssignementAction.contains(set, adapted)) {
                    ++checkCount;
                }
                ++j;
            }
            result[i] = new GrayedCheckedModelElement(set, checkCount, elements.length);
            ++i;
        }
        return new GrayedCheckedModel(result);
    }

    private void updateWorkingSets(IWorkingSet[] newWorkingSets, IWorkingSet[] grayedWorkingSets, IAdaptable[] elements) {
        IAdaptable adapted;
        int j;
        HashSet<IWorkingSet> selectedSets = new HashSet<IWorkingSet>(Arrays.asList(newWorkingSets));
        HashSet<IWorkingSet> grayedSets = new HashSet<IWorkingSet>(Arrays.asList(grayedWorkingSets));
        IWorkingSet[] workingSets = this.getAllWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(workingSet) && !selectedSets.contains(workingSet) && !grayedSets.contains(workingSet)) {
                j = 0;
                while (j < elements.length) {
                    adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, elements[j]);
                    if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                        ConfigureWorkingSetAssignementAction.remove(workingSet, adapted);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newWorkingSets.length) {
            IWorkingSet set = newWorkingSets[i];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(set) && !grayedSets.contains(set)) {
                j = 0;
                while (j < elements.length) {
                    adapted = ConfigureWorkingSetAssignementAction.adapt(set, elements[j]);
                    if (adapted != null && !ConfigureWorkingSetAssignementAction.contains(set, adapted)) {
                        ConfigureWorkingSetAssignementAction.add(set, adapted);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private IWorkingSet[] getAllWorkingSets() {
        if (this.fWorkingSetModel != null) {
            return this.fWorkingSetModel.getAllWorkingSets();
        }
        return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
    }

    private static boolean isValidWorkingSet(IWorkingSet set) {
        if (set.isAggregateWorkingSet() || !set.isSelfUpdating()) {
            return false;
        }
        if (!set.isVisible()) {
            return false;
        }
        if (!set.isEditable()) {
            return false;
        }
        int i = 0;
        while (i < VALID_WORKING_SET_IDS.length) {
            if (VALID_WORKING_SET_IDS[i].equals(set.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IAdaptable adapt(IWorkingSet set, IAdaptable element) {
        IAdaptable[] adaptedElements = set.adaptElements(new IAdaptable[]{element});
        if (adaptedElements.length != 1) {
            return null;
        }
        return adaptedElements[0];
    }

    private static boolean contains(IWorkingSet set, IAdaptable adaptedElement) {
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(adaptedElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void remove(IWorkingSet workingSet, IAdaptable adaptedElement) {
        HashSet<IAdaptable> set = new HashSet<IAdaptable>(Arrays.asList(workingSet.getElements()));
        set.remove(adaptedElement);
        workingSet.setElements(set.toArray(new IAdaptable[set.size()]));
    }

    private static void add(IWorkingSet workingSet, IAdaptable adaptedElement) {
        IAdaptable[] elements = workingSet.getElements();
        IAdaptable[] newElements = new IAdaptable[elements.length + 1];
        System.arraycopy(elements, 0, newElements, 0, elements.length);
        newElements[elements.length] = adaptedElement;
        workingSet.setElements(newElements);
    }

    private void selectAndReveal(IAdaptable[] elements) {
        PackageExplorerPart explorer = this.getActivePackageExplorer();
        if (explorer != null) {
            explorer.selectReveal((ISelection)new StructuredSelection((Object[])elements));
        }
    }

    private PackageExplorerPart getActivePackageExplorer() {
        IWorkbenchPart activePart;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) instanceof PackageExplorerPart) {
            return (PackageExplorerPart)activePart;
        }
        return null;
    }

    static /* synthetic */ String[] access$2() {
        return VALID_WORKING_SET_IDS;
    }

    private static final class GrayedCheckedModel {
        private ArrayList fElements;

        public GrayedCheckedModel(GrayedCheckedModelElement[] elements) {
            this.fElements = new ArrayList<GrayedCheckedModelElement>(Arrays.asList(elements));
        }

        public void addElement(GrayedCheckedModelElement element) {
            this.fElements.add(element);
        }

        public GrayedCheckedModelElement[] getElements() {
            return this.fElements.toArray(new GrayedCheckedModelElement[this.fElements.size()]);
        }

        public GrayedCheckedModelElement[] getChecked() {
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < this.fElements.size()) {
                if (((GrayedCheckedModelElement)this.fElements.get(i)).isChecked()) {
                    result.add(this.fElements.get(i));
                }
                ++i;
            }
            return result.toArray(new GrayedCheckedModelElement[result.size()]);
        }

        public GrayedCheckedModelElement[] getGrayed() {
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < this.fElements.size()) {
                if (((GrayedCheckedModelElement)this.fElements.get(i)).isGrayed()) {
                    result.add(this.fElements.get(i));
                }
                ++i;
            }
            return result.toArray(new GrayedCheckedModelElement[result.size()]);
        }

        public void selectAll() {
            int i = 0;
            while (i < this.fElements.size()) {
                ((GrayedCheckedModelElement)this.fElements.get(i)).select();
                ++i;
            }
        }

        public void deselectAll() {
            int i = 0;
            while (i < this.fElements.size()) {
                ((GrayedCheckedModelElement)this.fElements.get(i)).deselect();
                ++i;
            }
        }
    }

    private static final class GrayedCheckedModelContentProvider
    implements IStructuredContentProvider {
        private GrayedCheckedModelElement[] fElements;

        private GrayedCheckedModelContentProvider() {
        }

        public Object[] getElements(Object element) {
            return this.fElements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fElements = newInput instanceof GrayedCheckedModel ? ((GrayedCheckedModel)newInput).getElements() : new GrayedCheckedModelElement[0];
        }
    }

    private static final class GrayedCheckedModelElement {
        private final IWorkingSet fWorkingSet;
        private final int fElementCount;
        private int fCheckCount;

        public GrayedCheckedModelElement(IWorkingSet workingSet, int checkCount, int elementCount) {
            this.fWorkingSet = workingSet;
            this.fCheckCount = checkCount;
            this.fElementCount = elementCount;
        }

        public IWorkingSet getWorkingSet() {
            return this.fWorkingSet;
        }

        public int getCheckCount() {
            return this.fCheckCount;
        }

        public boolean isGrayed() {
            return this.isChecked() && this.fCheckCount < this.fElementCount;
        }

        public boolean isChecked() {
            return this.fCheckCount > 0;
        }

        public void deselect() {
            this.fCheckCount = 0;
        }

        public void select() {
            this.fCheckCount = this.fElementCount;
        }

        public int getElementCount() {
            return this.fElementCount;
        }
    }

    private class GrayedCheckedModelLabelProvider
    extends LabelProvider {
        private Map fIcons = new Hashtable();

        public void dispose() {
            Iterator iterator = this.fIcons.values().iterator();
            while (iterator.hasNext()) {
                Image icon = (Image)iterator.next();
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            IWorkingSet workingSet = ((GrayedCheckedModelElement)object).getWorkingSet();
            ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = (Image)this.fIcons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            GrayedCheckedModelElement modelElement = (GrayedCheckedModelElement)object;
            IWorkingSet workingSet = modelElement.getWorkingSet();
            if (!modelElement.isGrayed()) {
                return BasicElementLabels.getWorkingSetLabel(workingSet);
            }
            return Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_XofY_label, new Object[]{BasicElementLabels.getWorkingSetLabel(workingSet), new Integer(modelElement.getCheckCount()), new Integer(modelElement.getElementCount())});
        }
    }

    private final class WorkingSetModelAwareSelectionDialog
    extends SelectionDialog {
        private CheckboxTableViewer fTableViewer;
        private boolean fShowVisibleOnly;
        private GrayedCheckedModel fModel;
        private final IAdaptable[] fElements;
        private final ArrayList fCreatedWorkingSets;

        private WorkingSetModelAwareSelectionDialog(Shell shell, GrayedCheckedModel model, IAdaptable[] elements) {
            super(shell);
            this.setTitle(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSetAssignments_title);
            this.setHelpAvailable(false);
            this.fModel = model;
            this.fShowVisibleOnly = true;
            this.fElements = elements;
            this.fCreatedWorkingSets = new ArrayList();
        }

        public IWorkingSet[] getGrayed() {
            GrayedCheckedModelElement[] grayed = this.fModel.getGrayed();
            IWorkingSet[] result = new IWorkingSet[grayed.length];
            int i = 0;
            while (i < grayed.length) {
                result[i] = grayed[i].getWorkingSet();
                ++i;
            }
            return result;
        }

        public IWorkingSet[] getSelection() {
            GrayedCheckedModelElement[] checked = this.fModel.getChecked();
            IWorkingSet[] result = new IWorkingSet[checked.length];
            int i = 0;
            while (i < checked.length) {
                result[i] = checked[i].getWorkingSet();
                ++i;
            }
            return result;
        }

        protected final Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setFont(parent.getFont());
            this.createMessageArea(composite);
            Composite inner = new Composite(composite, 0);
            inner.setFont(composite.getFont());
            inner.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            inner.setLayout((Layout)layout);
            Composite tableComposite = new Composite(inner, 0);
            tableComposite.setFont(composite.getFont());
            tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            tableComposite.setLayout((Layout)layout);
            this.fTableViewer = this.createTableViewer(tableComposite);
            this.createShowVisibleOnly(tableComposite);
            this.createRightButtonBar(inner);
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void createRightButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            composite.setLayoutData((Object)new GridData(1040));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Button selectAll = new Button(composite, 8);
            selectAll.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_SelectAll_button);
            selectAll.setFont(composite.getFont());
            this.setButtonLayoutData(selectAll);
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).setAllChecked(true);
                    WorkingSetModelAwareSelectionDialog.access$2(this.this$1).selectAll();
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).setGrayedElements(new Object[0]);
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).refresh();
                }
            });
            Button deselectAll = new Button(composite, 8);
            deselectAll.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DeselectAll_button);
            deselectAll.setFont(composite.getFont());
            this.setButtonLayoutData(deselectAll);
            deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).setAllChecked(false);
                    WorkingSetModelAwareSelectionDialog.access$2(this.this$1).deselectAll();
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).setGrayedElements(new Object[0]);
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).refresh();
                }
            });
            new Label(composite, 0);
            Button newWorkingSet = new Button(composite, 8);
            newWorkingSet.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_New_button);
            newWorkingSet.setFont(composite.getFont());
            this.setButtonLayoutData(newWorkingSet);
            newWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    IWorkingSet workingSet;
                    IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                    IWorkingSetNewWizard wizard = manager.createWorkingSetNewWizard(ConfigureWorkingSetAssignementAction.access$2());
                    if (wizard == null) {
                        return;
                    }
                    WizardDialog dialog = new WizardDialog(this.this$1.getShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0 && ConfigureWorkingSetAssignementAction.access$1(workingSet = wizard.getSelection())) {
                        this.this$1.addNewWorkingSet(workingSet);
                        manager.addWorkingSet(workingSet);
                        WorkingSetModelAwareSelectionDialog.access$3(this.this$1).add(workingSet);
                    }
                }
            });
        }

        protected CheckboxTableViewer createTableViewer(Composite parent) {
            CheckboxTableViewer result = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
            result.addCheckStateListener(new ICheckStateListener(this, result){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                private final /* synthetic */ CheckboxTableViewer val$result;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                    this.val$result = checkboxTableViewer;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    GrayedCheckedModelElement element = (GrayedCheckedModelElement)event.getElement();
                    this.val$result.setGrayed((Object)element, false);
                    if (event.getChecked()) {
                        element.select();
                    } else {
                        element.deselect();
                    }
                    this.val$result.update((Object)element, null);
                }
            });
            GridData data = new GridData(1808);
            data.heightHint = this.convertHeightInCharsToPixels(20);
            data.widthHint = this.convertWidthInCharsToPixels(50);
            result.getTable().setLayoutData((Object)data);
            result.getTable().setFont(parent.getFont());
            result.addFilter((ViewerFilter)new Filter());
            result.setLabelProvider((IBaseLabelProvider)new GrayedCheckedModelLabelProvider());
            result.setSorter((ViewerSorter)new GrayedCheckModelElementSorter());
            result.setContentProvider((IContentProvider)new GrayedCheckedModelContentProvider());
            result.setInput((Object)this.fModel);
            result.setCheckedElements((Object[])this.fModel.getChecked());
            result.setGrayedElements((Object[])this.fModel.getGrayed());
            return result;
        }

        protected void addNewWorkingSet(IWorkingSet workingSet) {
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel != null) {
                ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.addActiveWorkingSet(workingSet);
            }
            int checkCount = 0;
            int i = 0;
            while (i < this.fElements.length) {
                IAdaptable adapted = ConfigureWorkingSetAssignementAction.adapt(workingSet, this.fElements[i]);
                if (adapted != null && ConfigureWorkingSetAssignementAction.contains(workingSet, adapted)) {
                    ++checkCount;
                }
                ++i;
            }
            GrayedCheckedModelElement element = new GrayedCheckedModelElement(workingSet, checkCount, this.fElements.length);
            this.fModel.addElement(element);
            this.fTableViewer.setInput((Object)this.fModel);
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }

        private void createShowVisibleOnly(Composite parent) {
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                return;
            }
            Composite bar = new Composite(parent, 0);
            bar.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            bar.setLayout((Layout)gridLayout);
            Button showVisibleOnly = new Button(bar, 32);
            showVisibleOnly.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_OnlyShowVisible_check);
            showVisibleOnly.setSelection(this.fShowVisibleOnly);
            showVisibleOnly.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
            showVisibleOnly.addSelectionListener((SelectionListener)new SelectionAdapter(this, showVisibleOnly){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                private final /* synthetic */ Button val$showVisibleOnly;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                    this.val$showVisibleOnly = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    WorkingSetModelAwareSelectionDialog.access$4(this.this$1, this.val$showVisibleOnly.getSelection());
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).refresh();
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).setCheckedElements((Object[])WorkingSetModelAwareSelectionDialog.access$2(this.this$1).getChecked());
                    WorkingSetModelAwareSelectionDialog.access$1(this.this$1).setGrayedElements((Object[])WorkingSetModelAwareSelectionDialog.access$2(this.this$1).getGrayed());
                }
            });
            Link ppwsLink = new Link(bar, 0);
            ppwsLink.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_OnlyShowVisible_link);
            ppwsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
            ppwsLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>(Arrays.asList(ConfigureWorkingSetAssignementAction.access$0(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).getAllWorkingSets()));
                    IWorkingSet[] activeWorkingSets = ConfigureWorkingSetAssignementAction.access$0(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).getActiveWorkingSets();
                    WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(this.this$1.getShell(), workingSets.toArray(new IWorkingSet[workingSets.size()]), activeWorkingSets);
                    dialog.setSelection(activeWorkingSets);
                    if (dialog.open() == 0) {
                        IWorkingSet[] selection = dialog.getSelection();
                        ConfigureWorkingSetAssignementAction.access$0(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).setActiveWorkingSets(selection);
                    }
                    WorkingSetModelAwareSelectionDialog.access$5(this.this$1);
                }
            });
        }

        private void recalculateCheckedState() {
            this.fModel = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(this.fElements, ConfigureWorkingSetAssignementAction.this.getAllWorkingSets());
            this.fTableViewer.setInput((Object)this.fModel);
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
        }

        protected void cancelPressed() {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            int i = 0;
            while (i < this.fCreatedWorkingSets.size()) {
                manager.removeWorkingSet((IWorkingSet)this.fCreatedWorkingSets.get(i));
                ++i;
            }
            super.cancelPressed();
        }

        static /* synthetic */ CheckboxTableViewer access$1(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fTableViewer;
        }

        static /* synthetic */ GrayedCheckedModel access$2(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fModel;
        }

        static /* synthetic */ ArrayList access$3(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fCreatedWorkingSets;
        }

        static /* synthetic */ void access$4(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog, boolean bl) {
            workingSetModelAwareSelectionDialog.fShowVisibleOnly = bl;
        }

        static /* synthetic */ void access$5(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            workingSetModelAwareSelectionDialog.recalculateCheckedState();
        }

        private class Filter
        extends ViewerFilter {
            private Filter() {
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                GrayedCheckedModelElement model = (GrayedCheckedModelElement)element;
                IWorkingSet set = model.getWorkingSet();
                return this.accept(set);
            }

            private boolean accept(IWorkingSet set) {
                if (!ConfigureWorkingSetAssignementAction.isValidWorkingSet(set)) {
                    return false;
                }
                if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                    return true;
                }
                return !WorkingSetModelAwareSelectionDialog.this.fShowVisibleOnly || ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.isActiveWorkingSet(set);
            }
        }

        private final class GrayedCheckModelElementSorter
        extends ViewerSorter {
            private GrayedCheckModelElementSorter() {
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                GrayedCheckedModelElement w1 = (GrayedCheckedModelElement)e1;
                GrayedCheckedModelElement w2 = (GrayedCheckedModelElement)e2;
                if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                    return Collator.getInstance().compare(w1.getWorkingSet().getLabel(), w2.getWorkingSet().getLabel());
                }
                IWorkingSet[] activeWorkingSets = ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getActiveWorkingSets();
                int i = 0;
                while (i < activeWorkingSets.length) {
                    IWorkingSet active = activeWorkingSets[i];
                    if (active == w1.getWorkingSet()) {
                        return -1;
                    }
                    if (active == w2.getWorkingSet()) {
                        return 1;
                    }
                    ++i;
                }
                return Collator.getInstance().compare(w1.getWorkingSet().getLabel(), w2.getWorkingSet().getLabel());
            }
        }
    }
}

