/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.workingsets.JavaWorkingSetPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class NewJavaWorkingSetWizard
extends Wizard
implements INewWizard {
    private JavaWorkingSetPage fPage;
    private IStructuredSelection fSelection;

    public NewJavaWorkingSetWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAVA_WORKINGSET);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.NewJavaWorkingSetWizard_title);
        this.fPage = null;
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new JavaWorkingSetPage();
            this.fPage.setInitialSelection(this.fSelection);
        }
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.finish();
        IWorkingSet ws = this.fPage.getSelection();
        if (ws != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().addWorkingSet(ws);
            PackageExplorerPart explorer = this.getActivePackageExplorer();
            if (explorer != null && explorer.getRootMode() == 2 && MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getWindowTitle(), (String)NewWizardMessages.NewJavaWorkingSetWizard_add_as_root_message)) {
                explorer.getWorkingSetModel().addActiveWorkingSet(ws);
                explorer.selectReveal((ISelection)new StructuredSelection((Object)ws));
            }
        }
        return true;
    }

    private PackageExplorerPart getActivePackageExplorer() {
        IWorkbenchPart activePart;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) instanceof PackageExplorerPart) {
            return (PackageExplorerPart)activePart;
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }
}

