/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class ElementValidator {
    static /* synthetic */ Class class$0;

    private ElementValidator() {
    }

    public static boolean checkInSync(IAdaptable element, Shell parent, String title) {
        return ElementValidator.checkInSync(new IAdaptable[]{element}, parent, title);
    }

    public static boolean checkInSync(IAdaptable[] elements, Shell parent, String title) {
        return ElementValidator.checkInSync(ElementValidator.getResources(elements), parent, title);
    }

    public static boolean checkValidateEdit(IJavaElement element, Shell parent, String title) {
        return ElementValidator.checkValidateEdit(new IJavaElement[]{element}, parent, title);
    }

    public static boolean checkValidateEdit(IJavaElement[] elements, Shell parent, String title) {
        return ElementValidator.checkValidateEdit(ElementValidator.getResources((IAdaptable[])elements), parent, title);
    }

    public static boolean check(IJavaElement element, Shell parent, String title, boolean editor) {
        return ElementValidator.check(new IJavaElement[]{element}, parent, title, editor);
    }

    public static boolean check(IJavaElement[] elements, Shell parent, String title, boolean editor) {
        IResource[] resources = ElementValidator.getResources((IAdaptable[])elements);
        if (!editor && !ElementValidator.checkInSync(resources, parent, title)) {
            return false;
        }
        return ElementValidator.checkValidateEdit(resources, parent, title);
    }

    private static boolean checkInSync(IResource[] resources, Shell parent, String title) {
        IStatus status = Resources.checkInSync(resources);
        if (status.isOK()) {
            return true;
        }
        ErrorDialog.openError((Shell)parent, (String)title, (String)JavaUIMessages.ElementValidator_cannotPerform, (IStatus)status);
        return false;
    }

    private static boolean checkValidateEdit(IResource[] resources, Shell parent, String title) {
        IStatus status = Resources.makeCommittable(resources, (Object)parent);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)parent, (String)title, (String)JavaUIMessages.ElementValidator_cannotPerform, (IStatus)status);
            return false;
        }
        return true;
    }

    private static IResource[] getResources(IAdaptable[] elements) {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < elements.length) {
            IAdaptable element = elements[i];
            IResource resource = null;
            if (element instanceof IJavaElement) {
                IJavaElement je = (IJavaElement)element;
                ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
                if (cu != null) {
                    je = cu.getPrimary();
                }
                resource = je.getResource();
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)element.getAdapter((Class)clazz);
            }
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }
}

