/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.NewAnnotationCreationWizard;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewEnumCreationWizard;
import org.eclipse.jdt.internal.ui.wizards.NewInterfaceCreationWizard;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.wizards.NewAnnotationWizardPage;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewEnumWizardPage;
import org.eclipse.jdt.ui.wizards.NewInterfaceWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class NewCUUsingWizardProposal
extends ChangeCorrectionProposal {
    public static final int K_CLASS = 1;
    public static final int K_INTERFACE = 2;
    public static final int K_ENUM = 3;
    public static final int K_ANNOTATION = 4;
    private Name fNode;
    private ICompilationUnit fCompilationUnit;
    private int fTypeKind;
    private IJavaElement fTypeContainer;
    private String fTypeNameWithParameters;
    private IType fCreatedType;
    private boolean fShowDialog;

    public NewCUUsingWizardProposal(ICompilationUnit cu, Name node, int typeKind, IJavaElement typeContainer, int severity) {
        super("", null, severity, null);
        this.fCompilationUnit = cu;
        this.fNode = node;
        this.fTypeKind = typeKind;
        this.fTypeContainer = typeContainer;
        this.fTypeNameWithParameters = NewCUUsingWizardProposal.getTypeName(typeKind, node);
        this.fCreatedType = null;
        String containerName = ASTNodes.getQualifier(node);
        String typeName = this.fTypeNameWithParameters;
        String containerLabel = BasicElementLabels.getJavaElementName(containerName);
        String typeLabel = BasicElementLabels.getJavaElementName(typeName);
        boolean isInnerType = typeContainer instanceof IType;
        switch (typeKind) {
            case 1: {
                this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.class_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_description, typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_intype_description, new String[]{typeLabel, containerLabel}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_description, typeLabel));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_inpackage_description, new String[]{typeLabel, containerLabel}));
                break;
            }
            case 2: {
                this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.int_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_description, typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_intype_description, new String[]{typeLabel, containerLabel}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_description, typeLabel));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_inpackage_description, new String[]{typeLabel, containerLabel}));
                break;
            }
            case 3: {
                this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.enum_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_description, typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_intype_description, new String[]{typeLabel, containerLabel}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_description, typeLabel));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_inpackage_description, new String[]{typeLabel, containerLabel}));
                break;
            }
            case 4: {
                this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.annotation_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_description, typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_intype_description, new String[]{typeLabel, containerLabel}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_description, typeLabel));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_inpackage_description, new String[]{typeLabel, containerLabel}));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type kind");
            }
        }
        this.fShowDialog = true;
    }

    private static String getTypeName(int typeKind, Name node) {
        ASTNode parent;
        String name = ASTNodes.getSimpleNameIdentifier(node);
        if ((typeKind == 1 || typeKind == 2) && (parent = node.getParent()).getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
            String typeArgBaseName = name.startsWith(String.valueOf('T')) ? String.valueOf('S') : String.valueOf('T');
            int nTypeArgs = ((ParameterizedType)parent.getParent()).typeArguments().size();
            StringBuffer buf = new StringBuffer(name);
            buf.append('<');
            if (nTypeArgs == 1) {
                buf.append(typeArgBaseName);
            } else {
                int i = 0;
                while (i < nTypeArgs) {
                    if (i != 0) {
                        buf.append(", ");
                    }
                    buf.append(typeArgBaseName).append(i + 1);
                    ++i;
                }
            }
            buf.append('>');
            return buf.toString();
        }
        return name;
    }

    public void apply(IDocument document) {
        StructuredSelection selection = new StructuredSelection((Object)this.fCompilationUnit);
        NewElementWizard wizard = this.createWizard(selection);
        wizard.init(JavaPlugin.getDefault().getWorkbench(), (IStructuredSelection)selection);
        IType createdType = null;
        if (this.fShowDialog) {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            dialog.getShell().setText(CorrectionMessages.NewCUCompletionUsingWizardProposal_dialogtitle);
            if (dialog.open() == 0) {
                createdType = (IType)wizard.getCreatedElement();
            }
        } else {
            wizard.addPages();
            try {
                NewTypeWizardPage page = this.getPage(wizard);
                page.createType(null);
                createdType = page.getCreatedType();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (createdType != null) {
            IJavaElement container = createdType.getParent();
            if (container instanceof ICompilationUnit) {
                container = container.getParent();
            }
            if (!container.equals(this.fTypeContainer)) {
                try {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    rewrite.addImport(createdType.getFullyQualifiedName('.'));
                    JavaModelUtil.applyEdit(this.fCompilationUnit, rewrite.rewriteImports(null), false, null);
                }
                catch (CoreException coreException) {}
            }
            this.fCreatedType = createdType;
        }
    }

    private NewTypeWizardPage getPage(NewElementWizard wizard) {
        IWizardPage[] pages = wizard.getPages();
        Assert.isTrue((pages.length > 0 && pages[0] instanceof NewTypeWizardPage ? 1 : 0) != 0);
        return (NewTypeWizardPage)pages[0];
    }

    private NewElementWizard createWizard(StructuredSelection selection) {
        switch (this.fTypeKind) {
            case 1: {
                NewClassWizardPage page = new NewClassWizardPage();
                page.init((IStructuredSelection)selection);
                this.configureWizardPage(page);
                return new NewClassCreationWizard(page, true);
            }
            case 2: {
                NewInterfaceWizardPage page = new NewInterfaceWizardPage();
                page.init((IStructuredSelection)selection);
                this.configureWizardPage(page);
                return new NewInterfaceCreationWizard(page, true);
            }
            case 3: {
                NewEnumWizardPage page = new NewEnumWizardPage();
                page.init((IStructuredSelection)selection);
                this.configureWizardPage(page);
                return new NewEnumCreationWizard(page, true);
            }
            case 4: {
                NewAnnotationWizardPage page = new NewAnnotationWizardPage();
                page.init((IStructuredSelection)selection);
                this.configureWizardPage(page);
                return new NewAnnotationCreationWizard(page, true);
            }
        }
        throw new IllegalArgumentException();
    }

    private void configureWizardPage(NewTypeWizardPage page) {
        this.fillInWizardPageName(page);
        this.fillInWizardPageSuperTypes(page);
    }

    private void fillInWizardPageName(NewTypeWizardPage page) {
        page.setTypeName(this.fTypeNameWithParameters, this.fTypeNameWithParameters.indexOf(60) != -1);
        boolean isInEnclosingType = this.fTypeContainer instanceof IType;
        if (isInEnclosingType) {
            page.setEnclosingType((IType)this.fTypeContainer, true);
        } else {
            page.setPackageFragment((IPackageFragment)this.fTypeContainer, true);
        }
        page.setEnclosingTypeSelection(isInEnclosingType, true);
    }

    private void fillInWizardPageSuperTypes(NewTypeWizardPage page) {
        ITypeBinding type = this.getPossibleSuperTypeBinding((ASTNode)this.fNode);
        if ((type = Bindings.normalizeTypeBinding(type)) != null) {
            if (type.isArray()) {
                type = type.getElementType();
            }
            if (type.isTopLevel() || type.isMember()) {
                if (type.isClass() && this.fTypeKind == 1) {
                    page.setSuperClass(type.getQualifiedName(), true);
                } else if (type.isInterface()) {
                    ArrayList<String> superInterfaces = new ArrayList<String>();
                    superInterfaces.add(type.getQualifiedName());
                    page.setSuperInterfaces(superInterfaces, true);
                }
            }
        }
    }

    private ITypeBinding getPossibleSuperTypeBinding(ASTNode node) {
        if (this.fTypeKind == 4) {
            return null;
        }
        AST ast = node.getAST();
        node = ASTNodes.getNormalizedNode(node);
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 31: {
                if (node.getLocationInParent() != MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) break;
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 53: {
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 44: {
                if (parent.getLocationInParent() != CatchClause.EXCEPTION_PROPERTY) break;
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 23: 
            case 60: {
                return null;
            }
            case 74: {
                return null;
            }
        }
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference(node);
        if (binding != null && !binding.isRecovered()) {
            return binding;
        }
        return null;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        switch (this.fTypeKind) {
            case 1: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_info);
                break;
            }
            case 2: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_info);
                break;
            }
            case 3: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_info);
                break;
            }
            case 4: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_info);
            }
        }
        buf.append("<br>");
        buf.append("<br>");
        if (this.fTypeContainer instanceof IType) {
            buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_enclosingtype);
        } else {
            buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_package);
        }
        buf.append(" <b>");
        buf.append(JavaElementLabels.getElementLabel(this.fTypeContainer, 262144L));
        buf.append("</b><br>");
        buf.append("public ");
        switch (this.fTypeKind) {
            case 1: {
                buf.append("class <b>");
                break;
            }
            case 2: {
                buf.append("interface <b>");
                break;
            }
            case 3: {
                buf.append("enum <b>");
                break;
            }
            case 4: {
                buf.append("@interface <b>");
            }
        }
        this.nameToHTML(this.fTypeNameWithParameters, buf);
        ITypeBinding superclass = this.getPossibleSuperTypeBinding((ASTNode)this.fNode);
        if (superclass != null) {
            if (superclass.isClass()) {
                if (this.fTypeKind == 1) {
                    buf.append("</b> extends <b>");
                    this.nameToHTML(BindingLabelProvider.getBindingLabel((IBinding)superclass, BindingLabelProvider.DEFAULT_TEXTFLAGS), buf);
                }
            } else {
                if (this.fTypeKind == 2) {
                    buf.append("</b> extends <b>");
                } else {
                    buf.append("</b> implements <b>");
                }
                this.nameToHTML(BindingLabelProvider.getBindingLabel((IBinding)superclass, BindingLabelProvider.DEFAULT_TEXTFLAGS), buf);
            }
        }
        buf.append("</b> {<br>}<br>");
        return buf.toString();
    }

    private void nameToHTML(String name, StringBuffer buf) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == '<') {
                buf.append("&lt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
    }

    public boolean isShowDialog() {
        return this.fShowDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    public int getTypeKind() {
        return this.fTypeKind;
    }
}

