/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class ChangeCorrectionProposal
implements IJavaCompletionProposal,
ICommandAccess,
ICompletionProposalExtension6 {
    private Change fChange;
    private String fName;
    private int fRelevance;
    private Image fImage;
    private String fCommandId;
    static /* synthetic */ Class class$0;

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
        this.fImage = image;
        this.fCommandId = null;
    }

    public void apply(IDocument document) {
        try {
            this.performChange(JavaPlugin.getActivePage().getActiveEditor(), document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.ChangeCorrectionProposal_error_title, CorrectionMessages.ChangeCorrectionProposal_error_message);
        }
    }

    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        block16: {
            Change change = null;
            IRewriteTarget rewriteTarget = null;
            try {
                Change undoChange;
                change = this.getChange();
                if (change == null) break block16;
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((rewriteTarget = (IRewriteTarget)activeEditor.getAdapter((Class)clazz)) != null) {
                        rewriteTarget.beginCompoundChange();
                    }
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, JavaPlugin.getPluginId(), 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange(change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed(change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getName(), undoChange);
                }
            }
            finally {
                if (rewriteTarget != null) {
                    rewriteTarget.endCompoundChange();
                }
                if (change != null) {
                    change.dispose();
                }
            }
        }
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf;
        block3: {
            String name;
            block4: {
                buf = new StringBuffer();
                buf.append("<p>");
                Change change = this.getChange();
                if (change == null) break block3;
                name = change.getName();
                if (name.length() != 0) break block4;
                return null;
            }
            try {
                buf.append(name);
            }
            catch (CoreException e) {
                buf.append("Unexpected error when accessing this proposal:<p><pre>");
                buf.append(e.getLocalizedMessage());
                buf.append("</pre>");
            }
        }
        return null;
        buf.append("</p>");
        return buf.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.getName(), shortCutString});
        }
        return this.getName();
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.getName());
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            String decorated = Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.getName(), shortCutString});
            return ColoringLabelProvider.decorateStyledString(str, decorated, StyledString.QUALIFIER_STYLER);
        }
        return str;
    }

    public String getName() {
        return this.fName;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public final Change getChange() throws CoreException {
        if (this.fChange == null) {
            this.fChange = this.createChange();
        }
        return this.fChange;
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public String getCommandId() {
        return this.fCommandId;
    }

    public void setCommandId(String commandId) {
        this.fCommandId = commandId;
    }
}

