/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class MoveInstanceMethodWizard
extends RefactoringWizard {
    protected static boolean DEFAULT_CREATE_DELEGATOR_SETTING = false;
    protected static boolean DEFAULT_DEPRECATE_DELEGATOR_SETTING = false;
    protected final MoveInstanceMethodProcessor fProcessor;

    public MoveInstanceMethodWizard(MoveInstanceMethodProcessor processor, Refactoring refactoring) {
        super(refactoring, 4);
        this.fProcessor = processor;
        this.setDefaultPageTitle(RefactoringMessages.MoveInstanceMethodWizard_Move_Method);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInstanceMethodPage());
    }

    public final class MoveInstanceMethodPage
    extends UserInputWizardPage {
        protected static final String PAGE_NAME = "MoveInstanceMethodPage";
        protected Button fLeaveDelegateCheckBox = null;
        protected Button fDeprecateDelegateCheckBox = null;
        protected Text fMethodNameField = null;
        protected RefactoringStatus fMethodNameStatus = new RefactoringStatus();
        protected Text fTargetNameField = null;
        protected Label fTargetNameLabel = null;
        protected RefactoringStatus fTargetNameStatus = new RefactoringStatus();
        protected RefactoringStatus fTargetTypeStatus = new RefactoringStatus();

        public MoveInstanceMethodPage() {
            super(PAGE_NAME);
        }

        public void createControl(Composite parent) {
            Assert.isNotNull((Object)parent);
            Composite control = new Composite(parent, 0);
            this.setControl((Control)control);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            control.setLayout((Layout)layout);
            Label label = new Label(control, 4);
            label.setText(Messages.format(RefactoringMessages.MoveInstanceMethodPage_New_receiver, JavaElementLabels.getElementLabel((IJavaElement)MoveInstanceMethodWizard.this.fProcessor.getMethod(), JavaElementLabels.ALL_DEFAULT | 0x40L | 4L | 2L)));
            GridData data = new GridData();
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            TableLayoutComposite composite = new TableLayoutComposite(control, 0);
            composite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            composite.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
            Table table = new Table((Composite)composite, 67588);
            table.setHeaderVisible(true);
            table.setLinesVisible(false);
            TableColumn column = new TableColumn(table, 0);
            column.setText(RefactoringMessages.MoveInstanceMethodPage_Name);
            column.setResizable(true);
            column = new TableColumn(table, 0);
            column.setText(RefactoringMessages.MoveInstanceMethodPage_Type);
            column.setResizable(true);
            TableViewer viewer = new TableViewer(table);
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new TargetLabelProvider());
            IVariableBinding[] candidateTargets = MoveInstanceMethodWizard.this.fProcessor.getCandidateTargets();
            viewer.setInput((Object)candidateTargets);
            IVariableBinding[] possibleTargets = MoveInstanceMethodWizard.this.fProcessor.getPossibleTargets();
            viewer.setSelection((ISelection)new StructuredSelection(new Object[]{possibleTargets[0]}));
            viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ MoveInstanceMethodPage this$1;
                {
                    this.this$1 = moveInstanceMethodPage;
                }

                public final void selectionChanged(SelectionChangedEvent event) {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (element instanceof IVariableBinding) {
                        IVariableBinding target = (IVariableBinding)element;
                        IVariableBinding[] targets = MoveInstanceMethodPage.access$0((MoveInstanceMethodPage)this.this$1).fProcessor.getPossibleTargets();
                        boolean success = false;
                        int index = 0;
                        while (index < targets.length) {
                            if (Bindings.equals((IBinding)target, (IBinding)targets[index])) {
                                this.this$1.handleTargetChanged(target);
                                success = true;
                                break;
                            }
                            ++index;
                        }
                        this.this$1.fTargetTypeStatus = !success ? RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringMessages.MoveInstanceMethodPage_invalid_target, BasicElementLabels.getJavaElementName(target.getName()))) : new RefactoringStatus();
                        this.this$1.handleStatusChanged();
                    }
                }
            });
            data = new GridData(768);
            data.heightHint = SWTUtil.getTableHeightHint(table, 7);
            data.horizontalSpan = 2;
            composite.setLayoutData(data);
            label = new Label(control, 4);
            label.setText(RefactoringMessages.MoveInstanceMethodPage_Method_name);
            label.setLayoutData((Object)new GridData());
            this.fMethodNameField = new Text(control, 2052);
            this.fMethodNameField.setText(MoveInstanceMethodWizard.this.fProcessor.getMethodName());
            this.fMethodNameField.selectAll();
            this.fMethodNameField.setLayoutData((Object)new GridData(768));
            this.fMethodNameField.setFocus();
            this.fMethodNameField.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MoveInstanceMethodPage this$1;
                {
                    this.this$1 = moveInstanceMethodPage;
                }

                public final void modifyText(ModifyEvent event) {
                    this.this$1.fMethodNameStatus = MoveInstanceMethodPage.access$0((MoveInstanceMethodPage)this.this$1).fProcessor.setMethodName(this.this$1.fMethodNameField.getText());
                    this.this$1.handleStatusChanged();
                }
            });
            TextFieldNavigationHandler.install(this.fMethodNameField);
            this.fTargetNameLabel = new Label(control, 4);
            this.fTargetNameLabel.setText(RefactoringMessages.MoveInstanceMethodPage_Target_name);
            this.fTargetNameLabel.setLayoutData((Object)new GridData());
            this.fTargetNameField = new Text(control, 2052);
            String name = MoveInstanceMethodWizard.this.fProcessor.getTargetName();
            if (name != null && name.length() > 0) {
                this.fTargetNameField.setText(MoveInstanceMethodWizard.this.fProcessor.getTargetName());
            } else {
                this.setPageComplete(RefactoringStatus.createInfoStatus((String)RefactoringCoreMessages.Checks_Choose_name));
                this.setPageComplete(false);
            }
            this.fTargetNameField.setLayoutData((Object)new GridData(768));
            this.fTargetNameField.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MoveInstanceMethodPage this$1;
                {
                    this.this$1 = moveInstanceMethodPage;
                }

                public final void modifyText(ModifyEvent event) {
                    this.this$1.fTargetNameStatus = MoveInstanceMethodPage.access$0((MoveInstanceMethodPage)this.this$1).fProcessor.setTargetName(this.this$1.fTargetNameField.getText());
                    this.this$1.handleStatusChanged();
                }
            });
            TextFieldNavigationHandler.install(this.fTargetNameField);
            label = new Label(control, 0);
            data = new GridData();
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            Composite delegateComposite = new Composite(control, 0);
            delegateComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            delegateComposite.setLayout((Layout)SWTUtil.newLayoutNoMargins(1));
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(delegateComposite, this.getRefactoring(), false);
            if (this.fLeaveDelegateCheckBox != null) {
                this.fDeprecateDelegateCheckBox = new Button(delegateComposite, 32);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.horizontalIndent = layout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(MoveInstanceMethodWizard.this.fProcessor));
                MoveInstanceMethodWizard.this.fProcessor.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MoveInstanceMethodPage this$1;
                    {
                        this.this$1 = moveInstanceMethodPage;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        MoveInstanceMethodPage.access$0((MoveInstanceMethodPage)this.this$1).fProcessor.setDeprecateDelegates(this.this$1.fDeprecateDelegateCheckBox.getSelection());
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MoveInstanceMethodPage this$1;
                    {
                        this.this$1 = moveInstanceMethodPage;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.fDeprecateDelegateCheckBox.setEnabled(this.this$1.fLeaveDelegateCheckBox.getSelection());
                    }
                });
            }
            MoveInstanceMethodWizard.this.fProcessor.setInlineDelegator(!this.fLeaveDelegateCheckBox.getSelection());
            MoveInstanceMethodWizard.this.fProcessor.setRemoveDelegator(!this.fLeaveDelegateCheckBox.getSelection());
            this.handleTargetChanged(possibleTargets[0]);
            Dialog.applyDialogFont((Control)control);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.move_members_wizard_page_context");
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        protected final void handleStatusChanged() {
            RefactoringStatus status = new RefactoringStatus();
            status.merge(this.fMethodNameStatus);
            status.merge(this.fTargetNameStatus);
            status.merge(this.fTargetTypeStatus);
            if (!this.fTargetTypeStatus.isOK()) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(status);
            }
        }

        protected final void handleTargetChanged(IVariableBinding target) {
            Assert.isNotNull((Object)target);
            MoveInstanceMethodWizard.this.fProcessor.setTarget(target);
            this.fTargetNameField.setEnabled(MoveInstanceMethodWizard.this.fProcessor.needsTargetNode());
            this.fTargetNameLabel.setEnabled(MoveInstanceMethodWizard.this.fProcessor.needsTargetNode());
        }

        static /* synthetic */ MoveInstanceMethodWizard access$0(MoveInstanceMethodPage moveInstanceMethodPage) {
            return moveInstanceMethodPage.MoveInstanceMethodWizard.this;
        }
    }

    public static class TargetLabelProvider
    extends BindingLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int column) {
            if (column == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int column) {
            IVariableBinding binding = (IVariableBinding)element;
            switch (column) {
                case 0: {
                    return this.getText(binding);
                }
                case 1: {
                    return this.getText(binding.getType());
                }
            }
            return null;
        }
    }
}

