/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.breadcrumb;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbMessages;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.PatternFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTable
extends Composite {
    public static final Direction DIRECTION_UP = new Direction();
    public static final Direction DIRECTION_DOWN = new Direction();
    private Text fFilterText;
    private TableViewer fTableViewer;
    private Composite fFilterComposite;
    private PatternFilter fPatternFilter;
    private final String fInitialText;
    private Job fRefreshJob;
    private boolean fShowFilterControls;
    private final ListenerList fNavigateListeners;
    private ToolBarManager fLeftToolBar;
    private ToolBarManager fRightToolBar;
    private final boolean fHasChild;
    private final boolean fHasParent;
    private Label fLeftToolBarSpacer;
    private Label fRightToolBarSpacer;

    public FilteredTable(Composite parent, int tableStyle, PatternFilter filter, boolean hasChild, boolean hasParent) {
        super(parent, 0);
        this.fPatternFilter = filter;
        this.fHasChild = hasChild;
        this.fHasParent = hasParent;
        this.fShowFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.fInitialText = BreadcrumbMessages.FilteredTable_initial_filter_text;
        this.fNavigateListeners = new ListenerList();
        this.createControl(parent, tableStyle);
        this.createRefreshJob();
        this.setFont(parent.getFont());
    }

    public void addNavigateListener(INavigateListener listener) {
        this.fNavigateListeners.add((Object)listener);
    }

    private void createControl(Composite parent, int tableStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.fShowFilterControls) {
            this.fFilterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = new GridLayout(3, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            filterLayout.horizontalSpacing = 0;
            this.fFilterComposite.setLayout((Layout)filterLayout);
            this.fFilterComposite.setFont(parent.getFont());
            this.createFilterControls(this.fFilterComposite);
            this.fFilterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        Composite tableComposite = new Composite((Composite)this, 0);
        GridLayout tableCompositeLayout = new GridLayout();
        tableCompositeLayout.marginHeight = 0;
        tableCompositeLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)tableCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        tableComposite.setLayoutData((Object)data);
        this.createTableControl(tableComposite, tableStyle);
        parent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FilteredTable.this.fFilterText.setFocus();
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    private Composite createFilterControls(Composite parent) {
        this.createLeftToolBar(parent);
        this.createFilterText(parent);
        this.createRightToolBar(parent);
        return parent;
    }

    private void createLeftToolBar(Composite parent) {
        if (this.fHasParent) {
            this.fLeftToolBar = new ToolBarManager(0x800100);
            this.fLeftToolBar.createControl(parent);
            this.fLeftToolBar.getControl().setBackground(parent.getBackground());
            Action goLeft = new Action("", 1){

                public void run() {
                    Object[] listeners = FilteredTable.this.fNavigateListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((INavigateListener)listeners[i]).navigate(DIRECTION_UP);
                        ++i;
                    }
                }
            };
            goLeft.setToolTipText(BreadcrumbMessages.FilteredTable_go_left_action_tooltip);
            this.fLeftToolBar.add((IAction)goLeft);
            this.fLeftToolBar.update(true);
        } else {
            this.fLeftToolBarSpacer = new Label(parent, 0);
            GridData data = new GridData(1, 0x1000000, false, false);
            data.widthHint = 19;
            this.fLeftToolBarSpacer.setLayoutData((Object)data);
        }
    }

    private void createRightToolBar(Composite parent) {
        if (this.fHasChild) {
            this.fRightToolBar = new ToolBarManager(0x800100);
            this.fRightToolBar.createControl(parent);
            this.fRightToolBar.getControl().setBackground(parent.getBackground());
            Action goRight = new Action("", 1){

                public void run() {
                    Object[] listeners = FilteredTable.this.fNavigateListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((INavigateListener)listeners[i]).navigate(DIRECTION_DOWN);
                        ++i;
                    }
                }
            };
            goRight.setToolTipText(BreadcrumbMessages.FilteredTable_go_right_action_tooltip);
            this.fRightToolBar.add((IAction)goRight);
            this.fRightToolBar.update(true);
        } else {
            this.fRightToolBarSpacer = new Label(parent, 0);
            GridData data = new GridData(1, 0x1000000, false, false);
            data.widthHint = 19;
            this.fRightToolBarSpacer.setLayoutData((Object)data);
        }
    }

    private Control createTableControl(Composite parent, int style) {
        this.fTableViewer = new TableViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.fTableViewer.getControl().setLayoutData((Object)data);
        this.fTableViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredTable.this.fRefreshJob.cancel();
            }
        });
        this.fTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    TableItem[] selection = FilteredTable.this.fTableViewer.getTable().getSelection();
                    if (selection.length == 1 && selection[0] == FilteredTable.this.fTableViewer.getTable().getItem(0)) {
                        FilteredTable.this.fFilterText.setFocus();
                        return;
                    }
                } else if (e.keyCode == 0x1000004 || e.keyCode == 0x1000003) {
                    Direction dir = e.keyCode == 0x1000003 ? DIRECTION_UP : DIRECTION_DOWN;
                    Object[] listeners = FilteredTable.this.fNavigateListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((INavigateListener)listeners[i]).navigate(dir);
                        ++i;
                    }
                }
                e.doit = true;
            }
        });
        this.fTableViewer.addFilter((ViewerFilter)this.fPatternFilter);
        return this.fTableViewer.getControl();
    }

    private TableItem getFirstMatchingItem(TableItem[] tableItems) {
        int i = 0;
        while (i < tableItems.length) {
            if (this.fPatternFilter.select((Viewer)this.fTableViewer, null, tableItems[i].getData())) {
                return tableItems[i];
            }
            ++i;
        }
        return null;
    }

    private void createRefreshJob() {
        this.fRefreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTable.this.fTableViewer.getTable().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTable.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTable.this.fInitialText != null && FilteredTable.this.fInitialText.equals(text);
                if (initial) {
                    FilteredTable.this.fPatternFilter.setPattern(null);
                } else {
                    FilteredTable.this.fPatternFilter.setPattern(text);
                }
                try {
                    FilteredTable.this.fTableViewer.getTable().setRedraw(false);
                    HashSet<Object> existing = new HashSet<Object>();
                    TableItem[] items = FilteredTable.this.fTableViewer.getTable().getItems();
                    int i = 0;
                    while (i < items.length) {
                        while (this.getDisplay().readAndDispatch()) {
                        }
                        if (monitor.isCanceled() || FilteredTable.this.fTableViewer.getTable().isDisposed()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (!FilteredTable.this.fPatternFilter.select((Viewer)FilteredTable.this.fTableViewer, null, items[i].getData())) {
                            FilteredTable.this.fTableViewer.remove(items[i].getData());
                        } else {
                            existing.add(items[i].getData());
                        }
                        ++i;
                    }
                    Object[] elements = ((IStructuredContentProvider)FilteredTable.this.fTableViewer.getContentProvider()).getElements(FilteredTable.this.fTableViewer.getInput());
                    int i2 = 0;
                    while (i2 < elements.length) {
                        while (this.getDisplay().readAndDispatch()) {
                        }
                        if (monitor.isCanceled() || FilteredTable.this.fTableViewer.getTable().isDisposed()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (FilteredTable.this.fPatternFilter.select((Viewer)FilteredTable.this.fTableViewer, null, elements[i2]) && !existing.contains(elements[i2])) {
                            FilteredTable.this.fTableViewer.add(elements[i2]);
                        }
                        ++i2;
                    }
                }
                finally {
                    if (!FilteredTable.this.fTableViewer.getTable().isDisposed()) {
                        FilteredTable.this.fTableViewer.getTable().setRedraw(true);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.fRefreshJob.setSystem(true);
    }

    private void createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 2436);
        this.fFilterText.setText(this.fInitialText);
        this.fFilterText.selectAll();
        this.fFilterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTable.this.fFilterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(FilteredTable.this.fInitialText) ? FilteredTable.this.fInitialText : Messages.format(BreadcrumbMessages.FilteredTable_accessible_listener_text, new String[]{filterTextString, String.valueOf(FilteredTable.this.getViewer().getTable().getItemCount())});
            }
        });
        this.fFilterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = FilteredTable.this.fFilterText.getDisplay();
                display.asyncExec(new Runnable(this){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (!FilteredTable.access$0(8.access$0(this.this$1)).isDisposed() && FilteredTable.access$7(8.access$0(this.this$1)).equals(FilteredTable.access$0(8.access$0(this.this$1)).getText().trim())) {
                            FilteredTable.access$0(8.access$0(this.this$1)).selectAll();
                        }
                    }
                });
            }

            static /* synthetic */ FilteredTable access$0(8 var0) {
                return var0.FilteredTable.this;
            }
        });
        this.fFilterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTable.this.getViewer().getTable().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredTable.this.fTableViewer.getTable().setFocus();
                    if (FilteredTable.this.getViewer().getTable().getSelectionCount() == 0) {
                        TableItem item = FilteredTable.this.getViewer().getTable().getItem(0);
                        FilteredTable.this.getViewer().getTable().setSelection(item);
                        ISelection sel = FilteredTable.this.getViewer().getSelection();
                        FilteredTable.this.getViewer().setSelection(sel, true);
                    }
                } else if (e.keyCode == 0x1000001) {
                    e.doit = false;
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.fFilterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (FilteredTable.this.getViewer().getTable().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        TableItem item;
                        boolean textChanged;
                        boolean hasFocus = FilteredTable.this.getViewer().getTable().setFocus();
                        boolean bl = textChanged = !FilteredTable.this.getInitialText().equals(FilteredTable.this.fFilterText.getText().trim());
                        if (hasFocus && textChanged && FilteredTable.this.fFilterText.getText().trim().length() > 0 && (item = FilteredTable.this.getFirstMatchingItem(FilteredTable.this.getViewer().getTable().getItems())) != null) {
                            FilteredTable.this.getViewer().getTable().setSelection(item);
                            ISelection sel = FilteredTable.this.getViewer().getSelection();
                            FilteredTable.this.getViewer().setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredTable.this.textChanged();
            }
        });
        if ((this.fFilterText.getStyle() & 0x100) != 0) {
            this.fFilterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        FilteredTable.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fFilterText.setLayoutData((Object)gridData);
        this.fFilterText.setForeground(Display.getDefault().getSystemColor(16));
    }

    private void textChanged() {
        if (this.fFilterText.getText().equals(this.fInitialText)) {
            this.fFilterText.setForeground(Display.getDefault().getSystemColor(16));
        } else {
            this.fFilterText.setForeground(Display.getDefault().getSystemColor(2));
        }
        this.fRefreshJob.cancel();
        this.fRefreshJob.schedule(200L);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.fFilterComposite != null) {
            this.fFilterComposite.setBackground(background);
        }
        if (this.fRightToolBar != null && this.fRightToolBar.getControl() != null) {
            this.fRightToolBar.getControl().setBackground(background);
        }
        if (this.fLeftToolBar != null && this.fLeftToolBar.getControl() != null) {
            this.fLeftToolBar.getControl().setBackground(background);
        }
        if (this.fLeftToolBarSpacer != null) {
            this.fLeftToolBarSpacer.setBackground(background);
        }
        if (this.fRightToolBarSpacer != null) {
            this.fRightToolBarSpacer.setBackground(background);
        }
    }

    private void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    private void setFilterText(String string) {
        if (this.fFilterText != null) {
            this.fFilterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.fPatternFilter;
    }

    public TableViewer getViewer() {
        return this.fTableViewer;
    }

    public Text getFilterControl() {
        return this.fFilterText;
    }

    private String getFilterString() {
        return this.fFilterText != null ? this.fFilterText.getText() : null;
    }

    private void selectAll() {
        if (this.fFilterText != null) {
            this.fFilterText.selectAll();
        }
    }

    private String getInitialText() {
        return this.fInitialText;
    }

    public static final class Direction {
        private Direction() {
        }
    }

    public static interface INavigateListener {
        public void navigate(Direction var1);
    }
}

