/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;

public class FatJarManifestProvider
implements IManifestProvider {
    private static final String SEALED_VALUE = "true";
    private static final String UNSEALED_VALUE = "false";
    private FatJarBuilder fBuilder;

    public FatJarManifestProvider(FatJarBuilder builder) {
        this.fBuilder = builder;
    }

    public Manifest create(JarPackageData jarPackage) throws CoreException {
        Manifest result;
        Manifest ownManifest = this.createOwn(jarPackage);
        this.setManifestClasspath(ownManifest, this.fBuilder.getManifestClasspath());
        if (this.fBuilder.isMergeManifests()) {
            ArrayList<Manifest> otherManifests = new ArrayList<Manifest>();
            Object[] elements = jarPackage.getElements();
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).isArchive()) {
                    ZipFile zip = JarPackagerUtil.getArchiveFile(((IPackageFragmentRoot)element).getPath());
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                        try {
                            Manifest otherManifest = new Manifest(zip.getInputStream(entry));
                            otherManifests.add(otherManifest);
                        }
                        catch (IOException e) {
                            JavaPlugin.log(e);
                        }
                    }
                }
                ++i;
            }
            result = this.merge(ownManifest, otherManifests);
        } else {
            result = ownManifest;
        }
        return result;
    }

    private void setManifestClasspath(Manifest ownManifest, String manifestClasspath) {
        if (manifestClasspath != null && !manifestClasspath.trim().equals("")) {
            Attributes mainAttr = ownManifest.getMainAttributes();
            mainAttr.putValue("Class-Path", manifestClasspath);
        }
    }

    private Manifest merge(Manifest ownManifest, List otherManifests) {
        Manifest mergedManifest = new Manifest(ownManifest);
        Map<String, Attributes> mergedEntries = mergedManifest.getEntries();
        Iterator iter = otherManifests.iterator();
        while (iter.hasNext()) {
            Manifest otherManifest = (Manifest)iter.next();
            Map<String, Attributes> otherEntries = otherManifest.getEntries();
            Iterator<String> iterator = otherEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String attributeName = iterator.next();
                if (mergedEntries.containsKey(attributeName)) continue;
                mergedEntries.put(attributeName, otherEntries.get(attributeName));
            }
        }
        return mergedManifest;
    }

    private Manifest createOwn(JarPackageData jarPackage) throws CoreException {
        if (jarPackage.isManifestGenerated()) {
            return this.createGeneratedManifest(jarPackage);
        }
        try {
            return this.createSuppliedManifest(jarPackage);
        }
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    public Manifest createDefault(String manifestVersion) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, manifestVersion);
        return manifest;
    }

    protected void putAdditionalEntries(Manifest manifest, JarPackageData jarPackage) {
    }

    private Manifest createGeneratedManifest(JarPackageData jarPackage) {
        Manifest manifest = new Manifest();
        this.putVersion(manifest, jarPackage);
        this.putSealing(manifest, jarPackage);
        this.putMainClass(manifest, jarPackage);
        this.putAdditionalEntries(manifest, jarPackage);
        return manifest;
    }

    private void putVersion(Manifest manifest, JarPackageData jarPackage) {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, jarPackage.getManifestVersion());
    }

    private void putSealing(Manifest manifest, JarPackageData jarPackage) {
        block4: {
            block3: {
                if (!jarPackage.isJarSealed()) break block3;
                manifest.getMainAttributes().put(Attributes.Name.SEALED, SEALED_VALUE);
                IPackageFragment[] packages = jarPackage.getPackagesToUnseal();
                if (packages == null) break block4;
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, UNSEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
                break block4;
            }
            IPackageFragment[] packages = jarPackage.getPackagesToSeal();
            if (packages != null) {
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, SEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
            }
        }
    }

    private void putMainClass(Manifest manifest, JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() != null && jarPackage.getManifestMainClass().getFullyQualifiedName().length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, jarPackage.getManifestMainClass().getFullyQualifiedName());
        }
    }

    private String getInManifestFormat(IPackageFragment packageFragment) {
        String name = packageFragment.getElementName();
        return String.valueOf(name.replace('.', '/')) + '/';
    }

    private Manifest createSuppliedManifest(JarPackageData jarPackage) throws CoreException, IOException {
        Manifest manifest;
        InputStream stream = jarPackage.getManifestFile().getContents(false);
        try {
            manifest = new Manifest(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return manifest;
    }
}

