/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FatJarAntExporter {
    private ILaunchConfiguration fLaunchConfiguration;
    private IPath fAbsJarfile;
    private IPath fAntScriptLocation;

    public FatJarAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
        this.fAbsJarfile = jarLocation;
        this.fAntScriptLocation = antScriptLocation;
    }

    public void run(MultiStatus status) throws CoreException {
        try {
            IPath[] classpath = FatJarAntExporter.getClasspath(this.fLaunchConfiguration);
            String mainClass = FatJarAntExporter.getMainClass(this.fLaunchConfiguration, status);
            String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            this.buildANTScript(new FileOutputStream(this.fAntScriptLocation.toFile()), projectName, this.fAbsJarfile, mainClass, FatJarAntExporter.convert(classpath));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizard_antScript_error_readingOutputFile, new Object[]{BasicElementLabels.getPathLabel(this.fAntScriptLocation, true), e.getLocalizedMessage()})));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizard_antScript_error_writingOutputFile, new Object[]{BasicElementLabels.getPathLabel(this.fAntScriptLocation, true), e.getLocalizedMessage()})));
        }
    }

    private static IPath[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPath entry;
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !userEntries.contains(entry = Path.fromOSString((String)location))) {
                userEntries.add(entry);
            }
            ++i;
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    private static String getMainClass(ILaunchConfiguration launchConfig, MultiStatus status) {
        String result = null;
        if (launchConfig != null) {
            try {
                result = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        if (result == null) {
            status.add((IStatus)new Status(2, "org.eclipse.jdt.ui", FatJarPackagerMessages.FatJarPackageWizardPage_LaunchConfigurationWithoutMainType_warning));
            result = "";
        }
        return result;
    }

    private static SourceInfo[] convert(IPath[] classpath) {
        SourceInfo[] result = new SourceInfo[classpath.length];
        int i = 0;
        while (i < classpath.length) {
            IPath path = classpath[i];
            if (path != null) {
                if (path.toFile().isDirectory()) {
                    result[i] = new SourceInfo(false, path.toString(), "");
                } else if (path.toFile().isFile()) {
                    result[i] = new SourceInfo(true, path.toString(), "");
                }
            }
            ++i;
        }
        return result;
    }

    private void buildANTScript(OutputStream outputStream, String projectName, IPath absJarfile, String mainClass, SourceInfo[] sourceInfos) throws IOException {
        String absJarname = absJarfile.toString();
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotGetXmlBuilder);
        }
        Document document = docBuilder.newDocument();
        Element project = document.createElement("project");
        project.setAttribute("name", "Create Runnable Jar for Project " + projectName);
        project.setAttribute("default", "create_run_jar");
        Comment comment = document.createComment("this file was created by Eclipse Runnable JAR Export Wizard");
        project.appendChild(comment);
        comment = document.createComment("ANT 1.7 is required                                        ");
        project.appendChild(comment);
        document.appendChild(project);
        Element target = document.createElement("target");
        target.setAttribute("name", "create_run_jar");
        project.appendChild(target);
        Element jar = document.createElement("jar");
        jar.setAttribute("destfile", absJarname);
        jar.setAttribute("filesetmanifest", "mergewithoutmain");
        target.appendChild(jar);
        Element manifest = document.createElement("manifest");
        jar.appendChild(manifest);
        Element attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Built-By");
        attribute.setAttribute("value", "${user.name}");
        manifest.appendChild(attribute);
        attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Main-Class");
        attribute.setAttribute("value", mainClass);
        manifest.appendChild(attribute);
        attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Class-Path");
        attribute.setAttribute("value", ".");
        manifest.appendChild(attribute);
        int i = 0;
        while (i < sourceInfos.length) {
            SourceInfo sourceInfo = sourceInfos[i];
            if (sourceInfo.isJar) {
                Element zipfileset = document.createElement("zipfileset");
                zipfileset.setAttribute("src", sourceInfo.absPath);
                zipfileset.setAttribute("excludes", "META-INF/*.SF");
                jar.appendChild(zipfileset);
            } else {
                Element fileset = document.createElement("fileset");
                fileset.setAttribute("dir", sourceInfo.absPath);
                jar.appendChild(fileset);
            }
            ++i;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotTransformToXML);
        }
    }

    private static class SourceInfo {
        public final boolean isJar;
        public final String absPath;
        public final String relJarPath;

        public SourceInfo(boolean isJar, String absPath, String relJarPath) {
            this.isJar = isJar;
            this.absPath = absPath;
            this.relJarPath = relJarPath;
        }
    }
}

