/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public final class RenameJavaProjectProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private IJavaProject fProject;
    private boolean fUpdateReferences;

    public RenameJavaProjectProcessor(IJavaProject project) {
        this.fProject = project;
        if (this.fProject != null) {
            this.setNewElementName(this.fProject.getElementName());
        }
        this.fUpdateReferences = true;
    }

    public RenameJavaProjectProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameJavaProjectProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fProject);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameJavaProjectRefactoring_rename;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fProject);
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    public Object getNewElement() {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fProject, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile projectFile = this.fProject.getProject().getFile(".project");
        if (projectFile != null && projectFile.exists()) {
            return new IFile[]{projectFile};
        }
        return new IFile[0];
    }

    public int getSaveMode() {
        return 2;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = RefactoringStatus.create((IStatus)ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectRefactoring_already_exists);
        }
        if (this.projectFolderAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectProcessor_folder_already_exists);
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            if (this.isReadOnly()) {
                String message = Messages.format(RefactoringCoreMessages.RenameJavaProjectRefactoring_read_only, BasicElementLabels.getJavaElementName(this.fProject.getElementName()));
                RefactoringStatus refactoringStatus = RefactoringStatus.createErrorStatus((String)message);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean isReadOnly() {
        return Resources.isReadOnly(this.fProject.getResource());
    }

    private boolean projectNameAlreadyExists(String newName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(newName).exists();
    }

    private boolean projectFolderAlreadyExists(String newName) throws CoreException {
        boolean isNotInWorkpace;
        boolean bl = isNotInWorkpace = this.fProject.getProject().getDescription().getLocationURI() != null;
        if (isNotInWorkpace) {
            return false;
        }
        URI locationURI = this.fProject.getProject().getLocationURI();
        IFileStore projectStore = EFS.getStore((URI)locationURI);
        IFileStore newProjectStore = projectStore.getParent().getChild(newName);
        return newProjectStore.fetchInfo().exists();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            String description = Messages.format(RefactoringCoreMessages.RenameJavaProjectProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fProject.getElementName()));
            String header = Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fProject.getElementName()), BasicElementLabels.getJavaElementName(this.getNewElementName())});
            String comment = new JDTRefactoringDescriptorComment(null, this, header).asString();
            RenameJavaElementDescriptor descriptor = new RenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.java.project");
            descriptor.setProject(null);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(7);
            descriptor.setJavaElement((IJavaElement)this.fProject);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateReferences(this.fUpdateReferences);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameJavaProjectRefactoring_rename, new Change[]{new RenameJavaProjectChange(this.fProject, this.getNewElementName(), this.fUpdateReferences)});
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 2) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.java.project");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fProject = (IJavaProject)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }
}

