/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.code.OperatorPrecedence;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.text.edits.TextEditGroup;

public class ExpressionsFix
extends CompilationUnitRewriteOperationsFix {
    public static ExpressionsFix createAddParanoidalParenthesisFix(CompilationUnit compilationUnit, ASTNode[] coveredNodes) {
        if (coveredNodes == null) {
            return null;
        }
        if (coveredNodes.length == 0) {
            return null;
        }
        ArrayList changedNodes = new ArrayList();
        int i = 0;
        while (i < coveredNodes.length) {
            ASTNode covered = coveredNodes[i];
            if (covered instanceof InfixExpression) {
                covered.accept((ASTVisitor)new MissingParenthesisVisitor(changedNodes));
            }
            ++i;
        }
        if (changedNodes.isEmpty()) {
            return null;
        }
        AddParenthesisOperation op = new AddParenthesisOperation(changedNodes.toArray(new Expression[changedNodes.size()]));
        return new ExpressionsFix(FixMessages.ExpressionsFix_addParanoiacParenthesis_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static ExpressionsFix createRemoveUnnecessaryParenthesisFix(CompilationUnit compilationUnit, ASTNode[] nodes) {
        ArrayList changedNodes = new ArrayList();
        int i = 0;
        while (i < nodes.length) {
            ASTNode covered = nodes[i];
            if (covered instanceof ParenthesizedExpression || covered instanceof InfixExpression) {
                covered.accept((ASTVisitor)new UnnecessaryParenthesisVisitor(changedNodes));
            }
            ++i;
        }
        if (changedNodes.isEmpty()) {
            return null;
        }
        HashSet expressions = new HashSet(changedNodes);
        RemoveParenthesisOperation op = new RemoveParenthesisOperation(expressions);
        return new ExpressionsFix(FixMessages.ExpressionsFix_removeUnnecessaryParenthesis_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean addParanoicParentesis, boolean removeUnnecessaryParenthesis) {
        if (addParanoicParentesis) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept((ASTVisitor)new MissingParenthesisVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            AddParenthesisOperation op = new AddParenthesisOperation(changedNodes.toArray(new Expression[changedNodes.size()]));
            return new ExpressionsFix(FixMessages.ExpressionsFix_add_parenthesis_change_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        if (removeUnnecessaryParenthesis) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept((ASTVisitor)new UnnecessaryParenthesisVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            HashSet expressions = new HashSet(changedNodes);
            RemoveParenthesisOperation op = new RemoveParenthesisOperation(expressions);
            return new ExpressionsFix(FixMessages.ExpressionsFix_remove_parenthesis_change_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        return null;
    }

    protected ExpressionsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class AddParenthesisOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final Expression[] fExpressions;

        public AddParenthesisOperation(Expression[] expressions) {
            this.fExpressions = expressions;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.ExpressionsFix_addParanoiacParenthesis_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            int i = 0;
            while (i < this.fExpressions.length) {
                Expression expression = this.fExpressions[i];
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
                rewrite.replace((ASTNode)expression, (ASTNode)parenthesizedExpression, group);
                ++i;
            }
        }
    }

    private static final class MissingParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList fNodes;

        private MissingParenthesisVisitor(ArrayList nodes) {
            this.fNodes = nodes;
        }

        public void postVisit(ASTNode node) {
            if (this.needsParentesis(node)) {
                this.fNodes.add(node);
            }
        }

        private boolean needsParentesis(ASTNode node) {
            if (!(node.getParent() instanceof InfixExpression)) {
                return false;
            }
            if (node instanceof InstanceofExpression) {
                return true;
            }
            if (node instanceof InfixExpression) {
                InfixExpression expression = (InfixExpression)node;
                InfixExpression.Operator operator = expression.getOperator();
                InfixExpression parentExpression = (InfixExpression)node.getParent();
                InfixExpression.Operator parentOperator = parentExpression.getOperator();
                if (parentOperator == operator) {
                    return false;
                }
                return operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER_EQUALS || operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS || operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR;
            }
            return false;
        }
    }

    private static class RemoveParenthesisOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final HashSet fExpressions;

        public RemoveParenthesisOperation(HashSet expressions) {
            this.fExpressions = expressions;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.ExpressionsFix_removeUnnecessaryParenthesis_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            while (this.fExpressions.size() > 0) {
                ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)this.fExpressions.iterator().next();
                this.fExpressions.remove(parenthesizedExpression);
                ParenthesizedExpression down = parenthesizedExpression;
                while (this.fExpressions.contains(down.getExpression())) {
                    down = (ParenthesizedExpression)down.getExpression();
                    this.fExpressions.remove(down);
                }
                ASTNode move = rewrite.createMoveTarget((ASTNode)down.getExpression());
                ParenthesizedExpression top = parenthesizedExpression;
                while (this.fExpressions.contains(top.getParent())) {
                    top = (ParenthesizedExpression)top.getParent();
                    this.fExpressions.remove(top);
                }
                rewrite.replace((ASTNode)top, move, group);
            }
        }
    }

    private static final class UnnecessaryParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList fNodes;

        private UnnecessaryParenthesisVisitor(ArrayList nodes) {
            this.fNodes = nodes;
        }

        public boolean visit(ParenthesizedExpression node) {
            if (this.canRemoveParenthesis(node)) {
                this.fNodes.add(node);
            }
            return true;
        }

        private boolean canRemoveParenthesis(ParenthesizedExpression node) {
            ConditionalExpression conditionalExpression;
            int parentPrecedence;
            ASTNode parent = node.getParent();
            if (!(parent instanceof Expression)) {
                return true;
            }
            Expression parentExpression = (Expression)parent;
            if (parentExpression instanceof ParenthesizedExpression) {
                return true;
            }
            Expression expression = this.getExpression(node);
            int expressionPrecedence = OperatorPrecedence.getExpressionPrecedence(expression);
            if (expressionPrecedence > (parentPrecedence = OperatorPrecedence.getExpressionPrecedence(parentExpression))) {
                return true;
            }
            if (expressionPrecedence < parentPrecedence) {
                return false;
            }
            if (parentExpression instanceof InfixExpression) {
                InfixExpression parentInfix = (InfixExpression)parentExpression;
                if (parentInfix.getLeftOperand() == node) {
                    return true;
                }
                if (UnnecessaryParenthesisVisitor.isAssociative(parentInfix)) {
                    if (expression instanceof InfixExpression) {
                        InfixExpression infixExpression = (InfixExpression)expression;
                        InfixExpression.Operator operator = infixExpression.getOperator();
                        if (parentInfix.getOperator() != InfixExpression.Operator.TIMES) {
                            return true;
                        }
                        if (operator == InfixExpression.Operator.TIMES) {
                            return true;
                        }
                        if (operator == InfixExpression.Operator.REMAINDER) {
                            return false;
                        }
                        ITypeBinding binding = infixExpression.resolveTypeBinding();
                        if (binding == null) {
                            return false;
                        }
                        if (!binding.isPrimitive()) {
                            return false;
                        }
                        String name = binding.getName();
                        return !this.isIntegerNumber(name);
                    }
                    return true;
                }
                return false;
            }
            return !(parentExpression instanceof ConditionalExpression) || (conditionalExpression = (ConditionalExpression)parentExpression).getElseExpression() == node;
        }

        private boolean isIntegerNumber(String name) {
            return "int".equals(name) || "long".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name);
        }

        private Expression getExpression(ParenthesizedExpression node) {
            Expression expression = node.getExpression();
            while (expression instanceof ParenthesizedExpression) {
                expression = ((ParenthesizedExpression)expression).getExpression();
            }
            return expression;
        }

        public static boolean isAssociative(InfixExpression expression) {
            InfixExpression.Operator operator = expression.getOperator();
            if (operator == InfixExpression.Operator.PLUS) {
                return UnnecessaryParenthesisVisitor.isAllOperandsHaveSameType(expression);
            }
            if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.GREATER_EQUALS) {
                return UnnecessaryParenthesisVisitor.isAllOperandsHaveSameType(expression);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return true;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return true;
            }
            if (operator == InfixExpression.Operator.AND) {
                return true;
            }
            if (operator == InfixExpression.Operator.OR) {
                return true;
            }
            if (operator == InfixExpression.Operator.XOR) {
                return true;
            }
            return operator == InfixExpression.Operator.TIMES;
        }

        private static boolean isAllOperandsHaveSameType(InfixExpression expression) {
            ITypeBinding binding = expression.getLeftOperand().resolveTypeBinding();
            if (binding == null) {
                return false;
            }
            ITypeBinding current = expression.getRightOperand().resolveTypeBinding();
            if (binding != current) {
                return false;
            }
            Iterator iterator = expression.extendedOperands().iterator();
            while (iterator.hasNext()) {
                Expression operand = (Expression)iterator.next();
                current = operand.resolveTypeBinding();
                if (binding == current) continue;
                return false;
            }
            return true;
        }
    }
}

