/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TestConnectionDialog
extends Dialog
implements IShellProvider {
    private Group group;
    private Label testConnectionLabel;
    private Label urlLabel;
    private Label connectStatusLabel;
    Point shellSize;
    Point shellLocation;
    private String infoCenterName = "";
    private String infoCenterHost = "";
    private String infoCenterPath = "";
    private String infoCenterPort = "";
    boolean successfullConnection = false;
    Color connectionColor;

    protected TestConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createGroup(parent);
        this.createButtonBar(parent);
        return composite;
    }

    public void initializeBounds() {
        this.shellSize = this.getInitialSize();
        this.shellLocation = this.getInitialLocation(this.shellSize);
        this.getShell().setBounds(this.shellLocation.x, this.shellLocation.y, this.shellSize.x + 150, this.shellSize.y - 40);
        this.getShell().setText(Messages.TestConnectionDialog_4);
    }

    private void createGroup(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.TestConnectionDialog_5);
        this.group.setLayout((Layout)new GridLayout(1, false));
        this.group.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.createTestLabelSection((Composite)this.group);
        this.createURLSection((Composite)this.group);
        this.createStatusSection((Composite)this.group);
    }

    private void createTestLabelSection(Composite parent) {
        this.testConnectionLabel = new Label(parent, 512);
        this.testConnectionLabel.setText(NLS.bind((String)Messages.TestConnectionDialog_6, (Object)this.infoCenterName));
    }

    private void createURLSection(Composite parent) {
        this.urlLabel = new Label(parent, 512);
        String urlString = "\nURL: http://" + this.infoCenterHost;
        urlString = this.infoCenterPort.equals("80") ? String.valueOf(urlString) + this.infoCenterPath : String.valueOf(urlString) + ":" + this.infoCenterPort + this.infoCenterPath;
        this.urlLabel.setText(String.valueOf(urlString) + "\n");
    }

    private void createStatusSection(Composite parent) {
        String connectStatus = "\n";
        this.connectStatusLabel = new Label(parent, 0);
        if (this.successfullConnection) {
            connectStatus = String.valueOf(connectStatus) + Messages.TestConnectionDialog_12;
        } else if (!this.successfullConnection) {
            connectStatus = String.valueOf(connectStatus) + Messages.TestConnectionDialog_13;
        }
        this.connectStatusLabel.setText(connectStatus);
    }

    public void cancelPressed() {
        this.setReturnCode(0);
        if (this.connectionColor != null) {
            this.connectionColor.dispose();
        }
        this.close();
    }

    public void setValues(String icName, String icHost, String icPort, String icPath) {
        this.infoCenterName = icName;
        this.infoCenterHost = icHost;
        this.infoCenterPath = icPath;
        this.infoCenterPort = icPort;
    }

    public void setConnectionStatus(boolean testStatus) {
        this.successfullConnection = testStatus;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

