/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.BundleGroupContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureGroup {
    private final Map<String, BundleGroupContainer> containerByName;
    private final List<IBundleGroup> bundleGroups;
    private final String name;
    private final String description;
    private final String title;
    private final String category;

    public FeatureGroup(String name, String description, String title, String category) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)category);
        this.name = name;
        this.description = description;
        this.title = title;
        this.category = category;
        this.containerByName = new HashMap<String, BundleGroupContainer>();
        this.bundleGroups = new ArrayList<IBundleGroup>();
    }

    public void addBundleGroup(IBundleGroup bundleGroup, String featureName) {
        BundleGroupContainer container = this.containerByName.get(featureName);
        if (container == null) {
            container = new BundleGroupContainer(featureName);
            container.addBundleGroup(bundleGroup);
            this.containerByName.put(featureName, container);
        } else {
            container.addBundleGroup(bundleGroup);
        }
        this.bundleGroups.add(bundleGroup);
    }

    public Collection<BundleGroupContainer> getContainers() {
        return this.containerByName.values();
    }

    public List<IBundleGroup> getBundleGroups() {
        return this.bundleGroups;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean requiresSelection() {
        return this.containerByName.size() > 1;
    }
}

