/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTaskMapper {
    private final Map<String, String> attributes;

    public AttributeTaskMapper(Map<String, String> attributes) {
        Assert.isNotNull(attributes);
        this.attributes = attributes;
    }

    public boolean isMappingComplete() {
        return this.getTaskRepository() != null && this.attributes.get("product") != null;
    }

    public TaskRepository getTaskRepository() {
        String connectorKind;
        TaskRepository taskRepository = null;
        String repositoryUrl = this.attributes.get("repositoryUrl");
        if (repositoryUrl != null && (connectorKind = this.attributes.get("repositoryKind")) != null) {
            taskRepository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        }
        return taskRepository;
    }

    public TaskData createTaskData(IProgressMonitor monitor) throws CoreException {
        ITaskMapping taskMapping = this.getTaskMapping();
        return TasksUiInternal.createTaskData((TaskRepository)this.getTaskRepository(), (ITaskMapping)taskMapping, (ITaskMapping)taskMapping, (IProgressMonitor)monitor);
    }

    public ITaskMapping getTaskMapping() {
        return new KeyValueMapping(this.attributes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValueMapping
    extends TaskMapping {
        private final Map<String, String> attributes;

        public KeyValueMapping(Map<String, String> attributes) {
            Assert.isNotNull(attributes);
            this.attributes = attributes;
        }

        public void merge(ITaskMapping source) {
        }

        public Date getCompletionDate() {
            return null;
        }

        public String getComponent() {
            return this.attributes.get("component");
        }

        public Date getCreationDate() {
            return null;
        }

        public String getDescription() {
            return this.attributes.get("description");
        }

        public Date getDueDate() {
            return null;
        }

        public Date getModificationDate() {
            return null;
        }

        public String getOwner() {
            return null;
        }

        public ITask.PriorityLevel getPriorityLevel() {
            return null;
        }

        public String getProduct() {
            return this.attributes.get("product");
        }

        public String getSummary() {
            return null;
        }

        public TaskData getTaskData() {
            return null;
        }

        public String getTaskKey() {
            return null;
        }

        public String getTaskKind() {
            return null;
        }

        public String getTaskUrl() {
            return null;
        }

        public List<String> getCc() {
            return null;
        }

        public List<String> getKeywords() {
            return null;
        }

        public String getReporter() {
            return null;
        }

        public String getResolution() {
            return null;
        }

        public String getTaskStatus() {
            return null;
        }
    }
}

