/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.preview;

import java.util.Arrays;
import org.eclipse.epp.usagedata.internal.recording.filtering.PreferencesBasedFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class RemoveFilterDialog {
    private final PreferencesBasedFilter filter;

    public RemoveFilterDialog(PreferencesBasedFilter filter) {
        this.filter = filter;
    }

    public void prompt(Shell shell) {
        ListDialog dialog = new ListDialog(shell){

            protected int getTableStyle() {
                return super.getTableStyle() - 4 + 2;
            }
        };
        dialog.setTitle("Remove Filter");
        dialog.setMessage("Select one or more filters to remove.");
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        Object[] filterPatterns = this.filter.getFilterPatterns();
        Arrays.sort(filterPatterns);
        dialog.setInput((Object)filterPatterns);
        dialog.open();
        Object[] selected = dialog.getResult();
        if (selected == null) {
            return;
        }
        this.filter.removeFilterPatterns(selected);
    }
}

