/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.preferences;

import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UsageDataCapturePreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button captureEnabledCheckbox;
    IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent event) {
            if ("org.eclipse.epp.usagedata.gathering.enabled".equals(event.getProperty())) {
                UsageDataCapturePreferencesPage.this.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        (this).UsageDataCapturePreferencesPage.this.captureEnabledCheckbox.setSelection(((Boolean)event.getNewValue()).booleanValue());
                    }
                });
            }
        }
    };

    public UsageDataCapturePreferencesPage() {
        this.setDescription("The Usage Data Collector collects information about how individuals are using the Eclipse platform. The intent is to use this data to help committers and organizations better understand how developers are using Eclipse.");
        this.setPreferenceStore(UsageDataCaptureActivator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.createGeneralInformationArea(composite);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(16384, 128, true, true));
        this.initialize();
        return composite;
    }

    private void initialize() {
        this.captureEnabledCheckbox.setSelection(this.getCapturePreferences().getBoolean("org.eclipse.epp.usagedata.gathering.enabled"));
    }

    public boolean performOk() {
        this.getCapturePreferences().setValue("org.eclipse.epp.usagedata.gathering.enabled", this.captureEnabledCheckbox.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.captureEnabledCheckbox.setSelection(this.getCapturePreferences().getDefaultBoolean("org.eclipse.epp.usagedata.gathering.enabled"));
        super.performDefaults();
    }

    private void createGeneralInformationArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.captureEnabledCheckbox = new Button(composite, 16416);
        this.captureEnabledCheckbox.setText("Enable capture");
    }

    private IPreferenceStore getCapturePreferences() {
        return UsageDataCaptureActivator.getDefault().getPreferenceStore();
    }
}

