/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.ImportProjectSetOperation;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ImportProjectSetAction
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;

    public void run(IAction action) {
        final Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Iterator iterator = ImportProjectSetAction.this.fSelection.iterator();
                    while (iterator.hasNext()) {
                        IFile file = (IFile)iterator.next();
                        if (ImportProjectSetAction.isRunInBackgroundPreferenceOn()) {
                            ImportProjectSetOperation op = new ImportProjectSetOperation(null, file.getLocation().toString(), null);
                            op.run();
                            continue;
                        }
                        ProjectSetImporter.importProjectSet(file.getLocation().toString(), shell, monitor);
                    }
                }
            });
        }
        catch (InvocationTargetException exception) {
            ErrorDialog.openError((Shell)shell, null, null, (IStatus)new Status(4, "org.eclipse.team.ui", 4, TeamUIMessages.ImportProjectSetAction_0, exception.getTargetException()));
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private static boolean isRunInBackgroundPreferenceOn() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.run_import_in_background_");
    }
}

