/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.ExtensionValidators;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValPrefManagerGlobal {
    public static final int frameworkVersion = 3;
    private List<IValChangedListener> _listeners = new LinkedList<IValChangedListener>();
    private static ValPrefManagerGlobal _me;
    private List<Validator> _validators;

    private ValPrefManagerGlobal() {
    }

    public static ValPrefManagerGlobal getDefault() {
        if (_me == null) {
            _me = new ValPrefManagerGlobal();
        }
        return _me;
    }

    public void addListener(IValChangedListener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public void removeListener(IValChangedListener listener) {
        this._listeners.remove(listener);
    }

    private void updateListeners(boolean validationSettingChanged) {
        for (IValChangedListener cl : this._listeners) {
            cl.validatorsForProjectChanged(null, validationSettingChanged);
        }
    }

    public List<Validator> getValidators() throws BackingStoreException {
        List<Validator> vals = this._validators;
        if (vals == null) {
            this._validators = vals = this.loadValidators();
        }
        return vals;
    }

    private List<Validator> loadValidators() throws BackingStoreException {
        LinkedList<Validator> list = new LinkedList<Validator>();
        IEclipsePreferences pref = ValidationFramework.getDefault().getPreferenceStore();
        if (pref.nodeExists("vals")) {
            Preferences vals = pref.node("vals");
            String[] stringArray = vals.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Validator base = ExtensionValidators.instance().getMapV2().get(id);
                Validator v = ValPrefManagerGlobal.loadValidator(id, vals, base);
                if (v != null) {
                    Validator.V2 v2 = v.asV2Validator();
                    if (v2 != null) {
                        v2.setLevel(Validator.Level.Global);
                    }
                    list.add(v);
                }
                ++n2;
            }
        }
        return list;
    }

    static Validator loadValidator(String id, Preferences valsNode, Validator base) {
        String groups;
        if (base == null) {
            return null;
        }
        Preferences vp = valsNode.node(id);
        base = base.copy();
        Validator.V2 v2 = base.asV2Validator();
        String global = vp.get("global", "");
        if (global.length() > 0) {
            Global g = new Global(global);
            base.setBuildValidation(g.isBuild());
            base.setManualValidation(g.isManual());
            base.setDelegatingId(g.getDelegating());
        }
        if (v2 != null && (groups = vp.get("groups", "")).length() > 0) {
            LinkedList<FilterGroup> list = new LinkedList<FilterGroup>();
            Deserializer des = new Deserializer(groups);
            while (des.hasNext()) {
                list.add(FilterGroup.create(des));
            }
            v2.setGroups(list);
        }
        return base;
    }

    public void loadGlobalPreferences(GlobalPreferences gp) {
        IEclipsePreferences pref = ValidationFramework.getDefault().getPreferenceStore();
        gp.setSaveAutomatically(pref.getBoolean("saveAuto", false));
        gp.setDisableAllValidation(pref.getBoolean("suspend", false));
        gp.setConfirmDialog(pref.getBoolean("confirmDialog", true));
        gp.setOverride(pref.getBoolean("override", true));
        gp.setVersion(pref.getInt("vf.version", 2));
        gp.setStateTimeStamp(pref.getLong("stateTS", 0L));
        if (gp.getVersion() != 3) {
            ValPrefManagerGlobal.migrate(gp.getVersion(), pref);
        }
    }

    static void migrate(int version, IEclipsePreferences pref) {
        try {
            boolean update = false;
            if (version == 2) {
                if (pref.nodeExists("filters")) {
                    pref.node("filters").removeNode();
                    update = true;
                }
                if (pref.nodeExists("msgs")) {
                    pref.node("msgs").removeNode();
                    update = true;
                }
            }
            if (update) {
                pref.putInt("vf.version", 3);
                pref.flush();
            }
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    static void save(Validator validator, Preferences root, Map<String, Validator> baseValidators) throws BackingStoreException {
        FilterGroup[] groups;
        Collection<MessageSeveritySetting> msgs;
        Validator.V2 v2 = validator.asV2Validator();
        if (v2 == null) {
            return;
        }
        Preferences vp = root.node(validator.getId());
        if (validator.sameConfig(baseValidators.get(validator.getId()))) {
            vp.removeNode();
            return;
        }
        if (!validator.isChanged()) {
            return;
        }
        if (validator.getChangeCountGlobal() > 0) {
            Global g = new Global(validator.isManualValidation(), validator.isBuildValidation(), validator.getVersion(), validator.getDelegatingId());
            vp.put("global", g.serialize());
        }
        if (validator.getChangeCountMessages() > 0 && (msgs = validator.getMessageSettings().values()).size() > 0) {
            vp.put("msgs", Msgs.serialize(msgs));
        }
        if (v2.getChangeCountGroups() > 0 && (groups = v2.getGroups()).length > 0) {
            Serializer ser = new Serializer(500);
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                group.save(ser);
                ++n2;
            }
            vp.put("groups", ser.toString());
        }
    }

    public void saveAsPrefs(Validator[] val) {
        try {
            IEclipsePreferences pref = ValidationFramework.getDefault().getPreferenceStore();
            Preferences vals = pref.node("vals");
            Map<String, Validator> base = ExtensionValidators.instance().getMapV2();
            Validator[] validatorArray = val;
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            pref.flush();
            this._validators = null;
            this.updateListeners(true);
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void savePreferences(GlobalPreferences gp, Validator[] validators) {
        try {
            IEclipsePreferences prefs = ValidationFramework.getDefault().getPreferenceStore();
            this.savePreferences(prefs, gp);
            Preferences vals = prefs.node("vals");
            Map<String, Validator> base = ExtensionValidators.instance().getMapV2();
            Validator[] validatorArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            prefs.flush();
            this._validators = null;
            this.updateListeners(true);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public synchronized void savePreferences(GlobalPreferences gp) {
        try {
            IEclipsePreferences prefs = ValidationFramework.getDefault().getPreferenceStore();
            boolean isConfigChange = gp.isConfigChange();
            this.savePreferences(prefs, gp);
            prefs.flush();
            this.updateListeners(isConfigChange);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private void savePreferences(IEclipsePreferences prefs, GlobalPreferences gp) {
        prefs.putBoolean("saveAuto", gp.getSaveAutomatically());
        prefs.putBoolean("suspend", gp.getDisableAllValidation());
        prefs.putLong("stateTS", gp.getStateTimeStamp());
        prefs.putBoolean("confirmDialog", gp.getConfirmDialog());
        prefs.putBoolean("override", gp.getOverride());
        prefs.putInt("vf.version", 3);
    }

    public void loadMessages(Validator validator, Map<String, MessageSeveritySetting> settings) {
        IEclipsePreferences pref = ValidationFramework.getDefault().getPreferenceStore();
        try {
            ValPrefManagerGlobal.loadMessageSettings(validator, settings, (Preferences)pref);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    static void loadMessageSettings(Validator val, Map<String, MessageSeveritySetting> settings, Preferences root) throws BackingStoreException {
        if (!root.nodeExists("vals")) {
            return;
        }
        Preferences vals = root.node("vals");
        if (!vals.nodeExists(val.getId())) {
            return;
        }
        Preferences valPrefs = vals.node(val.getId());
        String msgs = valPrefs.get("msgs", "");
        if (msgs.length() == 0) {
            return;
        }
        Map<String, MessageSeveritySetting.Severity> map = Msgs.deserialize(msgs);
        for (Map.Entry<String, MessageSeveritySetting.Severity> me : map.entrySet()) {
            MessageSeveritySetting ms = settings.get(me.getKey());
            if (ms == null) continue;
            ms.setCurrent(me.getValue());
        }
    }

    private static class Global {
        private boolean _manual;
        private boolean _build;
        private int _version;
        private String _delegating;

        public Global(String value) {
            Deserializer d = new Deserializer(value);
            this._manual = d.getBoolean();
            this._build = d.getBoolean();
            this._version = d.getInt();
            if (d.hasNext()) {
                this._delegating = d.getString();
            }
        }

        public Global(boolean manual, boolean build, int version, String delegating) {
            this._manual = manual;
            this._build = build;
            this._version = version;
            this._delegating = delegating;
        }

        public String serialize() {
            Serializer s = new Serializer(50);
            s.put(this._manual);
            s.put(this._build);
            s.put(this._version);
            if (this._delegating != null) {
                s.put(this._delegating);
            }
            return s.toString();
        }

        public boolean isManual() {
            return this._manual;
        }

        public boolean isBuild() {
            return this._build;
        }

        public int getVersion() {
            return this._version;
        }

        public String getDelegating() {
            return this._delegating;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Msgs {
        private Msgs() {
        }

        public static String serialize(Collection<MessageSeveritySetting> messages) {
            Serializer s = new Serializer(100);
            for (MessageSeveritySetting ms : messages) {
                s.put(ms.getId());
                s.put(ms.getCurrent().ordinal());
            }
            return s.toString();
        }

        public static Map<String, MessageSeveritySetting.Severity> deserialize(String v) {
            HashMap<String, MessageSeveritySetting.Severity> map = new HashMap<String, MessageSeveritySetting.Severity>(10);
            Deserializer d = new Deserializer(v);
            while (d.hasNext()) {
                String id = d.getString();
                int sev = d.getInt();
                map.put(id, MessageSeveritySetting.Severity.values()[sev]);
            }
            return map;
        }
    }
}

