/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.DependentResource;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyIndex
implements IDependencyIndex,
ISaveParticipant {
    private Map<IResource, Set<Depends>> _dependsOn;
    private Map<IResource, Set<Depends>> _dependents;
    private boolean _dirty;
    private static IResource[] EmptyResources = new IResource[0];
    private static final int CurrentVersion = 1;

    @Override
    public synchronized void add(String id, IResource dependent, IResource dependsOn) {
        this.init();
        Depends d = this.getOrCreateDepends(dependent, dependsOn);
        if (d.getValidators().add(id)) {
            this._dirty = true;
        }
    }

    private Depends getOrCreateDepends(IResource dependent, IResource dependsOn) {
        Depends d2;
        Set<Depends> set = this.getSet(this._dependents, dependent);
        for (Depends d2 : set) {
            if (d2.getDependsOn() != dependsOn) continue;
            return d2;
        }
        d2 = new Depends(dependent, dependsOn);
        this._dirty = true;
        set.add(d2);
        this.getSet(this._dependsOn, dependsOn).add(d2);
        return d2;
    }

    private Set<Depends> getSet(Map<IResource, Set<Depends>> map, IResource resource) {
        Set<Depends> set = map.get(resource);
        if (set == null) {
            set = new HashSet<Depends>(5);
            map.put(resource, set);
        }
        return set;
    }

    private void init() {
        block19: {
            if (this._dependsOn != null) {
                return;
            }
            boolean error = false;
            File f = this.getIndexLocation();
            if (!f.exists()) {
                this._dependsOn = new HashMap<IResource, Set<Depends>>(100);
                this._dependents = new HashMap<IResource, Set<Depends>>(100);
            } else {
                String errorMessage = "The following dependency could not be restored because the following resource {0} could no longer be found.";
                DataInputStream in = null;
                try {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        in = new DataInputStream(new FileInputStream(f));
                        int version = in.readInt();
                        if (version != 1) {
                            error = true;
                            String msg = NLS.bind((String)ValMessages.ErrDependencyVersion, (Object)1);
                            throw new IllegalStateException(msg);
                        }
                        int numDependsOn = in.readInt();
                        this._dependsOn = new HashMap<IResource, Set<Depends>>(numDependsOn + 100);
                        this._dependents = new HashMap<IResource, Set<Depends>>(numDependsOn + 100);
                        int i = 0;
                        while (i < numDependsOn) {
                            String v = in.readUTF();
                            IResource dependsOn = root.findMember(v);
                            if (v == null) {
                                Tracing.log(NLS.bind((String)errorMessage, (Object)v));
                            } else {
                                int numDependents = in.readInt();
                                int j = 0;
                                while (j < numDependents) {
                                    v = in.readUTF();
                                    IResource dependent = root.findMember(v);
                                    if (dependent == null) {
                                        Tracing.log(NLS.bind((String)errorMessage, (Object)v));
                                    } else {
                                        int numVal = in.readInt();
                                        int k = 0;
                                        while (k < numVal) {
                                            String id = in.readUTF();
                                            this.add(id, dependent, dependsOn);
                                            ++k;
                                        }
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        error = true;
                        ValidationPlugin.getPlugin().handleException(e);
                        Misc.close(in);
                        if (error) {
                            this._dependsOn = new HashMap<IResource, Set<Depends>>(100);
                            this._dependents = new HashMap<IResource, Set<Depends>>(100);
                            f.delete();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    Misc.close(in);
                    if (error) {
                        this._dependsOn = new HashMap<IResource, Set<Depends>>(100);
                        this._dependents = new HashMap<IResource, Set<Depends>>(100);
                        f.delete();
                    }
                    throw throwable;
                }
                Misc.close(in);
                if (error) {
                    this._dependsOn = new HashMap<IResource, Set<Depends>>(100);
                    this._dependents = new HashMap<IResource, Set<Depends>>(100);
                    f.delete();
                }
            }
        }
    }

    @Override
    public synchronized void clear(IProject project) {
        this.init();
        for (Map.Entry<IResource, Set<Depends>> me : this._dependents.entrySet()) {
            if (me.getKey().getProject() != project) continue;
            for (Depends d : me.getValue()) {
                if (!d.delete()) continue;
                this._dirty = true;
            }
        }
    }

    @Override
    public synchronized IResource[] get(String validatorId, IResource dependsOn) {
        this.init();
        LinkedList<IResource> list = new LinkedList<IResource>();
        Set<Depends> set = this.getSet(this._dependsOn, dependsOn);
        for (Depends d : set) {
            for (String id : d.getValidators()) {
                if (!validatorId.equals(id)) continue;
                list.add(d.getDependent());
            }
        }
        if (list.size() == 0) {
            return EmptyResources;
        }
        IResource[] resources = new IResource[list.size()];
        list.toArray(resources);
        return resources;
    }

    @Override
    public synchronized List<DependentResource> get(IResource dependsOn) {
        this.init();
        LinkedList<DependentResource> list = new LinkedList<DependentResource>();
        Set<Depends> set = this.getSet(this._dependsOn, dependsOn);
        ValManager vm = ValManager.getDefault();
        for (Depends d : set) {
            for (String id : d.getValidators()) {
                Validator v = vm.getValidator(id, d.getDependent().getProject());
                if (v == null) continue;
                list.add(new DependentResource(d.getDependent(), v));
            }
        }
        return list;
    }

    @Override
    public synchronized void set(String id, IResource dependent, IResource[] dependsOn) {
        this.init();
        Set<Depends> set = this.getSet(this._dependents, dependent);
        for (Depends d : set) {
            if (!d.delete(id)) continue;
            this._dirty = true;
        }
        if (dependsOn != null) {
            IResource[] iResourceArray = dependsOn;
            int n = dependsOn.length;
            int n2 = 0;
            while (n2 < n) {
                Depends d;
                d = iResourceArray[n2];
                this.add(id, dependent, (IResource)d);
                ++n2;
            }
        }
    }

    @Override
    public boolean isDependedOn(IResource resource) {
        this.init();
        Set<Depends> set = this._dependsOn.get(resource);
        return set != null && set.size() != 0;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public synchronized void saving(ISaveContext context) throws CoreException {
        block9: {
            if (!this._dirty) {
                return;
            }
            this._dirty = false;
            DataOutputStream out = null;
            try {
                try {
                    File f = this.getIndexLocation();
                    out = new DataOutputStream(new FileOutputStream(f));
                    out.writeInt(1);
                    Map<String, Set<DependsResolved>> map = this.compress(this._dependsOn);
                    out.writeInt(map.size());
                    for (Map.Entry<String, Set<DependsResolved>> me : map.entrySet()) {
                        out.writeUTF(me.getKey());
                        Set<DependsResolved> set = me.getValue();
                        out.writeInt(set.size());
                        for (DependsResolved d : set) {
                            out.writeUTF(d.resource);
                            out.writeInt(d.validators.size());
                            for (String id : d.validators) {
                                out.writeUTF(id);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    Misc.close(out);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Misc.close(out);
                throw throwable;
            }
            Misc.close(out);
        }
    }

    private Map<String, Set<DependsResolved>> compress(Map<IResource, Set<Depends>> dependsOn) {
        HashMap<String, Set<DependsResolved>> map = new HashMap<String, Set<DependsResolved>>(dependsOn.size());
        for (Map.Entry<IResource, Set<Depends>> me : dependsOn.entrySet()) {
            IPath path;
            IResource res;
            HashSet<DependsResolved> set = new HashSet<DependsResolved>(me.getValue().size());
            for (Depends d : me.getValue()) {
                IPath path2 = d.getDependent().getFullPath();
                if (path2 == null) continue;
                DependsResolved dr = new DependsResolved();
                dr.resource = path2.toPortableString();
                if (d.getValidators().size() <= 0) continue;
                dr.validators = d.getValidators();
                set.add(dr);
            }
            if (set.size() <= 0 || (res = me.getKey()) == null || (path = res.getFullPath()) == null) continue;
            map.put(path.toPortableString(), set);
        }
        return map;
    }

    private File getIndexLocation() {
        IPath path = ValidationPlugin.getPlugin().getStateLocation().append("dep.index");
        return path.toFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Depends {
        private IResource _dependsOn;
        private IResource _dependent;
        private Set<String> _validators;

        public Depends(IResource dependent, IResource dependsOn) {
            this._dependent = dependent;
            this._dependsOn = dependsOn;
            this._validators = new HashSet<String>(5);
        }

        public boolean delete(String id) {
            return this._validators.remove(id);
        }

        public boolean delete() {
            boolean deleted;
            boolean bl = deleted = this._validators.size() > 0;
            if (deleted) {
                this._validators.clear();
            }
            return deleted;
        }

        public IResource getDependsOn() {
            return this._dependsOn;
        }

        public IResource getDependent() {
            return this._dependent;
        }

        public Set<String> getValidators() {
            return this._validators;
        }
    }

    private static class DependsResolved {
        String resource;
        Set<String> validators;

        private DependsResolved() {
        }
    }
}

