/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDAttributeDeclarationCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeReferenceAndManagerDirectivesCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeReferenceCommand;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewAttributeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;

public class XSDAttributeReferenceEditManager
extends XSDElementReferenceEditManager
implements ComponentReferenceEditManager {
    public XSDAttributeReferenceEditManager(IFile currentFile, XSDSchema[] schemas) {
        super(currentFile, schemas);
    }

    public IComponentDialog getBrowseDialog() {
        XSDSearchListDialogDelegate dialogDelegate = new XSDSearchListDialogDelegate(XSDSearchListDialogDelegate.ATTRIBUTE_META_NAME, this.currentFile, this.schemas);
        return dialogDelegate;
    }

    public IComponentDialog getNewDialog() {
        if (this.schemas.length > 0) {
            return new NewAttributeDialog(this.schemas[0]);
        }
        return new NewAttributeDialog();
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification referencedComponent) {
        XSDAttributeDeclaration concreteComponent = null;
        if (referencingObject instanceof Adapter) {
            Adapter adapter = (Adapter)referencingObject;
            if (adapter.getTarget() instanceof XSDAttributeDeclaration) {
                concreteComponent = (XSDAttributeDeclaration)adapter.getTarget();
            }
        } else if (referencingObject instanceof XSDConcreteComponent) {
            concreteComponent = (XSDAttributeDeclaration)referencingObject;
        }
        if (concreteComponent != null) {
            if (referencedComponent.isNew()) {
                BaseCommand command;
                XSDAttributeDeclaration attributeDec = null;
                if (referencedComponent.getMetaName() == IXSDSearchConstants.ATTRIBUTE_META_NAME) {
                    command = new AddXSDAttributeDeclarationCommand(Messages._UI_ACTION_ADD_ATTRIBUTE, (XSDConcreteComponent)concreteComponent.getSchema());
                    ((AddXSDAttributeDeclarationCommand)command).setNameToAdd(referencedComponent.getName());
                    ((AddXSDAttributeDeclarationCommand)command).execute();
                    attributeDec = (XSDAttributeDeclaration)command.getAddedComponent();
                }
                if (attributeDec != null) {
                    command = new UpdateAttributeReferenceCommand(Messages._UI_ACTION_UPDATE_ATTRIBUTE_REFERENCE, concreteComponent, attributeDec);
                    command.execute();
                }
            } else {
                UpdateAttributeReferenceAndManagerDirectivesCommand command = new UpdateAttributeReferenceAndManagerDirectivesCommand((XSDConcreteComponent)concreteComponent, referencedComponent.getName(), referencedComponent.getQualifier(), referencedComponent.getFile());
                command.setLabel(Messages._UI_ACTION_UPDATE_ATTRIBUTE_REFERENCE);
                command.execute();
            }
        }
    }
}

