/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDParticleAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IGraphElement;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDAnyElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDModelGroupAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.SetMultiplicityAction;
import org.eclipse.wst.xsd.ui.internal.design.figures.ModelGroupFigure;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDWildcard;
import org.w3c.dom.Element;

public class XSDModelGroupAdapter
extends XSDParticleAdapter
implements IActionProvider,
IGraphElement {
    XSDModelGroup getXSDModelGroup() {
        return (XSDModelGroup)this.target;
    }

    public Image getImage() {
        XSDModelGroup xsdModelGroup = this.getXSDModelGroup();
        if (XSDCompositor.CHOICE_LITERAL == xsdModelGroup.getCompositor()) {
            return ModelGroupFigure.CHOICE_ICON_IMAGE;
        }
        if (XSDCompositor.ALL_LITERAL == xsdModelGroup.getCompositor()) {
            return ModelGroupFigure.ALL_ICON_IMAGE;
        }
        return ModelGroupFigure.SEQUENCE_ICON_IMAGE;
    }

    public String getText() {
        Element element;
        XSDModelGroup xsdModelGroup = this.getXSDModelGroup();
        StringBuffer result = new StringBuffer();
        String name = xsdModelGroup.getCompositor().getName();
        if (name != null) {
            result.append(name);
        }
        if ((element = xsdModelGroup.getElement()) != null) {
            boolean hasMinOccurs = element.hasAttribute("minOccurs");
            boolean hasMaxOccurs = element.hasAttribute("maxOccurs");
            if (hasMinOccurs || hasMaxOccurs) {
                int max;
                int min;
                result.append(" [");
                if (hasMinOccurs) {
                    min = ((XSDParticle)xsdModelGroup.getContainer()).getMinOccurs();
                    if (min == -1) {
                        result.append("*");
                    } else {
                        result.append(String.valueOf(min));
                    }
                } else {
                    min = ((XSDParticle)xsdModelGroup.getContainer()).getMinOccurs();
                    result.append(String.valueOf(min));
                }
                if (hasMaxOccurs) {
                    max = ((XSDParticle)xsdModelGroup.getContainer()).getMaxOccurs();
                    result.append("..");
                    if (max == -1) {
                        result.append("*");
                    } else {
                        result.append(String.valueOf(max));
                    }
                } else {
                    result.append("..");
                    max = ((XSDParticle)xsdModelGroup.getContainer()).getMaxOccurs();
                    result.append(String.valueOf(max));
                }
                result.append("]");
            }
        }
        return result.toString();
    }

    public ITreeElement[] getChildren() {
        XSDModelGroup xsdModelGroup = this.getXSDModelGroup();
        ArrayList<XSDParticleContent> list = new ArrayList<XSDParticleContent>();
        Iterator i = xsdModelGroup.getContents().iterator();
        while (i.hasNext()) {
            Object object = i.next();
            XSDParticleContent particle = ((XSDParticle)object).getContent();
            if (particle instanceof XSDElementDeclaration) {
                list.add(particle);
                continue;
            }
            if (particle instanceof XSDWildcard) {
                list.add(particle);
                continue;
            }
            if (particle instanceof XSDModelGroup) {
                list.add(particle);
                continue;
            }
            if (!(particle instanceof XSDModelGroupDefinition)) continue;
            list.add(particle);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList.toArray(new ITreeElement[0]);
    }

    public Object getParent(Object object) {
        XSDModelGroup element = (XSDModelGroup)object;
        return element.getContainer();
    }

    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        actionIDs.add(AddXSDElementAction.ID);
        actionIDs.add(AddXSDElementAction.REF_ID);
        actionIDs.add(AddXSDAnyElementAction.ID);
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add(AddXSDModelGroupAction.SEQUENCE_ID);
        actionIDs.add(AddXSDModelGroupAction.CHOICE_ID);
        actionIDs.add(AddXSDModelGroupAction.ALL_ID);
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add("AddXSDModelGroupDefinitionRefAction");
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_MULTIPLICITY);
        actionIDs.add(SetMultiplicityAction.REQUIRED_ID);
        actionIDs.add(SetMultiplicityAction.ZERO_OR_ONE_ID);
        actionIDs.add(SetMultiplicityAction.ZERO_OR_MORE_ID);
        actionIDs.add(SetMultiplicityAction.ONE_OR_MORE_ID);
        actionIDs.add("SUBMENU_END_ID: ");
        if (!(this.getParent(this.target) instanceof XSDModelGroupDefinition)) {
            actionIDs.add("org.eclipse.jface.action.Separator");
            actionIDs.add("org.eclipse.wst.xsd.ui.internal.common.actions.DeleteXSDConcreteComponentAction");
        }
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return actionIDs.toArray(new String[0]);
    }

    public int getMaxOccurs() {
        return XSDModelGroupAdapter.getMaxOccurs((XSDConcreteComponent)this.getXSDModelGroup());
    }

    public int getMinOccurs() {
        return XSDModelGroupAdapter.getMinOccurs((XSDConcreteComponent)this.getXSDModelGroup());
    }

    public IADTObject getTopContainer() {
        XSDModelGroup xsdModelGroup = this.getXSDModelGroup();
        return this.getGlobalXSDContainer((XSDConcreteComponent)xsdModelGroup);
    }

    public boolean isFocusAllowed() {
        return false;
    }
}

