/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.templates.TemplateHandlerContentProposalProvider;
import org.eclipse.mylyn.team.ui.AbstractContextChangeSetManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class FocusedTeamPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.mylyn.team.ui.ui.preferences";
    private Button manageChangeSets;
    private Text commitTemplate = null;

    public FocusedTeamPreferencePage() {
        this.setPreferenceStore(FocusedTeamUiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createChangeSetGroup(container);
        this.createCommitGroup(container);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.team.commit.template", this.commitTemplate.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.team.changesets.manage", this.manageChangeSets.getSelection());
        if (this.manageChangeSets.getSelection()) {
            for (AbstractContextChangeSetManager changeSetManager : FocusedTeamUiPlugin.getDefault().getContextChangeSetManagers()) {
                changeSetManager.enable();
            }
        } else {
            for (AbstractContextChangeSetManager changeSetManager : FocusedTeamUiPlugin.getDefault().getContextChangeSetManagers()) {
                changeSetManager.disable();
            }
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.commitTemplate.setText(this.getPreferenceStore().getDefaultString("org.eclipse.mylyn.team.commit.template"));
        this.manageChangeSets.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.team.changesets.manage"));
    }

    private void createChangeSetGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Change Set Management");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.manageChangeSets = new Button((Composite)group, 32);
        this.manageChangeSets.setText("Automatically create and manage with task context");
        this.manageChangeSets.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.team.changesets.manage"));
    }

    private void createCommitGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Commit Comment Template");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        String completedTemplate = this.getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
        this.commitTemplate = this.addTemplateField((Composite)group, completedTemplate, new TemplateHandlerContentProposalProvider());
    }

    private Text addTemplateField(Composite parent, String text, IContentProposalProvider provider) {
        TextContentAdapter adapter = new TextContentAdapter();
        Text control = new Text(parent, 2050);
        control.setText(text);
        new ContentAssistCommandAdapter((Control)control, (IControlContentAdapter)adapter, provider, null, new char[]{'$'}, true);
        GridData gd = new GridData();
        gd.heightHint = 60;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.grabExcessVerticalSpace = false;
        control.setLayoutData((Object)gd);
        return control;
    }
}

