/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.actions;

import java.io.InputStream;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryAttachment;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskAttachmentStorage;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class ApplyPatchAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private ISelection currentSelection;

    public ApplyPatchAction() {
        super("Apply Patch");
    }

    protected ApplyPatchAction(String text) {
        super(text);
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.currentSelection instanceof StructuredSelection) {
            Object object = ((StructuredSelection)this.currentSelection).getFirstElement();
            if (object instanceof RepositoryAttachment) {
                final RepositoryAttachment attachment = (RepositoryAttachment)object;
                IStorage storage = new IStorage(){

                    public InputStream getContents() throws CoreException {
                        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(attachment.getRepositoryKind(), attachment.getRepositoryUrl());
                        AbstractLegacyRepositoryConnector connector = (AbstractLegacyRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(attachment.getRepositoryKind());
                        AbstractAttachmentHandler handler = connector.getAttachmentHandler();
                        return handler.getAttachmentAsStream(repository, attachment, (IProgressMonitor)new NullProgressMonitor());
                    }

                    public IPath getFullPath() {
                        return FocusedTeamUiPlugin.getDefault().getStateLocation();
                    }

                    public String getName() {
                        return null;
                    }

                    public boolean isReadOnly() {
                        return true;
                    }

                    public Object getAdapter(Class adapter) {
                        return null;
                    }
                };
                ApplyPatchOperation op = new ApplyPatchOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), storage, null, new CompareConfiguration());
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)op);
            } else if (object instanceof ITaskAttachment) {
                IStorage storage;
                ITaskAttachment attachment = (ITaskAttachment)object;
                try {
                    storage = TaskAttachmentStorage.create((ITaskAttachment)attachment);
                }
                catch (CoreException e) {
                    TasksUiInternal.displayStatus((String)"Error Retrieving Context", (IStatus)e.getStatus());
                    return;
                }
                ApplyPatchOperation op = new ApplyPatchOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), storage, null, new CompareConfiguration());
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)op);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }
}

