/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.ContextChangeSet;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.team.ui.AbstractActiveChangeSetProvider;
import org.eclipse.mylyn.team.ui.AbstractContextChangeSetManager;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextActiveChangeSetManager
extends AbstractContextChangeSetManager {
    private final List<ActiveChangeSetManager> changeSetManagers = new ArrayList<ActiveChangeSetManager>();
    private final Map<String, IContextChangeSet> activeChangeSets = new HashMap<String, IContextChangeSet>();
    private static final String LABEL_NO_TASK = "<No Active Task>";
    private static final String HANDLE_NO_TASK = "org.eclipse.mylyn.team.ui.inactive.proxy";
    private final Map<ActiveChangeSetManager, ActiveChangeSet> noTaskSetMap = new HashMap<ActiveChangeSetManager, ActiveChangeSet>();
    private final ITask noTaskActiveProxy = new LocalTask("org.eclipse.mylyn.team.ui.inactive.proxy", "<No Active Task>");
    private final IChangeSetChangeListener CHANGE_SET_LISTENER = new IChangeSetChangeListener(){

        public void setRemoved(ChangeSet set) {
            IContextChangeSet contextChangeSet;
            if (set instanceof IContextChangeSet && (contextChangeSet = (IContextChangeSet)set).getTask() != null && contextChangeSet.getTask().isActive()) {
                for (ActiveChangeSetManager collector : ContextActiveChangeSetManager.this.changeSetManagers) {
                    collector.add((ChangeSet)((ActiveChangeSet)contextChangeSet));
                }
            }
        }

        public void setAdded(ChangeSet set) {
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
        }

        public void nameChanged(ChangeSet set) {
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
        }
    };

    public ContextActiveChangeSetManager() {
        Collection<AbstractActiveChangeSetProvider> providerList = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProviders();
        for (AbstractActiveChangeSetProvider provider : providerList) {
            ActiveChangeSetManager changeSetManager = provider.getActiveChangeSetManager();
            if (changeSetManager == null) continue;
            this.changeSetManagers.add(changeSetManager);
            changeSetManager.addListener(this.CHANGE_SET_LISTENER);
        }
    }

    @Override
    protected void updateChangeSetLabel(ITask task) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IContextChangeSet contextChangeSet;
                ChangeSet set = changeSetArray[n2];
                if (set instanceof IContextChangeSet && (contextChangeSet = (IContextChangeSet)set).getTask().equals(task)) {
                    contextChangeSet.updateLabel();
                }
                ++n2;
            }
        }
    }

    @Override
    public void enable() {
        super.enable();
        if (!this.isEnabled) {
            for (ActiveChangeSetManager collector : this.changeSetManagers) {
                collector.addListener(this.CHANGE_SET_LISTENER);
            }
        }
    }

    @Override
    public void disable() {
        super.disable();
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            collector.removeListener(this.CHANGE_SET_LISTENER);
        }
    }

    @Override
    protected void initContextChangeSets() {
        for (ActiveChangeSetManager manager : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = manager.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet restoredSet = changeSetArray[n2];
                if (!(restoredSet instanceof IContextChangeSet)) {
                    String encodedTitle = restoredSet.getName();
                    String taskHandle = ContextChangeSet.getHandleFromPersistedTitle(encodedTitle);
                    AbstractTask task = TasksUiPlugin.getTaskList().getTask(taskHandle);
                    if (task != null) {
                        try {
                            AbstractActiveChangeSetProvider changeSetProvider = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProvider(manager);
                            IContextChangeSet contextChangeSet = changeSetProvider.createChangeSet((ITask)task);
                            if (contextChangeSet instanceof ActiveChangeSet) {
                                contextChangeSet.restoreResources(restoredSet.getResources());
                                manager.remove(restoredSet);
                                manager.add((ChangeSet)((ActiveChangeSet)contextChangeSet));
                            }
                        }
                        catch (Exception e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Could not restore change set", (Throwable)e));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void clearActiveChangeSets() {
        this.activeChangeSets.clear();
    }

    public IResource[] getResources(ITask task) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IContextChangeSet contextChangeSet;
                ChangeSet set = changeSetArray[n2];
                if (set instanceof IContextChangeSet && (contextChangeSet = (IContextChangeSet)set).getTask().equals(task) && contextChangeSet instanceof ActiveChangeSet) {
                    return ((ActiveChangeSet)contextChangeSet).getResources();
                }
                ++n2;
            }
        }
        return null;
    }

    public void contextActivated(IInteractionContext context) {
        try {
            ITask task = this.getTask(context);
            if (task != null && !this.activeChangeSets.containsKey(task.getHandleIdentifier())) {
                for (ActiveChangeSetManager manager : this.changeSetManagers) {
                    AbstractActiveChangeSetProvider changeSetProvider = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProvider(manager);
                    IContextChangeSet contextChangeSet = changeSetProvider.createChangeSet(task);
                    if (!(contextChangeSet instanceof ActiveChangeSet)) continue;
                    ActiveChangeSet activeChangeSet = (ActiveChangeSet)contextChangeSet;
                    List interestingResources = ResourcesUiBridgePlugin.getDefault().getInterestingResources(context);
                    activeChangeSet.add(interestingResources.toArray(new IResource[interestingResources.size()]));
                    this.activeChangeSets.put(task.getHandleIdentifier(), contextChangeSet);
                    if (!manager.contains((ChangeSet)activeChangeSet)) {
                        manager.add((ChangeSet)activeChangeSet);
                    }
                    manager.makeDefault(activeChangeSet);
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Could not update change set", (Throwable)e));
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = collector.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] resources;
                ChangeSet set = changeSetArray[n2];
                if (set instanceof ActiveChangeSet && ((resources = set.getResources()) == null || resources.length == 0)) {
                    collector.remove(set);
                }
                ++n2;
            }
            ActiveChangeSet noTaskSet = collector.getSet(LABEL_NO_TASK);
            if (noTaskSet == null) {
                noTaskSet = this.noTaskSetMap.get(collector);
            }
            if (noTaskSet == null) {
                AbstractActiveChangeSetProvider changeSetProvider = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProvider(collector);
                noTaskSet = (ActiveChangeSet)changeSetProvider.createChangeSet(this.noTaskActiveProxy);
                collector.add((ChangeSet)noTaskSet);
                this.noTaskSetMap.put(collector, noTaskSet);
            }
            collector.makeDefault(noTaskSet);
            collector.remove((ChangeSet)noTaskSet);
        }
        this.activeChangeSets.clear();
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)element.getContentType());
            try {
                IResource resource;
                if (!bridge.isDocument(element.getHandleIdentifier()) || (resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(element, false)) == null || !resource.exists()) continue;
                for (IContextChangeSet activeContextChangeSet : this.getActiveChangeSets()) {
                    if (!(activeContextChangeSet instanceof ActiveChangeSet) || ((ActiveChangeSet)activeContextChangeSet).contains(resource) || !element.getInterest().isInteresting()) continue;
                    ((ActiveChangeSet)activeContextChangeSet).add(new IResource[]{resource});
                }
                if (!this.shouldRemove(element)) continue;
                for (ActiveChangeSetManager collector : this.changeSetManagers) {
                    ChangeSet[] sets;
                    ChangeSet[] changeSetArray = sets = collector.getSets();
                    int n = sets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ChangeSet set = changeSetArray[n2];
                        if (set instanceof ActiveChangeSet) {
                            set.remove(resource);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Could not manipulate change set resources", (Throwable)e));
            }
        }
    }

    public List<IContextChangeSet> getActiveChangeSets() {
        return new ArrayList<IContextChangeSet>(this.activeChangeSets.values());
    }

    private ITask getTask(IInteractionContext context) {
        return TasksUi.getTaskActivityManager().getActiveTask();
    }

    private boolean shouldRemove(IInteractionElement element) {
        return element.getInterest().getValue() + element.getInterest().getDecayValue() < ContextCore.getCommonContextScaling().getInteresting();
    }
}

