/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage.view;

import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewNodeDialog
extends TitleAreaDialog {
    private static final String HELP_ID = "org.eclipse.equinox.security.ui.NewNodeDialog";
    protected Text nodeName;
    protected Button okButton;
    protected String name;

    public NewNodeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SecUIMessages.newNodeTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, SecUIMessages.newNodeOK, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, SecUIMessages.newNodeCancel, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(compositeTop, 0);
        this.setMessage(SecUIMessages.newNodeMsg);
        new Label(composite, 16384).setText(SecUIMessages.newNodeLabel);
        this.nodeName = new Text(composite, 18432);
        this.nodeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewNodeDialog.this.okButton.setEnabled(NewNodeDialog.this.validName());
            }
        });
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().generateLayout(composite);
        return composite;
    }

    protected boolean validName() {
        boolean valid;
        String tmp = this.nodeName.getText();
        if (tmp == null || tmp.length() == 0) {
            valid = false;
        } else if (tmp.equals("org.eclipse.equinox.secure.storage")) {
            valid = false;
        } else {
            boolean bl = valid = tmp.indexOf(47) == -1;
        }
        if (valid) {
            this.setMessage(SecUIMessages.newNodeMsg, 0);
        } else {
            this.setMessage(SecUIMessages.newNodeInvalid, 3);
        }
        return valid;
    }

    protected void okPressed() {
        this.name = this.nodeName.getText();
        super.okPressed();
    }

    public String getNodeName() {
        return this.name;
    }
}

