/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.model.QueriedElementCollector;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueryContext;

public class UncategorizedElementCollector
extends QueriedElementCollector {
    private ArrayList categories = new ArrayList();
    private Set allOthers = new HashSet();
    private Collector resultCollector;

    public UncategorizedElementCollector(IQueryProvider queryProvider, IQueryable queryable, QueryContext queryContext, Collector resultCollector) {
        super(queryProvider, queryable, queryContext);
        this.resultCollector = resultCollector;
    }

    public boolean accept(Object match) {
        if (match instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)match;
            if (Boolean.toString(true).equals(iu.getProperty("org.eclipse.equinox.p2.type.category"))) {
                this.categories.add(iu);
            } else {
                this.allOthers.add(iu);
            }
        }
        return true;
    }

    public Iterator iterator() {
        this.removeReferredIUsAndRecollect();
        return this.resultCollector.iterator();
    }

    public int size() {
        this.removeReferredIUsAndRecollect();
        return this.resultCollector.size();
    }

    public boolean isEmpty() {
        this.removeReferredIUsAndRecollect();
        return this.resultCollector.isEmpty();
    }

    public Object[] toArray(Class clazz) {
        this.removeReferredIUsAndRecollect();
        return this.resultCollector.toArray(clazz);
    }

    private void removeReferredIUsAndRecollect() {
        Iterator iter = this.categories.iterator();
        while (iter.hasNext()) {
            IInstallableUnit categoryIU = (IInstallableUnit)iter.next();
            RequiredCapability[] requirements = categoryIU.getRequiredCapabilities();
            int i = 0;
            while (i < requirements.length) {
                if (requirements[i].getNamespace().equals("org.eclipse.equinox.p2.iu")) {
                    IInstallableUnit[] arrayAllOthers = this.allOthers.toArray(new IInstallableUnit[this.allOthers.size()]);
                    int j = 0;
                    while (j < arrayAllOthers.length) {
                        if (arrayAllOthers[j].getId().equals(requirements[i].getName())) {
                            this.allOthers.remove(arrayAllOthers[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        iter = this.allOthers.iterator();
        while (iter.hasNext()) {
            this.resultCollector.accept(iter.next());
        }
    }

    public Collection toCollection() {
        this.removeReferredIUsAndRecollect();
        return this.resultCollector.toCollection();
    }
}

