/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.osgi.util.NLS;

abstract class UndoableProvisioningOperation
extends ProvisioningOperation
implements IUndoableOperation,
IAdvancedUndoableOperation2 {
    boolean quietCompute = false;
    List contexts = new ArrayList();

    UndoableProvisioningOperation(String label) {
        super(label);
        this.addContext(ProvUI.getProvisioningUndoContext());
    }

    protected abstract IStatus doUndo(IProgressMonitor var1, IAdaptable var2) throws ProvisionException;

    protected abstract IStatus doExecute(IProgressMonitor var1, IAdaptable var2) throws ProvisionException;

    public IStatus execute(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        IStatus status;
        try {
            status = this.doExecute(monitor, uiInfo);
        }
        catch (ProvisionException e) {
            throw new ExecutionException(NLS.bind((String)ProvUIMessages.ProvisioningOperation_ExecuteErrorTitle, (Object)this.getLabel()), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        IStatus status;
        try {
            status = this.doExecute(monitor, uiInfo);
        }
        catch (ProvisionException e) {
            throw new ExecutionException(NLS.bind((String)ProvUIMessages.ProvisioningOperation_RedoErrorTitle, (Object)this.getLabel()), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
        IStatus status;
        try {
            status = this.doUndo(monitor, uiInfo);
        }
        catch (ProvisionException e) {
            throw new ExecutionException(NLS.bind((String)ProvUIMessages.ProvisioningOperation_UndoErrorTitle, (Object)this.getLabel()), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        return status;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canRedo() {
        return this.canExecute();
    }

    public boolean canUndo() {
        return true;
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        return this.computeExecutionStatus(monitor);
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        return this.okStatus();
    }

    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        return this.okStatus();
    }

    public void setQuietCompute(boolean quiet) {
        this.quietCompute = quiet;
    }

    public void aboutToNotify(OperationHistoryEvent event) {
    }

    public void addContext(IUndoContext context) {
        if (!this.contexts.contains(context)) {
            this.contexts.add(context);
        }
    }

    public void removeContext(IUndoContext context) {
        this.contexts.remove(context);
    }

    public final IUndoContext[] getContexts() {
        return this.contexts.toArray(new IUndoContext[this.contexts.size()]);
    }

    public final boolean hasContext(IUndoContext context) {
        Assert.isNotNull((Object)context);
        int i = 0;
        while (i < this.contexts.size()) {
            IUndoContext otherContext = (IUndoContext)this.contexts.get(i);
            if (context.matches(otherContext) || otherContext.matches(context)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IStatus okStatus() {
        return Status.OK_STATUS;
    }

    public void dispose() {
    }
}

