/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IPlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.LicenseManager;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;

public abstract class ProfileModificationAction
extends ProvisioningAction {
    public static final int ACTION_NOT_RUN = -1;
    private String profileId;
    private String userChosenProfileId;
    IProfileChooser profileChooser;
    Policies policies;
    int result = -1;
    static /* synthetic */ Class class$0;

    protected ProfileModificationAction(String text, ISelectionProvider selectionProvider, String profileId, IProfileChooser profileChooser, Policies policies, Shell shell) {
        super(text, selectionProvider, shell);
        this.profileId = profileId;
        this.profileChooser = profileChooser;
        this.policies = policies;
        this.init();
    }

    protected ProvisioningPlan getProvisioningPlan() {
        final String id = this.getProfileId(true);
        if (id == null) {
            return null;
        }
        final IInstallableUnit[] ius = this.getSelectedIUs();
        final ProvisioningPlan[] plan = new ProvisioningPlan[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    plan[0] = ProfileModificationAction.this.getProvisioningPlan(ius, id, monitor);
                }
                catch (ProvisionException e) {
                    ProvUI.handleException(e, ProvUIMessages.ProfileModificationAction_UnexpectedError, 5);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException(e.getCause(), ProvUIMessages.ProfileModificationAction_UnexpectedError, 5);
        }
        return plan[0];
    }

    public void run() {
        ProvisioningPlan plan = this.getProvisioningPlan();
        this.result = this.validatePlan(plan) ? this.performOperation(this.getSelectedIUs(), this.getProfileId(true), plan) : 1;
        this.userChosenProfileId = null;
    }

    public int getReturnCode() {
        return this.result;
    }

    protected boolean validatePlan(ProvisioningPlan plan) {
        if (plan != null) {
            if (this.getPlanValidator() != null) {
                return this.getPlanValidator().continueWorkingWithPlan(plan, this.getShell());
            }
            if (plan.getStatus().isOK()) {
                return true;
            }
            ProvUI.reportStatus(plan.getStatus(), 5);
            return false;
        }
        return false;
    }

    protected abstract ProvisioningPlan getProvisioningPlan(IInstallableUnit[] var1, String var2, IProgressMonitor var3) throws ProvisionException;

    protected abstract int performOperation(IInstallableUnit[] var1, String var2, ProvisioningPlan var3);

    protected abstract String getTaskName();

    protected IInstallableUnit getIU(Object element) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit)ProvUI.getAdapter(element, clazz);
    }

    protected IInstallableUnit[] getSelectedIUs() {
        List elements = this.getStructuredSelection().toList();
        ArrayList<IInstallableUnit> iusList = new ArrayList<IInstallableUnit>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            IInstallableUnit iu = this.getIU(elements.get(i));
            if (iu != null && !ProvisioningUtil.isCategory(iu)) {
                iusList.add(iu);
            }
            ++i;
        }
        return iusList.toArray(new IInstallableUnit[iusList.size()]);
    }

    protected LicenseManager getLicenseManager() {
        return this.policies.getLicenseManager();
    }

    protected IQueryProvider getQueryProvider() {
        return this.policies.getQueryProvider();
    }

    protected IPlanValidator getPlanValidator() {
        return this.policies.getPlanValidator();
    }

    protected Policies getPolicies() {
        return this.policies;
    }

    protected final void checkEnablement(Object[] selections) {
        if (this.isEnabledFor(selections)) {
            String id = this.getProfileId(false);
            if (id == null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(!ProvisioningOperationRunner.hasScheduledOperationsFor(id));
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected abstract boolean isEnabledFor(Object[] var1);

    protected int getLock(IProfile profile, IInstallableUnit iu) {
        if (profile == null) {
            return 0;
        }
        try {
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    protected IProfile getProfile(boolean chooseProfile) {
        String id;
        block3: {
            try {
                id = this.getProfileId(chooseProfile);
                if (id != null) break block3;
                return null;
            }
            catch (ProvisionException provisionException) {
                return null;
            }
        }
        return ProvisioningUtil.getProfile(id);
    }

    protected String getProfileId(boolean chooseProfile) {
        if (this.profileId != null) {
            return this.profileId;
        }
        if (this.userChosenProfileId != null) {
            return this.userChosenProfileId;
        }
        if (chooseProfile && this.profileChooser != null) {
            this.userChosenProfileId = this.profileChooser.getProfileId(this.getShell());
            return this.userChosenProfileId;
        }
        return null;
    }
}

