/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateManagerCompatibility {
    private static final String ECLIPSE_INSTALL_HANDLER_PROP = "org.eclipse.update.installHandler";
    private static final String UPDATE_MANAGER_FIND_AND_INSTALL = "org.eclipse.ui.update.findAndInstallUpdates";
    private static final String UPDATE_MANAGER_MANAGE_CONFIGURATION = "org.eclipse.ui.update.manageConfiguration";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static void parse(String fileName, Vector bookmarks) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(file);
            Element root = doc.getDocumentElement();
            UpdateManagerCompatibility.processRoot(root, bookmarks);
        }
        catch (ParserConfigurationException e) {
            UpdateManagerCompatibility.logFail(e);
        }
        catch (SAXException e) {
            UpdateManagerCompatibility.logFail(e);
        }
        catch (IOException e) {
            UpdateManagerCompatibility.logFail(e);
        }
    }

    private static MetadataRepositoryElement[] getSites(Vector bookmarks) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < bookmarks.size()) {
            if (bookmarks.get(i) instanceof MetadataRepositoryElement) {
                result.add(bookmarks.get(i));
            }
            ++i;
        }
        return result.toArray(new MetadataRepositoryElement[result.size()]);
    }

    private static void processRoot(Node root, Vector bookmarks) {
        if (root.getNodeName().equals("bookmarks")) {
            NodeList children = root.getChildNodes();
            UpdateManagerCompatibility.processChildren(children, bookmarks);
        }
    }

    private static void processChildren(NodeList children, Vector bookmarks) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("site")) {
                    UpdateManagerCompatibility.createSite(child, bookmarks);
                } else if (child.getNodeName().equals("folder")) {
                    UpdateManagerCompatibility.createFolder(child, bookmarks);
                }
            }
            ++i;
        }
    }

    private static void createSite(Node child, Vector bookmarks) {
        URL url = null;
        try {
            url = new URL(UpdateManagerCompatibility.getAttribute(child, "url"));
        }
        catch (MalformedURLException e) {
            UpdateManagerCompatibility.logFail(e);
            return;
        }
        String sel = UpdateManagerCompatibility.getAttribute(child, "selected");
        boolean selected = sel != null && sel.equals("true");
        bookmarks.add(new MetadataRepositoryElement(url, selected));
    }

    private static void createFolder(Node child, Vector bookmarks) {
        if (child.hasChildNodes()) {
            UpdateManagerCompatibility.processChildren(child.getChildNodes(), bookmarks);
        }
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap atts = node.getAttributes();
        Node att = atts.getNamedItem(name);
        if (att != null) {
            return att.getNodeValue();
        }
        return "";
    }

    private static void store(String fileName, Vector bookmarks) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                writer = new PrintWriter(osw);
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<bookmarks>");
                int i = 0;
                while (i < bookmarks.size()) {
                    Object obj = bookmarks.get(i);
                    UpdateManagerCompatibility.writeObject("   ", obj, writer);
                    ++i;
                }
            }
            catch (IOException e) {
                UpdateManagerCompatibility.logFail(e);
                writer.println("</bookmarks>");
                writer.flush();
                writer.close();
                try {
                    if (osw != null) {
                        osw.close();
                    }
                }
                catch (IOException e1) {
                    UpdateManagerCompatibility.logFail(e1);
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    UpdateManagerCompatibility.logFail(e2);
                }
            }
        }
        finally {
            writer.println("</bookmarks>");
            writer.flush();
            writer.close();
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e1) {
                UpdateManagerCompatibility.logFail(e1);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e2) {
                UpdateManagerCompatibility.logFail(e2);
            }
        }
    }

    private static void writeObject(String indent, Object obj, PrintWriter writer) {
        if (obj instanceof MetadataRepositoryElement) {
            MetadataRepositoryElement element = (MetadataRepositoryElement)obj;
            String sel = element.isEnabled() ? "true" : "false";
            String name = element.getName();
            writer.print(String.valueOf(indent) + "<site url=\"" + element.getLocation() + "\" selected=\"" + sel + "\" name=\"" + UpdateManagerCompatibility.getWritableXMLString(name) + "\"");
            writer.println("/>");
        }
    }

    public static boolean requiresInstallHandlerSupport(ProvisioningPlan plan) {
        Operand[] operands = plan.getOperands();
        int i = 0;
        while (i < operands.length) {
            IInstallableUnit iu;
            if (operands[i] instanceof InstallableUnitOperand && (iu = ((InstallableUnitOperand)operands[i]).second()) != null && iu.getProperty(ECLIPSE_INSTALL_HANDLER_PROP) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void importSites(Shell shell) {
        FileDialog dialog = new FileDialog(shell);
        dialog.setText(ProvUIMessages.UpdateManagerCompatibility_ImportSitesTitle);
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        MetadataRepositoryElement[] sites = null;
        String bookmarksFile = dialog.open();
        while (bookmarksFile != null && sites == null) {
            File file = new File(bookmarksFile);
            Vector bookmarks = new Vector();
            UpdateManagerCompatibility.parse(file.getAbsolutePath(), bookmarks);
            sites = UpdateManagerCompatibility.getSites(bookmarks);
            if (sites == null || sites.length == 0) {
                MessageDialog.openInformation((Shell)shell, (String)ProvUIMessages.UpdateManagerCompatibility_InvalidSitesTitle, (String)ProvUIMessages.UpdateManagerCompatibility_InvalidSiteFileMessage);
                bookmarksFile = dialog.open();
                continue;
            }
            ElementUtils.updateRepositoryUsingElements(UpdateManagerCompatibility.getSites(bookmarks), shell);
        }
    }

    public static void exportSites(Shell shell, MetadataRepositoryElement[] sites) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText(ProvUIMessages.UpdateManagerCompatibility_ExportSitesTitle);
        dialog.setFileName("bookmarks.xml");
        String bookmarksFile = dialog.open();
        if (bookmarksFile == null) {
            return;
        }
        Vector<MetadataRepositoryElement> bookmarks = new Vector<MetadataRepositoryElement>(sites.length);
        int i = 0;
        while (i < sites.length) {
            bookmarks.add(sites[i]);
            ++i;
        }
        UpdateManagerCompatibility.store(bookmarksFile, bookmarks);
    }

    public static void openInstaller() {
        UpdateManagerCompatibility.runCommand(UPDATE_MANAGER_FIND_AND_INSTALL, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenFindAndInstall);
    }

    public static void openConfigurationManager() {
        UpdateManagerCompatibility.runCommand(UPDATE_MANAGER_MANAGE_CONFIGURATION, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenManageConfiguration);
    }

    private static void runCommand(String commandId, String errorMessage) {
        ICommandService commandService;
        Command command;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(command = (commandService = (ICommandService)iWorkbench.getService((Class)clazz)).getCommand(commandId)).isDefined()) {
            return;
        }
        IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbench2.getService((Class)clazz2);
        try {
            handlerService.executeCommand(commandId, null);
        }
        catch (ExecutionException e) {
            UpdateManagerCompatibility.reportFail(errorMessage, e);
        }
        catch (NotDefinedException e) {
            UpdateManagerCompatibility.reportFail(errorMessage, e);
        }
        catch (NotEnabledException e) {
            UpdateManagerCompatibility.reportFail(errorMessage, e);
        }
        catch (NotHandledException e) {
            UpdateManagerCompatibility.reportFail(errorMessage, e);
        }
    }

    private static void logFail(Throwable t) {
        Status failStatus = new Status(4, "org.eclipse.equinox.p2.ui", t.getLocalizedMessage(), t);
        ProvUI.reportStatus((IStatus)failStatus, 1);
    }

    private static void reportFail(String message, Throwable t) {
        Status failStatus = new Status(4, "org.eclipse.equinox.p2.ui", message, t);
        ProvUI.reportStatus((IStatus)failStatus, 5);
    }

    private static String getWritableXMLString(String value) {
        StringBuffer buf = new StringBuffer();
        if (value == null) {
            return buf.toString();
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

