/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.IViewMenuProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueriedElement;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentListener;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeferredFetchFilteredTree
extends FilteredTree {
    private static final String WAIT_STRING = ProvUIMessages.DeferredFetchFilteredTree_RetrievingList;
    ToolBar toolBar;
    MenuManager menuManager;
    ToolItem viewMenuButton;
    Display display;
    PatternFilter patternFilter;
    IViewMenuProvider viewMenuProvider;
    DeferredQueryContentProvider contentProvider;
    boolean useCheckBoxTree = false;
    InputSchedulingRule filterRule;
    String savedFilterText;
    Job loadJob;
    WorkbenchJob filterJob;
    ControlEnableState enableState;
    Object viewerInput;
    ArrayList checkState = new ArrayList();

    public DeferredFetchFilteredTree(Composite parent, int treeStyle, PatternFilter filter, IViewMenuProvider viewMenuProvider, Display display, boolean useCheckBoxViewer) {
        super(parent);
        this.display = display;
        this.viewMenuProvider = viewMenuProvider;
        this.patternFilter = filter;
        this.useCheckBoxTree = useCheckBoxViewer;
        this.init(treeStyle, filter);
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        if (!this.showFilterControls && this.viewMenuProvider != null) {
            this.createViewMenu(composite);
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
        if (this.useCheckBoxTree) {
            final ContainerCheckedTreeViewer v = new ContainerCheckedTreeViewer(composite, style);
            v.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (!event.getChecked() && DeferredFetchFilteredTree.this.checkState != null) {
                        Iterator iter = DeferredFetchFilteredTree.this.checkState.iterator();
                        ArrayList toRemove = new ArrayList(1);
                        while (iter.hasNext()) {
                            Object element = iter.next();
                            if (!v.getComparer().equals(element, event.getElement())) continue;
                            toRemove.add(element);
                        }
                        DeferredFetchFilteredTree.this.checkState.removeAll(toRemove);
                    }
                }
            });
            return v;
        }
        return super.doCreateTreeViewer(composite, style);
    }

    protected Composite createFilterControls(Composite filterParent) {
        super.createFilterControls(filterParent);
        Layout layout = filterParent.getLayout();
        if (layout instanceof GridLayout) {
            ++((GridLayout)layout).numColumns;
        }
        if (this.viewMenuProvider != null) {
            this.createViewMenu(filterParent);
        }
        filterParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DeferredFetchFilteredTree.this.cancelLoadJob();
            }
        });
        return filterParent;
    }

    private void createViewMenu(Composite filterParent) {
        this.toolBar = new ToolBar(filterParent, 0x800000);
        this.viewMenuButton = new ToolItem(this.toolBar, 8, 0);
        this.viewMenuButton.setImage(JFaceResources.getImage((String)"popup_menu_image"));
        this.viewMenuButton.setToolTipText(ProvUIMessages.AvailableIUGroup_ViewByToolTipText);
        this.viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeferredFetchFilteredTree.this.showViewMenu();
            }
        });
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DeferredFetchFilteredTree.this.showViewMenu();
            }
        });
    }

    void showViewMenu() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            this.viewMenuProvider.fillViewMenu((IMenuManager)this.menuManager);
        }
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolBar.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.getParent().toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    public void contentProviderSet(DeferredQueryContentProvider deferredProvider) {
        this.contentProvider = deferredProvider;
        deferredProvider.addListener(new DeferredQueryContentListener(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
                if (newInput == null) {
                    return;
                }
                DeferredFetchFilteredTree.this.viewerInput = newInput;
                DeferredFetchFilteredTree.this.checkState = new ArrayList();
                DeferredFetchFilteredTree.this.filterRule = null;
                DeferredFetchFilteredTree.this.cancelLoadJob();
                DeferredFetchFilteredTree.this.cancelAndResetFilterJob();
                DeferredFetchFilteredTree.this.contentProvider.setSynchronous(false);
                if (DeferredFetchFilteredTree.this.showFilterControls && DeferredFetchFilteredTree.this.filterText != null && !DeferredFetchFilteredTree.this.filterText.isDisposed()) {
                    DeferredFetchFilteredTree.this.restoreAfterLoading(DeferredFetchFilteredTree.this.getInitialText());
                }
            }
        });
    }

    protected WorkbenchJob doCreateRefreshJob() {
        this.filterJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (DeferredFetchFilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = DeferredFetchFilteredTree.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                boolean bl = initial = DeferredFetchFilteredTree.this.initialText != null && DeferredFetchFilteredTree.this.initialText.equals(text);
                if (initial) {
                    DeferredFetchFilteredTree.this.patternFilter.setPattern(null);
                } else if (text != null) {
                    DeferredFetchFilteredTree.this.patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = DeferredFetchFilteredTree.this.treeComposite != null ? DeferredFetchFilteredTree.this.treeComposite : DeferredFetchFilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    DeferredFetchFilteredTree.this.treeViewer.getTree().setCursor(DeferredFetchFilteredTree.this.display.getSystemCursor(1));
                    DeferredFetchFilteredTree.this.rememberLeafCheckState();
                    DeferredFetchFilteredTree.this.treeViewer.refresh(true);
                    DeferredFetchFilteredTree.this.treeViewer.expandAll();
                    if (text.length() > 0 && !initial) {
                        DeferredFetchFilteredTree.this.updateToolbar(true);
                    } else {
                        DeferredFetchFilteredTree.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = DeferredFetchFilteredTree.this.getViewer().getTree().getItems();
                    if (items.length > 0 && DeferredFetchFilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        DeferredFetchFilteredTree.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    DeferredFetchFilteredTree.this.restoreLeafCheckState();
                    redrawFalseControl.setRedraw(true);
                    DeferredFetchFilteredTree.this.treeViewer.getTree().setCursor(null);
                }
                return Status.OK_STATUS;
            }
        };
        this.filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                boolean[] shouldLoad = new boolean[]{false};
                DeferredFetchFilteredTree.this.display.syncExec(new Runnable(this, shouldLoad){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ boolean[] val$shouldLoad;
                    {
                        this.this$1 = var1_1;
                        this.val$shouldLoad = blArray;
                    }

                    public void run() {
                        if (DeferredFetchFilteredTree.access$1(7.access$0(this.this$1)) != null && !DeferredFetchFilteredTree.access$1(7.access$0(this.this$1)).isDisposed()) {
                            String text = DeferredFetchFilteredTree.access$4(7.access$0(this.this$1));
                            if (text == null || DeferredFetchFilteredTree.access$5(7.access$0(this.this$1)) != null && DeferredFetchFilteredTree.access$5(7.access$0(this.this$1)).equals(text)) {
                                return;
                            }
                            if (!7.access$0(this.this$1).contentProvider.getSynchronous() && 7.access$0(this.this$1).loadJob == null && DeferredFetchFilteredTree.access$1(7.access$0(this.this$1)) != null && !DeferredFetchFilteredTree.access$1(7.access$0(this.this$1)).isDisposed()) {
                                7.access$0(this.this$1).disableWhileLoading();
                                this.val$shouldLoad[0] = true;
                            }
                        }
                    }
                });
                if (shouldLoad[0]) {
                    event.getJob().sleep();
                    DeferredFetchFilteredTree.this.scheduleLoadJob();
                }
            }

            public void done(IJobChangeEvent event) {
                event.getJob().setRule((ISchedulingRule)DeferredFetchFilteredTree.this.getFilterJobSchedulingRule());
            }

            static /* synthetic */ DeferredFetchFilteredTree access$0(7 var0) {
                return var0.DeferredFetchFilteredTree.this;
            }
        });
        this.filterJob.setRule((ISchedulingRule)this.getFilterJobSchedulingRule());
        return this.filterJob;
    }

    void disableWhileLoading() {
        if (this.enableState != null) {
            return;
        }
        if (this.parent != null && !this.parent.isDisposed()) {
            this.enableState = ControlEnableState.disable((Control)this.parent.getParent());
        }
        if (this.filterText != null && !this.filterText.isDisposed()) {
            this.filterText.setCursor(this.display.getSystemCursor(1));
            this.getViewer().getTree().setCursor(this.display.getSystemCursor(1));
            this.savedFilterText = this.filterText.getText();
            this.filterText.setText(WAIT_STRING);
        }
    }

    void restoreAfterLoading(String filterTextToRestore) {
        if (this.filterText != null && !this.filterText.isDisposed() && !this.filterText.isEnabled()) {
            this.filterText.setText(filterTextToRestore);
            this.filterText.setCursor(null);
            this.getViewer().getTree().setCursor(null);
            this.filterText.setSelection(filterTextToRestore.length(), filterTextToRestore.length());
        }
        if (this.enableState != null && this.parent != null && !this.parent.isDisposed()) {
            this.enableState.restore();
            this.enableState = null;
        }
        if (this.filterText != null && !this.filterText.isDisposed()) {
            this.filterText.setFocus();
        }
    }

    InputSchedulingRule getFilterJobSchedulingRule() {
        if (this.filterRule == null) {
            this.filterRule = new InputSchedulingRule(this.viewerInput);
        }
        return this.filterRule;
    }

    void scheduleLoadJob() {
        if (this.loadJob != null) {
            return;
        }
        this.loadJob = new Job(WAIT_STRING){

            protected IStatus run(IProgressMonitor monitor) {
                Object input;
                if (this.getRule() instanceof InputSchedulingRule && (input = ((InputSchedulingRule)this.getRule()).getInput()) instanceof QueriedElement && ((QueriedElement)input).getQueryable() instanceof QueryableMetadataRepositoryManager) {
                    QueryableMetadataRepositoryManager q = (QueryableMetadataRepositoryManager)((QueriedElement)input).getQueryable();
                    q.loadAll(monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DeferredFetchFilteredTree.this.contentProvider.setSynchronous(true);
                    DeferredFetchFilteredTree.this.display.asyncExec(new Runnable(this){
                        final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (10.access$0(this.this$1).getViewer() != null && !10.access$0(this.this$1).getViewer().getTree().isDisposed()) {
                                10.access$0(this.this$1).getViewer().expandAll();
                            }
                            10.access$0(this.this$1).restoreAfterLoading(10.access$0(this.this$1).savedFilterText);
                        }
                    });
                    if (DeferredFetchFilteredTree.this.filterJob != null) {
                        DeferredFetchFilteredTree.this.filterJob.wakeUp();
                    }
                }
                DeferredFetchFilteredTree.this.loadJob = null;
            }

            static /* synthetic */ DeferredFetchFilteredTree access$0(10 var0) {
                return var0.DeferredFetchFilteredTree.this;
            }
        });
        this.loadJob.setSystem(true);
        this.loadJob.setUser(false);
        this.loadJob.setRule((ISchedulingRule)this.getFilterJobSchedulingRule());
        ProvisioningOperationRunner.manageJob(this.loadJob);
        this.loadJob.schedule();
    }

    void cancelLoadJob() {
        if (this.loadJob != null) {
            this.loadJob.cancel();
            this.loadJob = null;
        }
    }

    void cancelAndResetFilterJob() {
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
    }

    protected void textChanged() {
        if (this.filterText.getText().trim().equals(WAIT_STRING)) {
            return;
        }
        super.textChanged();
    }

    void rememberLeafCheckState() {
        if (!this.useCheckBoxTree) {
            return;
        }
        ContainerCheckedTreeViewer v = (ContainerCheckedTreeViewer)this.getViewer();
        Object[] checked = v.getCheckedElements();
        if (this.checkState == null) {
            this.checkState = new ArrayList(checked.length);
        }
        int i = 0;
        while (i < checked.length) {
            if (!v.getGrayed(checked[i])) {
                this.checkState.add(checked[i]);
            }
            ++i;
        }
    }

    void restoreLeafCheckState() {
        if (!this.useCheckBoxTree) {
            return;
        }
        ContainerCheckedTreeViewer v = (ContainerCheckedTreeViewer)this.getViewer();
        if (v == null || v.getTree().isDisposed()) {
            return;
        }
        if (this.checkState == null) {
            return;
        }
        v.setCheckedElements(new Object[0]);
        v.setGrayedElements(new Object[0]);
        Iterator iter = this.checkState.iterator();
        Object element = null;
        while (iter.hasNext()) {
            element = iter.next();
            if (v.isExpandable(element)) continue;
            v.setChecked(element, true);
        }
        if (element != null) {
            v.fireCheckStateChanged(element, true);
        }
    }

    class InputSchedulingRule
    implements ISchedulingRule {
        Object input;

        InputSchedulingRule(Object input) {
            this.input = input;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof InputSchedulingRule) {
                InputSchedulingRule other = (InputSchedulingRule)rule;
                if (this.input == null) {
                    return other.getInput() == null;
                }
                return this.input.equals(other.getInput());
            }
            return false;
        }

        Object getInput() {
            return this.input;
        }
    }
}

