/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.uriresolver.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.uriresolver.internal.URIResolverExtensionDescriptor;
import org.eclipse.wst.common.uriresolver.internal.URIResolverExtensionRegistryReader;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;

public class URIResolverExtensionRegistry {
    protected HashMap map = new HashMap();
    public static final int STAGE_PRENORMALIZATION = 1;
    public static final int STAGE_POSTNORMALIZATION = 2;
    public static final int STAGE_PHYSICAL = 3;
    public static final String PRIORITY_LOW = "low";
    public static final String PRIORITY_MEDIUM = "medium";
    public static final String PRIORITY_HIGH = "high";
    protected static final String NULL_PROJECT_NATURE_ID = "";
    protected static URIResolverExtensionRegistry instance;

    private URIResolverExtensionRegistry() {
    }

    public static synchronized URIResolverExtensionRegistry getIntance() {
        if (instance == null) {
            instance = new URIResolverExtensionRegistry();
            new URIResolverExtensionRegistryReader(instance).readRegistry();
        }
        return instance;
    }

    public void put(String className, String pluginId, List projectNatureIds, String resourceType, int stage, String priority) {
        if (projectNatureIds == null) {
            projectNatureIds = new ArrayList<String>();
        }
        if (projectNatureIds.isEmpty()) {
            projectNatureIds.add(NULL_PROJECT_NATURE_ID);
        }
        URIResolverExtensionDescriptor info = new URIResolverExtensionDescriptor(className, pluginId, projectNatureIds, resourceType, stage, priority);
        Iterator idsIter = projectNatureIds.iterator();
        while (idsIter.hasNext()) {
            String key = (String)idsIter.next();
            HashMap priorityMap = (HashMap)this.map.get(key);
            if (priorityMap == null) {
                priorityMap = new HashMap();
                this.map.put(key, priorityMap);
                priorityMap.put(PRIORITY_HIGH, new ArrayList());
                priorityMap.put(PRIORITY_MEDIUM, new ArrayList());
                priorityMap.put(PRIORITY_LOW, new ArrayList());
            }
            List list = (List)priorityMap.get(priority);
            list.add(info);
        }
    }

    public List getExtensionDescriptors(IProject project) {
        ArrayList result = new ArrayList();
        ArrayList lowPriorityList = new ArrayList();
        ArrayList mediumPriorityList = new ArrayList();
        ArrayList highPriorityList = new ArrayList();
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            try {
                if (key != NULL_PROJECT_NATURE_ID && project != null && !project.hasNature(key)) continue;
                highPriorityList.addAll((List)((HashMap)this.map.get(key)).get(PRIORITY_HIGH));
                mediumPriorityList.addAll((List)((HashMap)this.map.get(key)).get(PRIORITY_MEDIUM));
                lowPriorityList.addAll((List)((HashMap)this.map.get(key)).get(PRIORITY_LOW));
            }
            catch (CoreException coreException) {}
        }
        result.addAll(highPriorityList);
        result.addAll(mediumPriorityList);
        result.addAll(lowPriorityList);
        return result;
    }

    public List getMatchingURIResolvers(List resolverInfoList, int stage) {
        ArrayList<URIResolverExtension> result = new ArrayList<URIResolverExtension>();
        Iterator i = resolverInfoList.iterator();
        while (i.hasNext()) {
            URIResolverExtension resolver;
            URIResolverExtensionDescriptor info = (URIResolverExtensionDescriptor)i.next();
            if (info.stage != stage || (resolver = info.getResolver()) == null) continue;
            result.add(resolver);
        }
        return result;
    }
}

