/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileAttributes;
import org.eclipse.ecf.filetransfer.IRemoteFileInfo;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFileAttributes;

public class URLRemoteFile
implements IRemoteFile {
    IFileID fileID;
    URLConnection urlConnection;
    IRemoteFileAttributes remoteFileAttributes;

    public URLRemoteFile(URLConnection urlConnection, IFileID fileID) {
        Assert.isNotNull((Object)urlConnection);
        this.urlConnection = urlConnection;
        Assert.isNotNull((Object)fileID);
        this.fileID = fileID;
        this.remoteFileAttributes = new URLRemoteFileAttributes();
    }

    public IFileID getID() {
        return this.fileID;
    }

    public IRemoteFileInfo getInfo() {
        return new IRemoteFileInfo(){

            public IRemoteFileAttributes getAttributes() {
                return URLRemoteFile.this.remoteFileAttributes;
            }

            public long getLastModified() {
                return URLRemoteFile.this.urlConnection.getLastModified();
            }

            public long getLength() {
                return URLRemoteFile.this.urlConnection.getContentLength();
            }

            public String getName() {
                String result = null;
                try {
                    URL url = URLRemoteFile.this.fileID.getURL();
                    String path = url.getPath();
                    int index = path.lastIndexOf("/");
                    if (index == -1) {
                        return path;
                    }
                    result = path.substring(index + 1);
                    return result;
                }
                catch (MalformedURLException malformedURLException) {
                    return URLRemoteFile.this.fileID.getName();
                }
            }

            public boolean isDirectory() {
                try {
                    return URLRemoteFile.this.fileID.getURL().toString().endsWith("/");
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }

            public void setAttributes(IRemoteFileAttributes attributes) {
            }

            public void setLastModified(long time) {
            }

            public void setName(String name) {
            }
        };
    }

    public Object getAdapter(Class adapter) {
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("URLRemoteFile[");
        buf.append("id=").append(this.getID()).append(";");
        buf.append("name=").append(this.getInfo().getName()).append(";");
        buf.append("isDir=").append(this.getInfo().isDirectory()).append(";");
        buf.append("length=").append(this.getInfo().getLength()).append(";");
        buf.append("lastMod=").append(this.getInfo().getLastModified()).append(";");
        buf.append("attr=").append(this.getInfo().getAttributes()).append("]");
        return buf.toString();
    }
}

