/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.PercentUsageComparator;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewUsageCollector
implements IUsageCollector {
    protected Map<Integer, Integer> usersNumSelections = new HashMap<Integer, Integer>();
    protected Map<Integer, Map<String, Integer>> usersNormalViewSelections = new HashMap<Integer, Map<String, Integer>>();
    protected int maxViewsToReport = -1;

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        Map<String, Integer> normalViewSelections;
        if (!this.usersNumSelections.containsKey(userId)) {
            this.usersNumSelections.put(userId, 0);
        }
        if ((normalViewSelections = this.usersNormalViewSelections.get(userId)) == null) {
            normalViewSelections = new HashMap<String, Integer>();
            this.usersNormalViewSelections.put(userId, normalViewSelections);
        }
        if (event.getKind().equals((Object)InteractionEvent.Kind.SELECTION)) {
            if (!this.usersNumSelections.containsKey(userId)) {
                this.usersNumSelections.put(userId, 0);
            }
            int numEvents = this.usersNumSelections.get(userId) + 1;
            this.usersNumSelections.put(userId, numEvents);
            String viewId = event.getOriginId();
            if (!normalViewSelections.containsKey(viewId)) {
                normalViewSelections.put(viewId, 0);
            }
            int normal = normalViewSelections.get(viewId) + 1;
            normalViewSelections.put(viewId, normal);
        }
    }

    public List<String> getSummary(int userId, boolean html) {
        Map<String, Integer> normalViewSelections = this.usersNormalViewSelections.get(userId);
        float numSelections = this.usersNumSelections.get(userId).intValue();
        ArrayList<String> summaries = new ArrayList<String>();
        ArrayList<String> viewUsage = new ArrayList<String>();
        for (String view : normalViewSelections.keySet()) {
            float viewUse = (float)normalViewSelections.get(view).intValue() / numSelections;
            String formattedViewUse = this.formatAsPercentage(viewUse);
            String ending = "";
            if (html) {
                ending = "<br>";
            }
            viewUsage.add(String.valueOf(formattedViewUse) + ": " + view + " (" + normalViewSelections.get(view) + ")" + ending);
        }
        Collections.sort(viewUsage, new PercentUsageComparator());
        int numViewsToReport = 0;
        for (String viewUsageSummary : viewUsage) {
            if (this.maxViewsToReport != -1 && numViewsToReport >= this.maxViewsToReport && !viewUsageSummary.contains("mylar")) continue;
            summaries.add(viewUsageSummary);
            ++numViewsToReport;
        }
        return summaries;
    }

    private String formatAsPercentage(float viewUse) {
        String formattedViewUse = "" + viewUse * 100.0f;
        if (formattedViewUse.contains("E")) {
            return "0.00%";
        }
        int indexOf2ndDecimal = formattedViewUse.indexOf(46) + 3;
        if (indexOf2ndDecimal <= formattedViewUse.length()) {
            formattedViewUse = formattedViewUse.substring(0, indexOf2ndDecimal);
        }
        return String.valueOf(formattedViewUse) + "%";
    }

    @Override
    public List<String> getReport() {
        ArrayList<String> summaries = new ArrayList<String>();
        for (int userId : this.usersNormalViewSelections.keySet()) {
            summaries.addAll(this.getSummary(userId, true));
        }
        return summaries;
    }

    @Override
    public String getReportTitle() {
        return "View Usage";
    }

    @Override
    public void exportAsCSVFile(String directory) {
    }

    public Map<String, Integer> getNormalViewSelections() {
        HashMap<String, Integer> normalViewSelections = new HashMap<String, Integer>();
        for (int userId : this.usersNormalViewSelections.keySet()) {
            normalViewSelections.putAll(this.usersNormalViewSelections.get(userId));
        }
        return normalViewSelections;
    }

    public void setMaxViewsToReport(int maxViewsToReport) {
        this.maxViewsToReport = maxViewsToReport;
    }

    public Map<Integer, Map<String, Integer>> getUsersNormalViewSelections() {
        return this.usersNormalViewSelections;
    }

    @Override
    public List<String> getPlainTextReport() {
        ArrayList<String> summaries = new ArrayList<String>();
        for (int userId : this.usersNormalViewSelections.keySet()) {
            summaries.addAll(this.getSummary(userId, false));
        }
        return summaries;
    }
}

