/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;

public class FocusedJavaProposalProcessor {
    static final int THRESHOLD_INTEREST = 10000;
    private static final int THRESHOLD_IMPLICIT_INTEREST = 20000;
    private static final int RELEVANCE_IMPLICIT_INTEREST = 300;
    private static final String IDENTIFIER_THIS = "this";
    public static final String LABEL_SEPARATOR = " -------------------------------------------- ";
    public static final FocusedProposalSeparator PROPOSAL_SEPARATOR = new FocusedProposalSeparator();
    private final List<IJavaCompletionProposalComputer> monitoredProposalComputers = new ArrayList<IJavaCompletionProposalComputer>();
    private final List<IJavaCompletionProposalComputer> alreadyComputedProposals = new ArrayList<IJavaCompletionProposalComputer>();
    private final List<IJavaCompletionProposalComputer> alreadyContainSeparator = new ArrayList<IJavaCompletionProposalComputer>();
    private final List<IJavaCompletionProposalComputer> containsSingleInterestingProposal = new ArrayList<IJavaCompletionProposalComputer>();
    private static FocusedJavaProposalProcessor INSTANCE = new FocusedJavaProposalProcessor();

    private FocusedJavaProposalProcessor() {
    }

    public static FocusedJavaProposalProcessor getDefault() {
        return INSTANCE;
    }

    public void addMonitoredComputer(IJavaCompletionProposalComputer proposalComputer) {
        this.monitoredProposalComputers.add(proposalComputer);
    }

    public List projectInterestModel(IJavaCompletionProposalComputer proposalComputer, List proposals) {
        try {
            if (!ContextCore.getContextManager().isContextActive()) {
                return proposals;
            }
            boolean hasInterestingProposals = false;
            for (Object object : proposals) {
                if (!(object instanceof AbstractJavaCompletionProposal)) continue;
                boolean foundInteresting = this.boostRelevanceWithInterest((AbstractJavaCompletionProposal)object);
                if (hasInterestingProposals || !foundInteresting) continue;
                hasInterestingProposals = true;
            }
            if (this.containsSingleInterestingProposal.size() > 0 && proposals.size() > 0) {
                proposals.add(PROPOSAL_SEPARATOR);
            } else if (hasInterestingProposals && this.alreadyContainSeparator.isEmpty()) {
                if (proposals.size() == 1) {
                    this.containsSingleInterestingProposal.add(proposalComputer);
                } else {
                    proposals.add(PROPOSAL_SEPARATOR);
                    this.alreadyContainSeparator.add(proposalComputer);
                }
            }
            this.alreadyComputedProposals.add(proposalComputer);
            if (this.alreadyComputedProposals.size() == this.monitoredProposalComputers.size()) {
                this.alreadyComputedProposals.clear();
                this.alreadyContainSeparator.clear();
                this.containsSingleInterestingProposal.clear();
            }
            return proposals;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Failed to project interest onto propsals", t));
            return proposals;
        }
    }

    private boolean boostRelevanceWithInterest(AbstractJavaCompletionProposal proposal) {
        boolean hasInteresting = false;
        IJavaElement javaElement = proposal.getJavaElement();
        if (javaElement != null) {
            IInteractionElement interactionElement = ContextCore.getContextManager().getElement(javaElement.getHandleIdentifier());
            float interest = interactionElement.getInterest().getValue();
            if (interest > ContextCore.getCommonContextScaling().getInteresting()) {
                proposal.setRelevance(10000 + (int)(interest * 10.0f));
                hasInteresting = true;
            }
        } else if (this.isImplicitlyInteresting(proposal)) {
            proposal.setRelevance(20000 + proposal.getRelevance());
            hasInteresting = true;
        }
        return hasInteresting;
    }

    public boolean isImplicitlyInteresting(AbstractJavaCompletionProposal proposal) {
        return proposal.getRelevance() > 300 && !IDENTIFIER_THIS.equals(proposal.getDisplayString());
    }

    static class FocusedProposalSeparator
    extends JavaCompletionProposal {
        public FocusedProposalSeparator() {
            super("", 0, 0, CommonImages.getImage((ImageDescriptor)CommonImages.SEPARATOR_LIST), FocusedJavaProposalProcessor.LABEL_SEPARATOR, 10000);
        }
    }
}

