/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;

public class LandmarkMarkerManager
extends AbstractContextListener {
    private static final String ID_MARKER_LANDMARK = "org.eclipse.mylyn.context.ui.markers.landmark";
    private final Map<IInteractionElement, Long> markerMap = new HashMap<IInteractionElement, Long>();

    public void contextActivated(IInteractionContext taskscape) {
        this.modelUpdated();
    }

    public void contextDeactivated(IInteractionContext taskscape) {
        this.modelUpdated();
    }

    public void contextCleared(IInteractionContext context) {
        this.modelUpdated();
    }

    private void modelUpdated() {
        try {
            for (IInteractionElement node : this.markerMap.keySet()) {
                this.landmarkRemoved(node);
            }
            this.markerMap.clear();
            for (IInteractionElement node : ContextCore.getContextManager().getActiveLandmarks()) {
                this.landmarkAdded(node);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update landmark markers", t));
        }
    }

    public void landmarkAdded(final IInteractionElement node) {
        if (node == null || node.getContentType() == null) {
            return;
        }
        if (node.getContentType().equals("java")) {
            IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element instanceof IMember) {
                try {
                    final ISourceRange range = ((IMember)element).getNameRange();
                    final IResource resource = element.getUnderlyingResource();
                    if (resource instanceof IFile) {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                IMarker marker = resource.createMarker(LandmarkMarkerManager.ID_MARKER_LANDMARK);
                                if (marker != null && range != null) {
                                    marker.setAttribute("charStart", range.getOffset());
                                    marker.setAttribute("charEnd", range.getOffset() + range.getLength());
                                    marker.setAttribute("message", (Object)"Mylyn Landmark");
                                    marker.setAttribute("severity", 0);
                                    LandmarkMarkerManager.this.markerMap.put(node, marker.getId());
                                }
                            }
                        };
                        resource.getWorkspace().run(runnable, null);
                    }
                }
                catch (JavaModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update marker", (Throwable)e));
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update marker", (Throwable)e));
                }
            }
        }
    }

    public void landmarkRemoved(final IInteractionElement node) {
        if (node == null) {
            return;
        }
        if (node.getContentType().equals("java")) {
            IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element.getAncestor(5) != null && element instanceof ISourceReference) {
                try {
                    final IResource resource = element.getUnderlyingResource();
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            if (resource != null) {
                                try {
                                    long id;
                                    IMarker marker;
                                    if (LandmarkMarkerManager.this.markerMap.containsKey(node) && (marker = resource.getMarker(id = ((Long)LandmarkMarkerManager.this.markerMap.get(node)).longValue())) != null) {
                                        marker.delete();
                                    }
                                }
                                catch (NullPointerException e) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update marker", (Throwable)e));
                                }
                            }
                        }
                    };
                    resource.getWorkspace().run(runnable, null);
                }
                catch (JavaModelException javaModelException) {
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not update landmark marker", (Throwable)e));
                }
            }
        }
    }
}

