/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.webapp.data.CssUtil;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterUtils;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class InjectionFilter
implements IFilter {
    private static final String cssLink1 = "\n<link rel=\"stylesheet\" href=\"";
    private static final String cssLink2 = "\" type=\"text/css\"></link>";
    private static final String disabledBook3 = "\n<script type=\"text/javascript\" src=\"";
    private static final String disabledBook4 = "livehelp.js\"> </script>";
    private final String TOPIC_CSS = "topic_css";
    private final String NAV_CSS = "nav_css";
    private final String NARROW_CSS = "narrow_css";
    private final String DISABLED_CSS = "disabled_css";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        boolean enabled;
        boolean isInfocenter = BaseHelpSystem.getMode() != 0;
        boolean addNarrow = false;
        boolean addDisabled = false;
        boolean needsLiveHelp = false;
        String uri = req.getRequestURI();
        boolean isNav = "/nav".equals(req.getServletPath());
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm") && !isNav) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return out;
        }
        ArrayList cssIncludes = new ArrayList();
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        if (isNav) {
            this.addCssFiles("nav_css", cssIncludes, prefs);
        } else {
            this.addCssFiles("topic_css", cssIncludes, prefs);
        }
        boolean bl = enabled = isInfocenter || isNav || HelpBasePlugin.getActivitySupport().isRoleEnabled(pathInfo);
        if ("/ntopic".equals(req.getServletPath())) {
            addNarrow = true;
            this.addCssFiles("narrow_css", cssIncludes, prefs);
        }
        if (!enabled) {
            addDisabled = true;
            this.addCssFiles("disabled_css", cssIncludes, prefs);
        }
        boolean bl2 = needsLiveHelp = !enabled && HelpBasePlugin.getActivitySupport().getDocumentMessageUsesLiveHelp(addNarrow);
        if (cssIncludes.size() == 0 && !addDisabled) {
            return out;
        }
        Path path = new Path(pathInfo);
        int upLevels = path.segmentCount() - 1;
        String relativePath = FilterUtils.getRelativePathPrefix(req);
        StringBuffer script = new StringBuffer();
        StringBuffer disabledContent = new StringBuffer();
        Iterator iter = cssIncludes.iterator();
        while (iter.hasNext()) {
            String cssPath = (String)iter.next();
            script.append(cssLink1);
            script.append("../content/PLUGINS_ROOT");
            script.append(cssPath);
            script.append(cssLink2);
        }
        if (addDisabled) {
            if (needsLiveHelp) {
                script.append(disabledBook3);
                script.append("../content/PLUGINS_ROOT/org.eclipse.help/");
                script.append(disabledBook4);
            }
            this.appendDisabled(disabledContent, upLevels, addNarrow, relativePath);
        }
        try {
            return new FilterHTMLHeadAndBodyOutputStream(out, script.toString().getBytes("ASCII"), addDisabled ? disabledContent.toString() : null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
    }

    private void addCssFiles(String preference, List list, Preferences prefs) {
        String topicCssPath = prefs.getString(preference);
        String[] cssFiles = CssUtil.getCssFilenames(topicCssPath);
        int i = 0;
        while (i < cssFiles.length) {
            list.add(cssFiles[i]);
            ++i;
        }
    }

    private void appendDisabled(StringBuffer buff, int nsteps, boolean narrow, String relativePath) {
        String message = HelpBasePlugin.getActivitySupport().getDocumentMessage(narrow);
        if (message == null) {
            return;
        }
        buff.append("<div id=\"help-disabledTopic\">");
        buff.append("<img src=\"");
        buff.append("../content/PLUGINS_ROOT/org.eclipse.help.webapp/");
        buff.append("advanced/images/e_show_all.gif\" border=\"0\" align=\"bottom\">&nbsp;");
        buff.append(message);
        buff.append("<br><hr></div>");
    }
}

