/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.ClauseOnlyLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.orders.UserFixedPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OPBStringSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.constraints.CompetPBMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxCBClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxDataStructure;
import org.sat4j.pb.constraints.PBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMinDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinDataStructure;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverCP;
import org.sat4j.pb.core.PBSolverClause;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.pb.core.PBSolverWithImpliedClause;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverFactory
extends ASolverFactory<IPBSolver>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static PBSolverResolution newPBResAllPB() {
        return SolverFactory.newPBRes(new PBMaxDataStructure());
    }

    public static PBSolverCP<ILits> newPBCPAllPB() {
        return SolverFactory.newPBCP(new PBMaxDataStructure());
    }

    public static IPBSolver newOPBStringSolver() {
        return new OPBStringSolver();
    }

    public static PBSolverCP<ILits> newPBCPMixedConstraints() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure());
    }

    public static PBSolverCP<ILits> newCompetPBCPMixedConstraints() {
        return SolverFactory.newPBCP(new CompetPBMaxClauseCardConstrDataStructure());
    }

    public static PBSolverCP<ILits> newPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
    }

    public static PBSolverCP<ILits> newCompetPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
    }

    public static PBSolverCP<ILits> newPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning clauseOnlyLearning = new ClauseOnlyLearning();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)clauseOnlyLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP<ILits> newCompetPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning clauseOnlyLearning = new ClauseOnlyLearning();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)clauseOnlyLearning, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    private static PBSolverCP<ILits> newPBKiller(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        ClauseOnlyLearning clauseOnlyLearning = new ClauseOnlyLearning();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)clauseOnlyLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective(iPhaseSelectionStrategy));
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP<ILits> newPBKillerRSAT() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP<ILits> newPBKillerClassic() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP<ILits> newPBKillerFixed() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    private static PBSolverCP<ILits> newCompetPBKiller(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        ClauseOnlyLearning clauseOnlyLearning = new ClauseOnlyLearning();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)clauseOnlyLearning, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective(iPhaseSelectionStrategy));
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP<ILits> newCompetPBKillerRSAT() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP<ILits> newCompetPBKillerClassic() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP<ILits> newCompetPBKillerFixed() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    public static PBSolverCP<ILits> newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncrementalReductionToClause() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverClause pBSolverClause = new PBSolverClause((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverClause);
        return pBSolverClause;
    }

    public static PBSolverCP<ILits> newCompetMiniLearningOPBClauseCardConstrMaxSpecificOrderIncrementalReductionToClause() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverClause pBSolverClause = new PBSolverClause((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverClause);
        return pBSolverClause;
    }

    public static PBSolverCP<ILits> newPBCPMixedConstraintsObjectiveNoLearning() {
        NoLearningButHeuristics noLearningButHeuristics = new NoLearningButHeuristics();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)noLearningButHeuristics, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
        noLearningButHeuristics.setSolver(pBSolverCP);
        noLearningButHeuristics.setVarActivityListener(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP<ILits> newCompetPBCPMixedConstraintsObjectiveNoLearning() {
        NoLearningButHeuristics noLearningButHeuristics = new NoLearningButHeuristics();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)noLearningButHeuristics, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective());
        noLearningButHeuristics.setSolver(pBSolverCP);
        noLearningButHeuristics.setVarActivityListener(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverResolution newPBResMixedConstraintsObjective() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjective() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResMixedConstraintsObjective();
        pBSolverResolution.setSimplifier(pBSolverResolution.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static PBSolverClause newPBCPMixedConstraintsReduceToClause() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverClause pBSolverClause = new PBSolverClause((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverClause);
        return pBSolverClause;
    }

    public static PBSolverClause newCompetPBCPMixedConstraintsReduceToClause() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverClause pBSolverClause = new PBSolverClause((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverClause);
        return pBSolverClause;
    }

    public static PBSolverWithImpliedClause newPBCPMixedConstrainsImplied() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverWithImpliedClause pBSolverWithImpliedClause = new PBSolverWithImpliedClause((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverWithImpliedClause.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverWithImpliedClause);
        return pBSolverWithImpliedClause;
    }

    public static PBSolverWithImpliedClause newCompetPBCPMixedConstrainsImplied() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverWithImpliedClause pBSolverWithImpliedClause = new PBSolverWithImpliedClause((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, new CompetPBMaxClauseCardConstrDataStructure(), (IOrder<ILits>)new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverWithImpliedClause.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverWithImpliedClause);
        return pBSolverWithImpliedClause;
    }

    public static PBSolverCP<ILits> newMiniOPBClauseAtLeastConstrMax() {
        return SolverFactory.newPBCP(new PBMaxClauseAtLeastConstrDataStructure());
    }

    public static PBSolverCP<ILits> newMiniOPBCounterBasedClauseCardConstrMax() {
        return SolverFactory.newPBCP(new PBMaxCBClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWL() {
        return SolverFactory.newPBRes(new PBMinDataStructure());
    }

    public static PBSolverCP<ILits> newPBCPAllPBWL() {
        return SolverFactory.newPBCP(new PBMinDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWLPueblo() {
        return SolverFactory.newPBRes(new PuebloPBMinDataStructure());
    }

    private static PBSolverResolution newPBRes(PBDataStructureFactory<ILits> pBDataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, pBDataStructureFactory, (IOrder<ILits>)new VarOrderHeap(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverCP<ILits> newPBCPAllPBWLPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinDataStructure());
    }

    public static PBSolverCP<ILits> newMiniOPBClauseCardMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP<ILits> newMiniOPBClauseCardMin() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP<ILits> newMiniOPBClauseAtLeastMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseAtLeastConstrDataStructure());
    }

    private static PBSolverCP<ILits> newPBCP(PBDataStructureFactory<ILits> pBDataStructureFactory, IOrder<ILits> iOrder) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverCP<ILits> pBSolverCP = new PBSolverCP<ILits>((AssertingClauseGenerator)new FirstUIP(), (LearningStrategy<ILits, PBDataStructureFactory<ILits>>)miniSATLearning, pBDataStructureFactory, iOrder);
        miniSATLearning.setDataStructureFactory(pBSolverCP.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverCP);
        return pBSolverCP;
    }

    private static PBSolverCP<ILits> newPBCP(PBDataStructureFactory<ILits> pBDataStructureFactory) {
        return SolverFactory.newPBCP(pBDataStructureFactory, (IOrder<ILits>)new VarOrderHeap());
    }

    public static IPBSolver newDefault() {
        return SolverFactory.newCompetPBCPMixedConstraintsObjective();
    }

    public IPBSolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static IPBSolver newLight() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp();
    }

    public IPBSolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }

    public static IPBSolver newEclipseP2() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResMixedConstraintsObjective();
        pBSolverResolution.setTimeoutOnConflicts(300);
        return new OptToPBSATAdapter(new PseudoOptDecorator(pBSolverResolution));
    }

    public /* synthetic */ ISolver lightSolver() {
        return this.lightSolver();
    }

    public /* synthetic */ ISolver defaultSolver() {
        return this.defaultSolver();
    }
}

