/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxMultiBugReportContentHandler
extends DefaultHandler {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String COMMENT_ATTACHMENT_STRING = "Created an attachment (id=";
    private StringBuffer characters;
    private TaskComment taskComment;
    private Map<String, TaskCommentMapper> attachIdToComment = new HashMap<String, TaskCommentMapper>();
    private int commentNum = 0;
    private TaskAttachmentMapper attachment;
    private final Map<String, TaskData> taskDataMap;
    private TaskData repositoryTaskData;
    private List<TaskComment> longDescs;
    private String errorMessage = null;
    private final List<BugzillaCustomField> customFields;
    private final TaskDataCollector collector;
    private boolean isDeprecated = false;
    private boolean isPatch = false;
    private TaskAttribute attachmentAttribute;

    public SaxMultiBugReportContentHandler(TaskAttributeMapper mapper, TaskDataCollector collector, Map<String, TaskData> taskDataMap, List<BugzillaCustomField> customFields) {
        this.taskDataMap = taskDataMap;
        this.customFields = customFields;
        this.collector = collector;
    }

    public boolean errorOccurred() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
        BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
        if (localName.startsWith("cf_")) {
            return;
        }
        try {
            tag = BugzillaAttribute.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
        switch (tag) {
            case BUGZILLA: {
                break;
            }
            case BUG: {
                if (attributes != null && attributes.getValue("error") != null) {
                    this.errorMessage = attributes.getValue("error");
                }
                this.attachIdToComment = new HashMap<String, TaskCommentMapper>();
                this.commentNum = 0;
                this.taskComment = null;
                this.longDescs = new ArrayList<TaskComment>();
                break;
            }
            case LONG_DESC: {
                this.taskComment = new TaskComment(this.commentNum++);
                break;
            }
            case WHO: {
                String name;
                if (this.taskComment == null || attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                this.taskComment.authorName = name;
                break;
            }
            case REPORTER: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.REPORTER_NAME).setValue(name);
                break;
            }
            case QA_CONTACT: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.QA_CONTACT_NAME).setValue(name);
                break;
            }
            case ASSIGNED_TO: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.ASSIGNED_TO_NAME).setValue(name);
                break;
            }
            case ATTACHMENT: {
                if (attributes == null) break;
                this.isDeprecated = "1".equals(attributes.getValue(BugzillaAttribute.IS_OBSOLETE.getKey()));
                this.isPatch = "1".equals(attributes.getValue(BugzillaAttribute.IS_PATCH.getKey()));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String parsedText = this.characters.toString();
        if (localName.startsWith("cf_")) {
            TaskAttribute endAttribute = this.repositoryTaskData.getRoot().getAttribute(localName);
            if (endAttribute == null) {
                String desc = "???";
                BugzillaCustomField customField = null;
                for (BugzillaCustomField bugzillaCustomField : this.customFields) {
                    if (!localName.equals(bugzillaCustomField.getName())) continue;
                    customField = bugzillaCustomField;
                    break;
                }
                if (customField != null) {
                    TaskAttribute atr = this.repositoryTaskData.getRoot().createAttribute(localName);
                    desc = customField.getDescription();
                    atr.getMetaData().defaults().setLabel(desc).setReadOnly(false);
                    atr.getMetaData().setKind("task.common.kind.default");
                    atr.getMetaData().setType("shortText");
                    atr.getMetaData().setReadOnly(true);
                    atr.setValue(parsedText);
                }
            } else {
                endAttribute.addValue(parsedText);
            }
        }
        BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
        try {
            tag = BugzillaAttribute.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
        switch (tag) {
            case BUG_ID: {
                TaskAttribute attr;
                try {
                    this.repositoryTaskData = this.taskDataMap.get(parsedText.trim());
                    if (this.repositoryTaskData == null) {
                        this.errorMessage = String.valueOf(parsedText) + " id not found.";
                    }
                }
                catch (Exception exception) {
                    this.errorMessage = "Bug id from server did not match requested id.";
                }
                if ((attr = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey())) == null) {
                    attr = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag);
                }
                attr.setValue(parsedText);
                break;
            }
            case WHO: {
                if (this.taskComment == null) break;
                this.taskComment.author = parsedText;
                break;
            }
            case BUG_WHEN: {
                if (this.taskComment == null) break;
                this.taskComment.createdTimeStamp = parsedText;
                break;
            }
            case THETEXT: {
                if (this.taskComment == null) break;
                this.taskComment.commentText = parsedText;
                break;
            }
            case LONG_DESC: {
                if (this.taskComment == null) break;
                this.longDescs.add(this.taskComment);
                break;
            }
            case ATTACHID: {
                this.attachmentAttribute = this.repositoryTaskData.getRoot().createAttribute("task.common.attachment-" + parsedText);
                this.attachment = TaskAttachmentMapper.createFrom((TaskAttribute)this.attachmentAttribute);
                this.attachment.setLength(new Long(-1L));
                this.attachment.setAttachmentId(parsedText);
                this.attachment.setPatch(Boolean.valueOf(this.isPatch));
                this.attachment.setDeprecated(Boolean.valueOf(this.isDeprecated));
                break;
            }
            case DATE: {
                break;
            }
            case DESC: {
                if (this.attachment == null) break;
                this.attachment.setDescription(parsedText);
                break;
            }
            case FILENAME: {
                if (this.attachment == null) break;
                this.attachment.setFileName(parsedText);
                break;
            }
            case CTYPE: 
            case TYPE: {
                if (this.attachment == null) break;
                this.attachment.setContentType(parsedText);
                break;
            }
            case SIZE: {
                if (this.attachment == null) break;
                try {
                    if (parsedText == null) break;
                    this.attachment.setLength(Long.valueOf(Long.parseLong(parsedText)));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case ATTACHMENT: {
                if (this.attachment != null) {
                    this.attachment.applyTo(this.attachmentAttribute);
                }
                this.isPatch = false;
                this.isDeprecated = false;
                this.attachment = null;
                this.attachmentAttribute = null;
                break;
            }
            case DATA: {
                break;
            }
            case BUGZILLA: {
                break;
            }
            case BUG: {
                this.addDescriptionAndComments();
                TaskAttribute numCommentsAttribute = this.repositoryTaskData.getRoot().getMappedAttribute(BugzillaAttribute.LONGDESCLENGTH.getKey());
                if (numCommentsAttribute == null) {
                    numCommentsAttribute = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.LONGDESCLENGTH);
                }
                numCommentsAttribute.setValue("" + this.commentNum);
                this.updateAttachmentMetaData();
                TaskAttribute attrCreation = this.repositoryTaskData.getRoot().getAttribute(BugzillaAttribute.CREATION_TS.getKey());
                this.updateCustomFields(this.repositoryTaskData);
                if (attrCreation == null || attrCreation.equals((Object)"")) break;
                this.collector.accept(this.repositoryTaskData);
                break;
            }
            case BLOCKED: 
            case DEPENDSON: {
                TaskAttribute blockOrDepends = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
                if (blockOrDepends == null) {
                    BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag).setValue(parsedText);
                    break;
                }
                if (blockOrDepends.getValue().equals("")) {
                    blockOrDepends.setValue(parsedText);
                    break;
                }
                blockOrDepends.setValue(String.valueOf(blockOrDepends.getValue()) + ", " + parsedText);
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                TaskAttribute defaultAttribute = this.repositoryTaskData.getRoot().getMappedAttribute(tag.getKey());
                if (defaultAttribute == null) {
                    defaultAttribute = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, tag);
                    defaultAttribute.setValue(parsedText);
                    break;
                }
                defaultAttribute.addValue(parsedText);
            }
        }
    }

    private void updateCustomFields(TaskData taskData) {
        RepositoryConfiguration config = BugzillaCorePlugin.getRepositoryConfiguration(this.repositoryTaskData.getRepositoryUrl());
        if (config != null) {
            for (BugzillaCustomField bugzillaCustomField : config.getCustomFields()) {
                TaskAttribute atr = taskData.getRoot().getAttribute(bugzillaCustomField.getName());
                if (atr == null) {
                    atr = taskData.getRoot().createAttribute(bugzillaCustomField.getName());
                }
                if (atr == null) continue;
                atr.getMetaData().defaults().setLabel(bugzillaCustomField.getDescription());
                atr.getMetaData().setKind("task.common.kind.default");
                List<String> options = bugzillaCustomField.getOptions();
                if (options.size() > 0) {
                    atr.getMetaData().setType("singleSelect");
                } else {
                    atr.getMetaData().setType("shortText");
                }
                atr.getMetaData().setReadOnly(false);
            }
        }
    }

    private void updateAttachmentMetaData() {
        List taskAttachments = this.repositoryTaskData.getAttributeMapper().getAttributesByType(this.repositoryTaskData, "attachment");
        for (TaskAttribute attachment : taskAttachments) {
            TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachment);
            TaskCommentMapper taskComment = this.attachIdToComment.get(attachmentMapper.getAttachmentId());
            if (taskComment != null) {
                attachmentMapper.setAuthor(taskComment.getAuthor());
                attachmentMapper.setCreationDate(taskComment.getCreationDate());
            }
            attachmentMapper.setUrl(String.valueOf(this.repositoryTaskData.getRepositoryUrl()) + "/attachment.cgi?id=" + attachmentMapper.getAttachmentId());
            attachmentMapper.applyTo(attachment);
        }
    }

    private void addDescriptionAndComments() {
        block13: {
            int longDescsSize;
            block14: {
                block12: {
                    longDescsSize = this.longDescs.size() - 1;
                    this.commentNum = 1;
                    if (longDescsSize != 0) break block12;
                    this.addDescription(this.longDescs.get((int)0).commentText);
                    break block13;
                }
                if (longDescsSize != 1) break block14;
                if (this.longDescs.get((int)0).createdTimeStamp.compareTo(this.longDescs.get((int)1).createdTimeStamp) <= 0) {
                    this.addDescription(this.longDescs.get((int)0).commentText);
                    this.addComment(this.longDescs.get(1));
                } else {
                    this.addDescription(this.longDescs.get((int)1).commentText);
                    this.addComment(this.longDescs.get(0));
                }
                break block13;
            }
            if (longDescsSize <= 1) break block13;
            String created_0 = this.longDescs.get((int)0).createdTimeStamp;
            String created_1 = this.longDescs.get((int)1).createdTimeStamp;
            String created_n = this.longDescs.get((int)longDescsSize).createdTimeStamp;
            if (created_0.compareTo(created_1) <= 0 && created_0.compareTo(created_n) < 0) {
                this.addDescription(this.longDescs.get((int)0).commentText);
                if (created_1.compareTo(created_n) < 0) {
                    int i = 1;
                    while (i <= longDescsSize) {
                        this.addComment(this.longDescs.get(i));
                        ++i;
                    }
                } else {
                    int i = longDescsSize;
                    while (i > 0) {
                        this.addComment(this.longDescs.get(i));
                        --i;
                    }
                }
            } else {
                this.addDescription(this.longDescs.get((int)longDescsSize).commentText);
                if (created_0.compareTo(created_1) < 0) {
                    int i = 0;
                    while (i < longDescsSize) {
                        this.addComment(this.longDescs.get(i));
                        ++i;
                    }
                } else {
                    int i = longDescsSize - 1;
                    while (i >= 0) {
                        this.addComment(this.longDescs.get(i));
                        --i;
                    }
                }
            }
        }
    }

    private void addDescription(String commentText) {
        TaskAttribute attrDescription = BugzillaTaskDataHandler.createAttribute(this.repositoryTaskData, BugzillaAttribute.LONG_DESC);
        attrDescription.setValue(commentText);
    }

    private void addComment(TaskComment comment) {
        TaskAttribute attribute = this.repositoryTaskData.getRoot().createAttribute("task.common.comment-" + this.commentNum);
        TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
        taskComment.setCommentId(String.valueOf(this.commentNum));
        taskComment.setNumber(Integer.valueOf(this.commentNum));
        IRepositoryPerson author = this.repositoryTaskData.getAttributeMapper().getTaskRepository().createPerson(comment.author);
        author.setName(comment.authorName);
        taskComment.setAuthor(author);
        TaskAttribute attrTimestamp = attribute.createAttribute(BugzillaAttribute.BUG_WHEN.getKey());
        attrTimestamp.setValue(comment.createdTimeStamp);
        taskComment.setCreationDate(this.repositoryTaskData.getAttributeMapper().getDateValue(attrTimestamp));
        if (comment.commentText != null) {
            String commentText = comment.commentText.trim();
            taskComment.setText(commentText);
        }
        taskComment.applyTo(attribute);
        ++this.commentNum;
        this.parseAttachment(taskComment);
    }

    private void parseAttachment(TaskCommentMapper comment) {
        int endIndex;
        String attachmentID = "";
        String commentText = comment.getText();
        if (commentText.startsWith(COMMENT_ATTACHMENT_STRING) && (endIndex = commentText.indexOf(")")) > 0 && endIndex < commentText.length() && !(attachmentID = commentText.substring(COMMENT_ATTACHMENT_STRING.length(), endIndex)).equals("")) {
            this.attachIdToComment.put(attachmentID, comment);
        }
    }

    private static class TaskComment {
        public int number;
        public String author;
        public String authorName;
        public String createdTimeStamp;
        public String commentText;
        public boolean hasAttachment;
        public String attachmentId;

        public TaskComment(int num) {
            this.number = num;
        }
    }
}

