/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.Locale;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxBugzillaQueryContentHandler
extends DefaultHandler {
    private StringBuffer characters;
    private final TaskDataCollector collector;
    private final String repositoryUrl;
    private int resultCount;
    private final TaskAttributeMapper mapper;
    private TaskData taskData;

    public SaxBugzillaQueryContentHandler(String repositoryUrl, TaskDataCollector collector, TaskAttributeMapper mapper) {
        this.repositoryUrl = repositoryUrl;
        this.collector = collector;
        this.mapper = mapper;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String parsedText = this.characters.toString();
        BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
        try {
            tag = BugzillaAttribute.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
            switch (tag) {
                case ID: {
                    this.taskData = new TaskData(this.mapper, "bugzilla", this.repositoryUrl, parsedText);
                    this.taskData.setPartial(true);
                    break;
                }
                case SHORT_SHORT_DESC: {
                    if (this.taskData != null) {
                        BugzillaTaskDataHandler.createAttribute(this.taskData, BugzillaAttribute.SHORT_DESC).setValue(parsedText);
                    }
                    break;
                }
                case LI: {
                    if (this.taskData != null) {
                        this.collector.accept(this.taskData);
                    }
                    ++this.resultCount;
                    break;
                }
                default: {
                    if (this.taskData != null) {
                        BugzillaTaskDataHandler.createAttribute(this.taskData, tag).setValue(parsedText);
                    }
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
    }

    public int getResultCount() {
        return this.resultCount;
    }
}

