/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaTaskDataHandler
extends AbstractTaskDataHandler {
    private final BugzillaRepositoryConnector connector;

    public BugzillaTaskDataHandler(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        try {
            BugzillaClient client = this.connector.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
            int bugId = BugzillaRepositoryConnector.getBugId(taskId);
            TaskData taskData = client.getTaskData(bugId, this.getAttributeMapper(repository), monitor);
            if (taskData == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Task data could not be retrieved. Please re-synchronize task"));
            }
            return taskData;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getRepositoryUrl(), e));
        }
    }

    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("Receiving tasks", taskIds.size());
                BugzillaClient client = this.connector.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                client.getTaskData(taskIds, collector, this.getAttributeMapper(repository), monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getRepositoryUrl(), e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        float bugzillaTaskDataVersion = 0.0f;
        String taskDataVersion = taskData.getVersion();
        if (taskDataVersion != null) {
            try {
                bugzillaTaskDataVersion = Float.parseFloat(taskDataVersion);
            }
            catch (NumberFormatException numberFormatException) {
                bugzillaTaskDataVersion = 0.0f;
            }
        }
        TaskDataVersion[] taskDataVersionArray = TaskDataVersion.values();
        int n = taskDataVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskDataVersion version = taskDataVersionArray[n2];
            if (bugzillaTaskDataVersion <= version.getVersionNum()) {
                version.migrate(taskRepository, taskData);
            }
            ++n2;
        }
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> changedAttributes, IProgressMonitor monitor) throws CoreException {
        try {
            BugzillaClient client = this.connector.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
            try {
                return client.postTaskData(taskData, monitor);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 3) {
                    return client.postTaskData(taskData, monitor);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getRepositoryUrl(), e));
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        if (initializationData == null) {
            return false;
        }
        String product = initializationData.getProduct();
        if (product == null) {
            return false;
        }
        return this.initializeTaskData(repository, data, product, monitor);
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, String product, IProgressMonitor monitor) throws CoreException {
        data.setVersion(TaskDataVersion.VERSION_CURRENT.toString());
        RepositoryConfiguration repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration(repository, false, monitor);
        TaskAttribute productAttribute = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.PRODUCT);
        productAttribute.setValue(product);
        List<String> optionValues = repositoryConfiguration.getProducts();
        Collections.sort(optionValues);
        for (String optionValue : optionValues) {
            productAttribute.putOption(optionValue, optionValue);
        }
        TaskAttribute attributeStatus = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.BUG_STATUS);
        optionValues = repositoryConfiguration.getStatusValues();
        for (String option : optionValues) {
            attributeStatus.putOption(option, option);
        }
        attributeStatus.setValue("NEW");
        BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.SHORT_DESC);
        TaskAttribute attributeVersion = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.VERSION);
        optionValues = repositoryConfiguration.getVersions(productAttribute.getValue());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            attributeVersion.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributeVersion.setValue(optionValues.get(optionValues.size() - 1));
        }
        TaskAttribute attributeComponent = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.COMPONENT);
        optionValues = repositoryConfiguration.getComponents(productAttribute.getValue());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            attributeComponent.putOption(option, option);
        }
        if (optionValues.size() == 1) {
            attributeComponent.setValue(optionValues.get(0));
        }
        TaskAttribute attributePlatform = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.REP_PLATFORM);
        optionValues = repositoryConfiguration.getPlatforms();
        for (String option : optionValues) {
            attributePlatform.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributePlatform.setValue(optionValues.get(0));
        }
        TaskAttribute attributeOPSYS = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.OP_SYS);
        optionValues = repositoryConfiguration.getOSs();
        for (String option : optionValues) {
            attributeOPSYS.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributeOPSYS.setValue(optionValues.get(0));
        }
        TaskAttribute attributePriority = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.PRIORITY);
        optionValues = repositoryConfiguration.getPriorities();
        for (String option : optionValues) {
            attributePriority.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributePriority.setValue(optionValues.get(optionValues.size() / 2));
        }
        TaskAttribute attributeSeverity = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.BUG_SEVERITY);
        optionValues = repositoryConfiguration.getSeverities();
        for (String option : optionValues) {
            attributeSeverity.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributeSeverity.setValue(optionValues.get(optionValues.size() / 2));
        }
        TaskAttribute attributeAssignedTo = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.ASSIGNED_TO);
        attributeAssignedTo.setValue("");
        TaskAttribute attributeBugFileLoc = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.BUG_FILE_LOC);
        attributeBugFileLoc.setValue("http://");
        BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.DEPENDSON);
        BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.BLOCKED);
        BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.NEWCC);
        BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.LONG_DESC);
        if (data.isNew()) {
            TaskAttribute attrAddSelfToCc;
            TaskAttribute attrOwner;
            TaskAttribute attrDescription = data.getRoot().getMappedAttribute("task.common.description");
            if (attrDescription != null) {
                attrDescription.getMetaData().setReadOnly(false);
            }
            if ((attrOwner = data.getRoot().getMappedAttribute("task.common.user.assigned")) != null) {
                attrOwner.getMetaData().setReadOnly(false);
            }
            if ((attrAddSelfToCc = data.getRoot().getMappedAttribute("task.common.addselfcc")) != null) {
                attrAddSelfToCc.getMetaData().setKind(null);
            }
        }
        return true;
    }

    public static TaskAttribute createAttribute(TaskData data, BugzillaAttribute key) {
        return BugzillaTaskDataHandler.createAttribute(data.getRoot(), key);
    }

    public static TaskAttribute createAttribute(TaskAttribute parent, BugzillaAttribute key) {
        TaskAttribute attribute = parent.createAttribute(key.getKey());
        attribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.toString()).setType(key.getType());
        return attribute;
    }

    public boolean canGetMultiTaskData(TaskRepository taskRepository) {
        return true;
    }

    public boolean canInitializeSubTaskData(TaskRepository taskRepository, ITask task) {
        return true;
    }

    public boolean initializeSubTaskData(TaskRepository repository, TaskData subTaskData, TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        TaskAttribute attributeProject = parentTaskData.getRoot().getMappedAttribute("task.common.product");
        String product = attributeProject.getValue();
        this.initializeTaskData(repository, subTaskData, product, monitor);
        new TaskMapper(subTaskData).merge((ITaskMapping)new TaskMapper(parentTaskData));
        subTaskData.getRoot().getMappedAttribute("task.common.description").setValue("");
        subTaskData.getRoot().getMappedAttribute("task.common.summary").setValue("");
        subTaskData.getRoot().getAttribute(BugzillaAttribute.BLOCKED.getKey()).setValue(parentTaskData.getTaskId());
        TaskAttribute parentAttributeAssigned = parentTaskData.getRoot().getMappedAttribute("task.common.user.assigned");
        subTaskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).setValue(parentAttributeAssigned.getValue());
        return true;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        return new BugzillaAttributeMapper(taskRepository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaskDataVersion {
        VERSION_0(0.0f){

            void migrate(TaskRepository repository, TaskData data) {
            }
        }
        ,
        VERSION_1_0(1.0f){

            void migrate(TaskRepository repository, TaskData data) {
                for (TaskAttribute attribute : new ArrayList(data.getRoot().getAttributes().values())) {
                    if (!attribute.getId().equals(BugzillaAttribute.DESC.getKey())) continue;
                    TaskAttribute attrLongDesc = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.LONG_DESC);
                    attrLongDesc.setValue(attribute.getValue());
                    data.getRoot().removeAttribute(BugzillaAttribute.DESC.getKey());
                }
                HashSet<TaskAttribute> operationsToRemove = new HashSet<TaskAttribute>();
                for (TaskAttribute attribute : data.getAttributeMapper().getAttributesByType(data, "operation")) {
                    operationsToRemove.add(attribute);
                }
                for (TaskAttribute taskAttribute : operationsToRemove) {
                    data.getRoot().removeAttribute(taskAttribute.getId());
                }
                RepositoryConfiguration configuration = BugzillaCorePlugin.getRepositoryConfiguration(repository.getRepositoryUrl());
                if (configuration != null) {
                    configuration.addValidOperations(data);
                }
            }
        }
        ,
        VERSION_2_0(2.0f){

            void migrate(TaskRepository repository, TaskData data) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.LONG_DESC);
            }
        }
        ,
        VERSION_3_0(3.0f){

            void migrate(TaskRepository repository, TaskData data) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.NEW_COMMENT);
            }
        }
        ,
        VERSION_4_0(4.0f){

            void migrate(TaskRepository repository, TaskData data) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.DEADLINE);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.ACTUAL_TIME);
            }
        }
        ,
        VERSION_4_1(4.1f){

            void migrate(TaskRepository repository, TaskData data) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.VOTES);
                TaskAttribute attrDeadline = data.getRoot().getMappedAttribute(BugzillaAttribute.VOTES.getKey());
                if (attrDeadline != null) {
                    attrDeadline.getMetaData().setType(BugzillaAttribute.VOTES.getType());
                }
            }
        }
        ,
        VERSION_4_2(4.2f){

            void migrate(TaskRepository repository, TaskData data) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.CC);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.DEPENDSON);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.BLOCKED);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.BUG_FILE_LOC);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.KEYWORDS);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.STATUS_WHITEBOARD);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.QA_CONTACT);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.NEWCC);
            }
        }
        ,
        VERSION_4_3(4.3f){

            void migrate(TaskRepository repository, TaskData data) {
                for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
                    if (!attribute.getId().startsWith("cf_")) continue;
                    attribute.getMetaData().setKind("task.common.kind.default");
                    attribute.getMetaData().setReadOnly(false);
                    if (attribute.getOptions().size() > 0) {
                        attribute.getMetaData().setType("singleSelect");
                        continue;
                    }
                    attribute.getMetaData().setType("shortText");
                }
            }
        }
        ,
        VERSION_CURRENT(4.4f){

            void migrate(TaskRepository repository, TaskData data) {
                data.setVersion(VERSION_CURRENT.toString());
            }
        };

        private float versionNumber = 0.0f;

        private TaskDataVersion(float verNum) {
            this.versionNumber = verNum;
        }

        public float getVersionNum() {
            return this.versionNumber;
        }

        abstract void migrate(TaskRepository var1, TaskData var2);

        public String toString() {
            return "" + this.getVersionNum();
        }

        private static void updateAttribute(TaskData data, BugzillaAttribute bugAttribute) {
            TaskAttribute attribute = data.getRoot().getMappedAttribute(bugAttribute.getKey());
            if (attribute != null) {
                attribute.getMetaData().setType(bugAttribute.getType());
                attribute.getMetaData().setReadOnly(bugAttribute.isReadOnly());
                attribute.getMetaData().setKind(bugAttribute.getKind());
            }
        }
    }
}

