/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class BugzillaTaskAttachmentHandler
extends AbstractTaskAttachmentHandler {
    private final BugzillaRepositoryConnector connector;

    public BugzillaTaskAttachmentHandler(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public boolean canGetContent(TaskRepository repository, ITask task) {
        return true;
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return true;
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Getting attachment", -1);
            TaskAttachmentMapper attachment = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.downloadAttachment(repository, task, attachment.getAttachmentId(), out, monitor);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            monitor.done();
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("Sending attachment", -1);
                BugzillaClient client = this.connector.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                String description = source.getDescription();
                String contentType = source.getContentType();
                String filename = source.getName();
                boolean isPatch = false;
                if (attachmentAttribute != null) {
                    TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
                    if (mapper.getDescription() != null) {
                        description = mapper.getDescription();
                    }
                    if (mapper.getContentType() != null) {
                        contentType = mapper.getContentType();
                    }
                    if (mapper.getFileName() != null) {
                        filename = mapper.getFileName();
                    }
                    if (mapper.isPatch() != null) {
                        isPatch = mapper.isPatch();
                    }
                }
                if (description == null) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "A description is required when submitting attachments."));
                }
                client.postAttachment(task.getTaskId(), comment, description, contentType, isPatch, new AttachmentPartSource(source, filename), monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to submit attachment", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void downloadAttachment(TaskRepository repository, ITask task, String attachmentId, OutputStream out, IProgressMonitor monitor) throws CoreException {
        try {
            BugzillaClient client = this.connector.getClientManager().getClient(repository, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
            client.getAttachmentData(attachmentId, out, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to retrieve attachment", (Throwable)e));
        }
    }

    public static class AttachmentPartSource
    implements PartSource {
        private final AbstractTaskAttachmentSource attachment;
        private final String filename;

        public AttachmentPartSource(AbstractTaskAttachmentSource attachment, String filename) {
            this.attachment = attachment;
            this.filename = filename;
        }

        public AttachmentPartSource(AbstractTaskAttachmentSource attachment) {
            this(attachment, attachment.getName());
        }

        public InputStream createInputStream() throws IOException {
            try {
                return this.attachment.createInputStream(null);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error submitting attachment", (Throwable)e));
                throw new IOException("Failed to create source stream");
            }
        }

        public String getFileName() {
            return this.filename;
        }

        public long getLength() {
            return this.attachment.getLength();
        }
    }
}

