/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaAttributeMapper
extends TaskAttributeMapper {
    private static final String DATE_FORMAT_1 = "yyyy-MM-dd HH:mm";
    private static final String DATE_FORMAT_2 = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT_3 = "yyyy-MM-dd";
    private static final String delta_ts_format = "yyyy-MM-dd HH:mm:ss";
    private static final String creation_ts_format = "yyyy-MM-dd HH:mm";
    private static final String deadline_format = "yyyy-MM-dd";
    public static final String comment_creation_ts_format = "yyyy-MM-dd HH:mm";
    private static final String attachment_creation_ts_format = "yyyy-MM-dd HH:mm";

    public BugzillaAttributeMapper(TaskRepository taskRepository) {
        super(taskRepository);
    }

    public Date getDateValue(TaskAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        String dateString = attribute.getValue();
        String id = attribute.getId();
        Date parsedDate = this.getDate(id, dateString);
        if (parsedDate == null) {
            parsedDate = super.getDateValue(attribute);
        }
        return parsedDate;
    }

    public boolean getBooleanValue(TaskAttribute attribute) {
        return attribute.getValue().equals("1");
    }

    public void setBooleanValue(TaskAttribute attribute, Boolean value) {
        if (value == null) {
            attribute.setValue("0");
        } else if (value.booleanValue()) {
            attribute.setValue("1");
        } else {
            attribute.setValue("0");
        }
    }

    private Date getDate(String attributeId, String dateString) {
        Date parsedDate = null;
        try {
            if (attributeId.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.CREATION_TS.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.BUG_WHEN.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.DATE.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
            } else if (attributeId.equals(BugzillaAttribute.DEADLINE.getKey())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
            }
        }
        catch (ParseException parseException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return parsedDate;
    }

    public void setDateValue(TaskAttribute attribute, Date date) {
        if (date != null) {
            String dateString = null;
            String attributeId = attribute.getId();
            if (attributeId.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            } else if (attributeId.equals(BugzillaAttribute.CREATION_TS.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            } else if (attributeId.equals(BugzillaAttribute.BUG_WHEN.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            } else if (attributeId.equals(BugzillaAttribute.DATE.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            } else if (attributeId.equals(BugzillaAttribute.DEADLINE.getKey())) {
                dateString = new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
            if (dateString == null) {
                super.setDateValue(attribute, date);
            } else {
                attribute.setValue(dateString);
            }
        } else {
            attribute.clearValues();
        }
    }

    public String mapToRepositoryKey(TaskAttribute parent, String key) {
        if (key.equals("task.common.comment.date")) {
            return BugzillaAttribute.BUG_WHEN.getKey();
        }
        if (key.equals("task.common.comment.author")) {
            return BugzillaAttribute.WHO.getKey();
        }
        if (key.equals("task.common.comment.author.name")) {
            return BugzillaAttribute.WHO_NAME.getKey();
        }
        if (key.equals("task.common.user.cc")) {
            return BugzillaAttribute.CC.getKey();
        }
        if (key.equals("task.common.comment.text")) {
            return BugzillaAttribute.THETEXT.getKey();
        }
        if (key.equals("task.common.date.created")) {
            return BugzillaAttribute.CREATION_TS.getKey();
        }
        if (key.equals("task.common.description")) {
            return BugzillaAttribute.LONG_DESC.getKey();
        }
        if (key.equals("task.common.attachment.id")) {
            return BugzillaAttribute.ATTACHID.getKey();
        }
        if (key.equals("task.common.attachment.description")) {
            return BugzillaAttribute.DESC.getKey();
        }
        if (key.equals("task.common.attachment.ctype")) {
            return BugzillaAttribute.CTYPE.getKey();
        }
        if (key.equals("task.common.user.assigned")) {
            return BugzillaAttribute.ASSIGNED_TO.getKey();
        }
        if (key.equals("task.common.user.assigned.name")) {
            return BugzillaAttribute.ASSIGNED_TO_NAME.getKey();
        }
        if (key.equals("task.common.resolution")) {
            return BugzillaAttribute.RESOLUTION.getKey();
        }
        if (key.equals("task.common.status")) {
            return BugzillaAttribute.BUG_STATUS.getKey();
        }
        if (key.equals("task.common.date.modified")) {
            return BugzillaAttribute.DELTA_TS.getKey();
        }
        if (key.equals("task.common.user.reporter")) {
            return BugzillaAttribute.REPORTER.getKey();
        }
        if (key.equals("task.common.user.reporter.name")) {
            return BugzillaAttribute.REPORTER_NAME.getKey();
        }
        if (key.equals("task.common.summary")) {
            return BugzillaAttribute.SHORT_DESC.getKey();
        }
        if (key.equals("task.common.product")) {
            return BugzillaAttribute.PRODUCT.getKey();
        }
        if (key.equals("task.common.keywords")) {
            return BugzillaAttribute.KEYWORDS.getKey();
        }
        if (key.equals("task.common.attachment.date")) {
            return BugzillaAttribute.DATE.getKey();
        }
        if (key.equals("task.common.attachment.size")) {
            return BugzillaAttribute.SIZE.getKey();
        }
        if (key.equals("task.common.addselfcc")) {
            return BugzillaAttribute.ADDSELFCC.getKey();
        }
        if (key.equals("task.common.priority")) {
            return BugzillaAttribute.PRIORITY.getKey();
        }
        if (key.equals("task.common.comment.new")) {
            return BugzillaAttribute.NEW_COMMENT.getKey();
        }
        if (key.equals("task.common.component")) {
            return BugzillaAttribute.COMPONENT.getKey();
        }
        if (key.equals("task.common.key")) {
            return BugzillaAttribute.BUG_ID.getKey();
        }
        return super.mapToRepositoryKey(parent, key);
    }

    public TaskAttribute getAssoctiatedAttribute(TaskAttribute taskAttribute) {
        String id = taskAttribute.getMetaData().getValue("task.meta.associated.attribute");
        if (id != null) {
            if ("operation".equals(taskAttribute.getMetaData().getType())) {
                return taskAttribute.getTaskData().getRoot().getMappedAttribute(id);
            }
            return taskAttribute.getMappedAttribute(id);
        }
        return null;
    }

    public IRepositoryPerson getRepositoryPerson(TaskAttribute taskAttribute) {
        IRepositoryPerson person = super.getRepositoryPerson(taskAttribute);
        if (person.getName() == null) {
            TaskAttribute attrReporter;
            if (taskAttribute.getId().equals(BugzillaAttribute.ASSIGNED_TO.getKey())) {
                TaskAttribute attrAssigned = taskAttribute.getTaskData().getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO_NAME.getKey());
                if (attrAssigned != null) {
                    person.setName(attrAssigned.getValue());
                }
            } else if (taskAttribute.getId().equals(BugzillaAttribute.REPORTER.getKey())) {
                TaskAttribute attrReporter2 = taskAttribute.getTaskData().getRoot().getAttribute(BugzillaAttribute.REPORTER_NAME.getKey());
                if (attrReporter2 != null) {
                    person.setName(attrReporter2.getValue());
                }
            } else if (taskAttribute.getId().equals(BugzillaAttribute.QA_CONTACT.getKey()) && (attrReporter = taskAttribute.getTaskData().getRoot().getAttribute(BugzillaAttribute.QA_CONTACT_NAME.getKey())) != null) {
                person.setName(attrReporter.getValue());
            }
        }
        return person;
    }

    public Map<String, String> getOptions(TaskAttribute attribute) {
        TaskAttribute attributeProduct;
        RepositoryConfiguration configuration = BugzillaCorePlugin.getRepositoryConfiguration(this.getTaskRepository().getRepositoryUrl());
        if (configuration != null && (attributeProduct = attribute.getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey())) != null && attributeProduct.getValue().length() > 0) {
            List<String> options = configuration.getAttributeOptions(attributeProduct.getValue(), attribute);
            if (options.size() == 0 && attribute.getId().equals(BugzillaOperation.resolve.getInputId()) && (options = configuration.getOptionValues(BugzillaAttribute.RESOLUTION, attributeProduct.getValue())) != null) {
                options.remove("DUPLICATE");
                options.remove("MOVED");
            }
            LinkedHashMap<String, String> newOptions = new LinkedHashMap<String, String>();
            for (String option : options) {
                newOptions.put(option, option);
            }
            return newOptions;
        }
        return super.getOptions(attribute);
    }
}

