/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.mylyn.internal.bugzilla.core.XmlCleaner;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AbstractReportFactory {
    public static final int RETURN_ALL_HITS = -1;
    private final InputStream inStream;
    private final String characterEncoding;

    public AbstractReportFactory(InputStream inStream, String encoding) {
        this.inStream = inStream;
        this.characterEncoding = encoding;
    }

    protected void collectResults(DefaultHandler contentHandler, boolean clean) throws IOException {
        if (this.inStream == null) {
            return;
        }
        final BufferedInputStream is = new BufferedInputStream(this.inStream, 1024);
        InputStream iis = new InputStream(){

            public int read() throws IOException {
                int c;
                while ((c = is.read()) != -1) {
                    if (!XmlStringConverter.isValid((char)((char)c))) continue;
                    return c;
                }
                return -1;
            }
        };
        Reader in = this.characterEncoding != null ? new InputStreamReader(iis, this.characterEncoding) : new InputStreamReader(iis);
        if (clean) {
            StringBuffer result = XmlCleaner.clean(in);
            StringReader strReader = new StringReader(result.toString());
            in = new BufferedReader(strReader);
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(contentHandler);
            EntityResolver resolver = new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource source = new InputSource();
                    source.setCharacterStream(new StringReader(""));
                    return source;
                }
            };
            reader.setEntityResolver(resolver);
            reader.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            reader.parse(new InputSource(in));
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }
}

